/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.tp.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.api.WxErrorExceptionHandler;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.cp.bean.message.WxCpTpXmlMessage;
import me.chanjar.weixin.cp.bean.message.WxCpXmlOutMessage;
import me.chanjar.weixin.cp.message.WxCpMessageMatcher;
import me.chanjar.weixin.cp.tp.message.WxCpTpMessageHandler;
import me.chanjar.weixin.cp.tp.message.WxCpTpMessageInterceptor;
import me.chanjar.weixin.cp.tp.message.WxCpTpMessageRouter;
import me.chanjar.weixin.cp.tp.service.WxCpTpService;

public class WxCpTpMessageRouterRule {
    private final WxCpTpMessageRouter routerBuilder;
    private boolean async = true;
    private WxCpMessageMatcher matcher;
    private boolean reEnter = false;
    private List<WxCpTpMessageHandler> handlers = new ArrayList<WxCpTpMessageHandler>();
    private List<WxCpTpMessageInterceptor> interceptors = new ArrayList<WxCpTpMessageInterceptor>();
    private String suiteId;
    private String infoType;
    private String authCode;
    private String suiteTicket;

    protected WxCpTpMessageRouterRule(WxCpTpMessageRouter routerBuilder) {
        this.routerBuilder = routerBuilder;
    }

    public WxCpTpMessageRouterRule async(boolean async) {
        this.async = async;
        return this;
    }

    public WxCpTpMessageRouterRule matcher(WxCpMessageMatcher matcher) {
        this.matcher = matcher;
        return this;
    }

    public WxCpTpMessageRouterRule interceptor(WxCpTpMessageInterceptor interceptor) {
        return this.interceptor(interceptor, null);
    }

    public WxCpTpMessageRouterRule interceptor(WxCpTpMessageInterceptor interceptor, WxCpTpMessageInterceptor ... otherInterceptors) {
        this.interceptors.add(interceptor);
        if (otherInterceptors != null && otherInterceptors.length > 0) {
            Collections.addAll(this.interceptors, otherInterceptors);
        }
        return this;
    }

    public WxCpTpMessageRouterRule handler(WxCpTpMessageHandler handler) {
        return this.handler(handler, null);
    }

    public WxCpTpMessageRouterRule handler(WxCpTpMessageHandler handler, WxCpTpMessageHandler ... otherHandlers) {
        this.handlers.add(handler);
        if (otherHandlers != null && otherHandlers.length > 0) {
            Collections.addAll(this.handlers, otherHandlers);
        }
        return this;
    }

    public WxCpTpMessageRouter end() {
        this.routerBuilder.getRules().add(this);
        return this.routerBuilder;
    }

    public WxCpTpMessageRouter next() {
        this.reEnter = true;
        return this.end();
    }

    protected boolean test(WxCpTpXmlMessage wxMessage) {
        return !(this.suiteId != null && !this.suiteId.equals(wxMessage.getSuiteId()) || this.infoType != null && !this.infoType.equals(wxMessage.getInfoType()) || this.suiteTicket != null && !this.suiteTicket.equalsIgnoreCase(wxMessage.getSuiteTicket()) || this.authCode != null && !this.authCode.equalsIgnoreCase(wxMessage.getAuthCode()));
    }

    protected WxCpXmlOutMessage service(WxCpTpXmlMessage wxMessage, Map<String, Object> context, WxCpTpService wxCpService, WxSessionManager sessionManager, WxErrorExceptionHandler exceptionHandler) {
        if (context == null) {
            context = new HashMap<String, Object>(2);
        }
        try {
            for (WxCpTpMessageInterceptor interceptor : this.interceptors) {
                if (interceptor.intercept(wxMessage, context, wxCpService, sessionManager)) continue;
                return null;
            }
            WxCpXmlOutMessage res = null;
            for (WxCpTpMessageHandler handler : this.handlers) {
                res = handler.handle(wxMessage, context, wxCpService, sessionManager);
            }
            return res;
        }
        catch (WxErrorException e) {
            exceptionHandler.handle(e);
            return null;
        }
    }

    public WxCpTpMessageRouter getRouterBuilder() {
        return this.routerBuilder;
    }

    public boolean isAsync() {
        return this.async;
    }

    public WxCpMessageMatcher getMatcher() {
        return this.matcher;
    }

    public boolean isReEnter() {
        return this.reEnter;
    }

    public List<WxCpTpMessageHandler> getHandlers() {
        return this.handlers;
    }

    public List<WxCpTpMessageInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public String getSuiteId() {
        return this.suiteId;
    }

    public String getInfoType() {
        return this.infoType;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public String getSuiteTicket() {
        return this.suiteTicket;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void setMatcher(WxCpMessageMatcher matcher) {
        this.matcher = matcher;
    }

    public void setReEnter(boolean reEnter) {
        this.reEnter = reEnter;
    }

    public void setHandlers(List<WxCpTpMessageHandler> handlers) {
        this.handlers = handlers;
    }

    public void setInterceptors(List<WxCpTpMessageInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void setSuiteId(String suiteId) {
        this.suiteId = suiteId;
    }

    public void setInfoType(String infoType) {
        this.infoType = infoType;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public void setSuiteTicket(String suiteTicket) {
        this.suiteTicket = suiteTicket;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxCpTpMessageRouterRule)) {
            return false;
        }
        WxCpTpMessageRouterRule other = (WxCpTpMessageRouterRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WxCpTpMessageRouter this$routerBuilder = this.getRouterBuilder();
        WxCpTpMessageRouter other$routerBuilder = other.getRouterBuilder();
        if (this$routerBuilder == null ? other$routerBuilder != null : !this$routerBuilder.equals(other$routerBuilder)) {
            return false;
        }
        if (this.isAsync() != other.isAsync()) {
            return false;
        }
        WxCpMessageMatcher this$matcher = this.getMatcher();
        WxCpMessageMatcher other$matcher = other.getMatcher();
        if (this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher)) {
            return false;
        }
        if (this.isReEnter() != other.isReEnter()) {
            return false;
        }
        List<WxCpTpMessageHandler> this$handlers = this.getHandlers();
        List<WxCpTpMessageHandler> other$handlers = other.getHandlers();
        if (this$handlers == null ? other$handlers != null : !((Object)this$handlers).equals(other$handlers)) {
            return false;
        }
        List<WxCpTpMessageInterceptor> this$interceptors = this.getInterceptors();
        List<WxCpTpMessageInterceptor> other$interceptors = other.getInterceptors();
        if (this$interceptors == null ? other$interceptors != null : !((Object)this$interceptors).equals(other$interceptors)) {
            return false;
        }
        String this$suiteId = this.getSuiteId();
        String other$suiteId = other.getSuiteId();
        if (this$suiteId == null ? other$suiteId != null : !this$suiteId.equals(other$suiteId)) {
            return false;
        }
        String this$infoType = this.getInfoType();
        String other$infoType = other.getInfoType();
        if (this$infoType == null ? other$infoType != null : !this$infoType.equals(other$infoType)) {
            return false;
        }
        String this$authCode = this.getAuthCode();
        String other$authCode = other.getAuthCode();
        if (this$authCode == null ? other$authCode != null : !this$authCode.equals(other$authCode)) {
            return false;
        }
        String this$suiteTicket = this.getSuiteTicket();
        String other$suiteTicket = other.getSuiteTicket();
        return !(this$suiteTicket == null ? other$suiteTicket != null : !this$suiteTicket.equals(other$suiteTicket));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxCpTpMessageRouterRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WxCpTpMessageRouter $routerBuilder = this.getRouterBuilder();
        result = result * 59 + ($routerBuilder == null ? 43 : $routerBuilder.hashCode());
        result = result * 59 + (this.isAsync() ? 79 : 97);
        WxCpMessageMatcher $matcher = this.getMatcher();
        result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
        result = result * 59 + (this.isReEnter() ? 79 : 97);
        List<WxCpTpMessageHandler> $handlers = this.getHandlers();
        result = result * 59 + ($handlers == null ? 43 : ((Object)$handlers).hashCode());
        List<WxCpTpMessageInterceptor> $interceptors = this.getInterceptors();
        result = result * 59 + ($interceptors == null ? 43 : ((Object)$interceptors).hashCode());
        String $suiteId = this.getSuiteId();
        result = result * 59 + ($suiteId == null ? 43 : $suiteId.hashCode());
        String $infoType = this.getInfoType();
        result = result * 59 + ($infoType == null ? 43 : $infoType.hashCode());
        String $authCode = this.getAuthCode();
        result = result * 59 + ($authCode == null ? 43 : $authCode.hashCode());
        String $suiteTicket = this.getSuiteTicket();
        result = result * 59 + ($suiteTicket == null ? 43 : $suiteTicket.hashCode());
        return result;
    }

    public String toString() {
        return "WxCpTpMessageRouterRule(routerBuilder=" + this.getRouterBuilder() + ", async=" + this.isAsync() + ", matcher=" + this.getMatcher() + ", reEnter=" + this.isReEnter() + ", handlers=" + this.getHandlers() + ", interceptors=" + this.getInterceptors() + ", suiteId=" + this.getSuiteId() + ", infoType=" + this.getInfoType() + ", authCode=" + this.getAuthCode() + ", suiteTicket=" + this.getSuiteTicket() + ")";
    }
}

