/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.tp.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import me.chanjar.weixin.common.api.WxErrorExceptionHandler;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.cp.bean.message.WxCpTpXmlMessage;
import me.chanjar.weixin.cp.bean.message.WxCpXmlOutMessage;
import me.chanjar.weixin.cp.tp.message.WxCpTpMessageHandler;
import me.chanjar.weixin.cp.tp.message.WxCpTpMessageInterceptor;
import me.chanjar.weixin.cp.tp.message.WxCpTpMessageMatcher;
import me.chanjar.weixin.cp.tp.message.WxCpTpMessageRouter;
import me.chanjar.weixin.cp.tp.service.WxCpTpService;
import org.apache.commons.lang3.StringUtils;

public class WxCpTpMessageRouterRule {
    private final WxCpTpMessageRouter routerBuilder;
    private boolean async = true;
    private String fromUser;
    private String msgType;
    private String event;
    private String eventKey;
    private String eventKeyRegex;
    private String content;
    private String rContent;
    private WxCpTpMessageMatcher matcher;
    private boolean reEnter = false;
    private Integer agentId;
    private String infoType;
    private String changeType;
    private List<WxCpTpMessageHandler> handlers = new ArrayList<WxCpTpMessageHandler>();
    private List<WxCpTpMessageInterceptor> interceptors = new ArrayList<WxCpTpMessageInterceptor>();
    private String suiteId;
    private String authCode;
    private String suiteTicket;

    protected WxCpTpMessageRouterRule(WxCpTpMessageRouter routerBuilder) {
        this.routerBuilder = routerBuilder;
    }

    public WxCpTpMessageRouterRule async(boolean async) {
        this.async = async;
        return this;
    }

    public WxCpTpMessageRouterRule infoType(String infoType) {
        this.infoType = infoType;
        return this;
    }

    public WxCpTpMessageRouterRule changeType(String changeType) {
        this.changeType = changeType;
        return this;
    }

    public WxCpTpMessageRouterRule matcher(WxCpTpMessageMatcher matcher) {
        this.matcher = matcher;
        return this;
    }

    public WxCpTpMessageRouterRule interceptor(WxCpTpMessageInterceptor interceptor) {
        return this.interceptor(interceptor, null);
    }

    public WxCpTpMessageRouterRule interceptor(WxCpTpMessageInterceptor interceptor, WxCpTpMessageInterceptor ... otherInterceptors) {
        this.interceptors.add(interceptor);
        if (otherInterceptors != null && otherInterceptors.length > 0) {
            Collections.addAll(this.interceptors, otherInterceptors);
        }
        return this;
    }

    public WxCpTpMessageRouterRule handler(WxCpTpMessageHandler handler) {
        return this.handler(handler, null);
    }

    public WxCpTpMessageRouterRule handler(WxCpTpMessageHandler handler, WxCpTpMessageHandler ... otherHandlers) {
        this.handlers.add(handler);
        if (otherHandlers != null && otherHandlers.length > 0) {
            Collections.addAll(this.handlers, otherHandlers);
        }
        return this;
    }

    public WxCpTpMessageRouter end() {
        this.routerBuilder.getRules().add(this);
        return this.routerBuilder;
    }

    public WxCpTpMessageRouter next() {
        this.reEnter = true;
        return this.end();
    }

    protected boolean test(WxCpTpXmlMessage wxMessage) {
        return !(this.suiteId != null && !this.suiteId.equals(wxMessage.getSuiteId()) || this.fromUser != null && !this.fromUser.equals(wxMessage.getFromUserName()) || this.agentId != null && !this.agentId.equals(wxMessage.getAgentID()) || this.msgType != null && !this.msgType.equalsIgnoreCase(wxMessage.getMsgType()) || this.infoType != null && !this.infoType.equals(wxMessage.getInfoType()) || this.suiteTicket != null && !this.suiteTicket.equalsIgnoreCase(wxMessage.getSuiteTicket()) || this.eventKeyRegex != null && !Pattern.matches(this.eventKeyRegex, StringUtils.trimToEmpty((String)wxMessage.getEventKey())) || this.content != null && !this.content.equals(StringUtils.trimToNull((String)wxMessage.getContent())) || this.rContent != null && !Pattern.matches(this.rContent, StringUtils.trimToEmpty((String)wxMessage.getContent())) || this.infoType != null && !this.infoType.equals(wxMessage.getInfoType()) || this.changeType != null && !this.changeType.equals(wxMessage.getChangeType()) || this.matcher != null && !this.matcher.match(wxMessage) || this.authCode != null && !this.authCode.equalsIgnoreCase(wxMessage.getAuthCode()));
    }

    protected WxCpXmlOutMessage service(WxCpTpXmlMessage wxMessage, Map<String, Object> context, WxCpTpService wxCpService, WxSessionManager sessionManager, WxErrorExceptionHandler exceptionHandler) {
        if (context == null) {
            context = new HashMap<String, Object>(2);
        }
        try {
            for (WxCpTpMessageInterceptor interceptor : this.interceptors) {
                if (interceptor.intercept(wxMessage, context, wxCpService, sessionManager)) continue;
                return null;
            }
            WxCpXmlOutMessage res = null;
            for (WxCpTpMessageHandler handler : this.handlers) {
                res = handler.handle(wxMessage, context, wxCpService, sessionManager);
            }
            return res;
        }
        catch (WxErrorException e) {
            exceptionHandler.handle(e);
            return null;
        }
    }

    public WxCpTpMessageRouter getRouterBuilder() {
        return this.routerBuilder;
    }

    public boolean isAsync() {
        return this.async;
    }

    public String getFromUser() {
        return this.fromUser;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public String getEvent() {
        return this.event;
    }

    public String getEventKey() {
        return this.eventKey;
    }

    public String getEventKeyRegex() {
        return this.eventKeyRegex;
    }

    public String getContent() {
        return this.content;
    }

    public String getRContent() {
        return this.rContent;
    }

    public WxCpTpMessageMatcher getMatcher() {
        return this.matcher;
    }

    public boolean isReEnter() {
        return this.reEnter;
    }

    public Integer getAgentId() {
        return this.agentId;
    }

    public String getInfoType() {
        return this.infoType;
    }

    public String getChangeType() {
        return this.changeType;
    }

    public List<WxCpTpMessageHandler> getHandlers() {
        return this.handlers;
    }

    public List<WxCpTpMessageInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public String getSuiteId() {
        return this.suiteId;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public String getSuiteTicket() {
        return this.suiteTicket;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public void setFromUser(String fromUser) {
        this.fromUser = fromUser;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public void setEventKeyRegex(String eventKeyRegex) {
        this.eventKeyRegex = eventKeyRegex;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setRContent(String rContent) {
        this.rContent = rContent;
    }

    public void setMatcher(WxCpTpMessageMatcher matcher) {
        this.matcher = matcher;
    }

    public void setReEnter(boolean reEnter) {
        this.reEnter = reEnter;
    }

    public void setAgentId(Integer agentId) {
        this.agentId = agentId;
    }

    public void setInfoType(String infoType) {
        this.infoType = infoType;
    }

    public void setChangeType(String changeType) {
        this.changeType = changeType;
    }

    public void setHandlers(List<WxCpTpMessageHandler> handlers) {
        this.handlers = handlers;
    }

    public void setInterceptors(List<WxCpTpMessageInterceptor> interceptors) {
        this.interceptors = interceptors;
    }

    public void setSuiteId(String suiteId) {
        this.suiteId = suiteId;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public void setSuiteTicket(String suiteTicket) {
        this.suiteTicket = suiteTicket;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxCpTpMessageRouterRule)) {
            return false;
        }
        WxCpTpMessageRouterRule other = (WxCpTpMessageRouterRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        WxCpTpMessageRouter this$routerBuilder = this.getRouterBuilder();
        WxCpTpMessageRouter other$routerBuilder = other.getRouterBuilder();
        if (this$routerBuilder == null ? other$routerBuilder != null : !this$routerBuilder.equals(other$routerBuilder)) {
            return false;
        }
        if (this.isAsync() != other.isAsync()) {
            return false;
        }
        String this$fromUser = this.getFromUser();
        String other$fromUser = other.getFromUser();
        if (this$fromUser == null ? other$fromUser != null : !this$fromUser.equals(other$fromUser)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$event = this.getEvent();
        String other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        String this$eventKey = this.getEventKey();
        String other$eventKey = other.getEventKey();
        if (this$eventKey == null ? other$eventKey != null : !this$eventKey.equals(other$eventKey)) {
            return false;
        }
        String this$eventKeyRegex = this.getEventKeyRegex();
        String other$eventKeyRegex = other.getEventKeyRegex();
        if (this$eventKeyRegex == null ? other$eventKeyRegex != null : !this$eventKeyRegex.equals(other$eventKeyRegex)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$rContent = this.getRContent();
        String other$rContent = other.getRContent();
        if (this$rContent == null ? other$rContent != null : !this$rContent.equals(other$rContent)) {
            return false;
        }
        WxCpTpMessageMatcher this$matcher = this.getMatcher();
        WxCpTpMessageMatcher other$matcher = other.getMatcher();
        if (this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher)) {
            return false;
        }
        if (this.isReEnter() != other.isReEnter()) {
            return false;
        }
        Integer this$agentId = this.getAgentId();
        Integer other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !((Object)this$agentId).equals(other$agentId)) {
            return false;
        }
        String this$infoType = this.getInfoType();
        String other$infoType = other.getInfoType();
        if (this$infoType == null ? other$infoType != null : !this$infoType.equals(other$infoType)) {
            return false;
        }
        String this$changeType = this.getChangeType();
        String other$changeType = other.getChangeType();
        if (this$changeType == null ? other$changeType != null : !this$changeType.equals(other$changeType)) {
            return false;
        }
        List<WxCpTpMessageHandler> this$handlers = this.getHandlers();
        List<WxCpTpMessageHandler> other$handlers = other.getHandlers();
        if (this$handlers == null ? other$handlers != null : !((Object)this$handlers).equals(other$handlers)) {
            return false;
        }
        List<WxCpTpMessageInterceptor> this$interceptors = this.getInterceptors();
        List<WxCpTpMessageInterceptor> other$interceptors = other.getInterceptors();
        if (this$interceptors == null ? other$interceptors != null : !((Object)this$interceptors).equals(other$interceptors)) {
            return false;
        }
        String this$suiteId = this.getSuiteId();
        String other$suiteId = other.getSuiteId();
        if (this$suiteId == null ? other$suiteId != null : !this$suiteId.equals(other$suiteId)) {
            return false;
        }
        String this$authCode = this.getAuthCode();
        String other$authCode = other.getAuthCode();
        if (this$authCode == null ? other$authCode != null : !this$authCode.equals(other$authCode)) {
            return false;
        }
        String this$suiteTicket = this.getSuiteTicket();
        String other$suiteTicket = other.getSuiteTicket();
        return !(this$suiteTicket == null ? other$suiteTicket != null : !this$suiteTicket.equals(other$suiteTicket));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxCpTpMessageRouterRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WxCpTpMessageRouter $routerBuilder = this.getRouterBuilder();
        result = result * 59 + ($routerBuilder == null ? 43 : $routerBuilder.hashCode());
        result = result * 59 + (this.isAsync() ? 79 : 97);
        String $fromUser = this.getFromUser();
        result = result * 59 + ($fromUser == null ? 43 : $fromUser.hashCode());
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        String $eventKey = this.getEventKey();
        result = result * 59 + ($eventKey == null ? 43 : $eventKey.hashCode());
        String $eventKeyRegex = this.getEventKeyRegex();
        result = result * 59 + ($eventKeyRegex == null ? 43 : $eventKeyRegex.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $rContent = this.getRContent();
        result = result * 59 + ($rContent == null ? 43 : $rContent.hashCode());
        WxCpTpMessageMatcher $matcher = this.getMatcher();
        result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
        result = result * 59 + (this.isReEnter() ? 79 : 97);
        Integer $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : ((Object)$agentId).hashCode());
        String $infoType = this.getInfoType();
        result = result * 59 + ($infoType == null ? 43 : $infoType.hashCode());
        String $changeType = this.getChangeType();
        result = result * 59 + ($changeType == null ? 43 : $changeType.hashCode());
        List<WxCpTpMessageHandler> $handlers = this.getHandlers();
        result = result * 59 + ($handlers == null ? 43 : ((Object)$handlers).hashCode());
        List<WxCpTpMessageInterceptor> $interceptors = this.getInterceptors();
        result = result * 59 + ($interceptors == null ? 43 : ((Object)$interceptors).hashCode());
        String $suiteId = this.getSuiteId();
        result = result * 59 + ($suiteId == null ? 43 : $suiteId.hashCode());
        String $authCode = this.getAuthCode();
        result = result * 59 + ($authCode == null ? 43 : $authCode.hashCode());
        String $suiteTicket = this.getSuiteTicket();
        result = result * 59 + ($suiteTicket == null ? 43 : $suiteTicket.hashCode());
        return result;
    }

    public String toString() {
        return "WxCpTpMessageRouterRule(routerBuilder=" + this.getRouterBuilder() + ", async=" + this.isAsync() + ", fromUser=" + this.getFromUser() + ", msgType=" + this.getMsgType() + ", event=" + this.getEvent() + ", eventKey=" + this.getEventKey() + ", eventKeyRegex=" + this.getEventKeyRegex() + ", content=" + this.getContent() + ", rContent=" + this.getRContent() + ", matcher=" + this.getMatcher() + ", reEnter=" + this.isReEnter() + ", agentId=" + this.getAgentId() + ", infoType=" + this.getInfoType() + ", changeType=" + this.getChangeType() + ", handlers=" + this.getHandlers() + ", interceptors=" + this.getInterceptors() + ", suiteId=" + this.getSuiteId() + ", authCode=" + this.getAuthCode() + ", suiteTicket=" + this.getSuiteTicket() + ")";
    }
}

