/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.message;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import me.chanjar.weixin.common.api.WxErrorExceptionHandler;
import me.chanjar.weixin.common.api.WxMessageDuplicateChecker;
import me.chanjar.weixin.common.api.WxMessageInMemoryDuplicateChecker;
import me.chanjar.weixin.common.session.InternalSession;
import me.chanjar.weixin.common.session.InternalSessionManager;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.common.util.LogExceptionHandler;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.message.WxCpXmlMessage;
import me.chanjar.weixin.cp.bean.message.WxCpXmlOutMessage;
import me.chanjar.weixin.cp.message.WxCpMessageRouterRule;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxCpMessageRouter {
    private static final Logger log = LoggerFactory.getLogger(WxCpMessageRouter.class);
    private static final int DEFAULT_THREAD_POOL_SIZE = 100;
    private final List<WxCpMessageRouterRule> rules = new ArrayList<WxCpMessageRouterRule>();
    private final WxCpService wxCpService;
    private ExecutorService executorService;
    private WxMessageDuplicateChecker messageDuplicateChecker;
    private WxSessionManager sessionManager;
    private WxErrorExceptionHandler exceptionHandler;

    public WxCpMessageRouter(WxCpService wxCpService) {
        this.wxCpService = wxCpService;
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("WxCpMessageRouter-pool-%d").build();
        this.executorService = new ThreadPoolExecutor(100, 100, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
        this.messageDuplicateChecker = new WxMessageInMemoryDuplicateChecker();
        this.sessionManager = wxCpService.getSessionManager();
        this.exceptionHandler = new LogExceptionHandler();
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setMessageDuplicateChecker(WxMessageDuplicateChecker messageDuplicateChecker) {
        this.messageDuplicateChecker = messageDuplicateChecker;
    }

    public void setSessionManager(WxSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setExceptionHandler(WxErrorExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    List<WxCpMessageRouterRule> getRules() {
        return this.rules;
    }

    public WxCpMessageRouterRule rule() {
        return new WxCpMessageRouterRule(this);
    }

    public WxCpXmlOutMessage route(WxCpXmlMessage wxMessage, Map<String, Object> context) {
        if (this.isMsgDuplicated(wxMessage)) {
            return null;
        }
        ArrayList<WxCpMessageRouterRule> matchRules = new ArrayList<WxCpMessageRouterRule>();
        for (WxCpMessageRouterRule rule : this.rules) {
            if (!rule.test(wxMessage)) continue;
            matchRules.add(rule);
            if (rule.isReEnter()) continue;
            break;
        }
        if (matchRules.size() == 0) {
            return null;
        }
        WxCpXmlOutMessage res = null;
        ArrayList futures = new ArrayList();
        for (WxCpMessageRouterRule rule : matchRules) {
            if (rule.isAsync()) {
                futures.add(this.executorService.submit(() -> rule.service(wxMessage, context, this.wxCpService, this.sessionManager, this.exceptionHandler)));
                continue;
            }
            res = rule.service(wxMessage, context, this.wxCpService, this.sessionManager, this.exceptionHandler);
            log.debug("End session access: async=false, sessionId={}", (Object)wxMessage.getFromUserName());
            this.sessionEndAccess(wxMessage);
        }
        if (futures.size() > 0) {
            this.executorService.submit(() -> {
                for (Future future : futures) {
                    try {
                        future.get();
                        log.debug("End session access: async=true, sessionId={}", (Object)wxMessage.getFromUserName());
                        this.sessionEndAccess(wxMessage);
                    }
                    catch (InterruptedException e) {
                        log.error("Error happened when wait task finish", (Throwable)e);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        log.error("Error happened when wait task finish", (Throwable)e);
                    }
                }
            });
        }
        return res;
    }

    public WxCpXmlOutMessage route(WxCpXmlMessage wxMessage) {
        return this.route(wxMessage, new HashMap<String, Object>(2));
    }

    private boolean isMsgDuplicated(WxCpXmlMessage wxMessage) {
        StringBuilder messageId = new StringBuilder();
        if (wxMessage.getMsgId() == null) {
            messageId.append(wxMessage.getCreateTime()).append("-").append(StringUtils.trimToEmpty((String)String.valueOf(wxMessage.getAgentId()))).append("-").append(wxMessage.getFromUserName()).append("-").append(StringUtils.trimToEmpty((String)wxMessage.getEventKey())).append("-").append(StringUtils.trimToEmpty((String)wxMessage.getEvent()));
        } else {
            messageId.append(wxMessage.getMsgId()).append("-").append(wxMessage.getCreateTime()).append("-").append(wxMessage.getFromUserName());
        }
        this.append(messageId, wxMessage.getUserId());
        this.append(messageId, wxMessage.getChangeType());
        this.append(messageId, wxMessage.getTagId());
        this.append(messageId, wxMessage.getId());
        this.append(messageId, wxMessage.getChatId());
        this.append(messageId, wxMessage.getExternalUserId());
        return this.messageDuplicateChecker.isDuplicate(messageId.toString());
    }

    private void append(StringBuilder sb, String value) {
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            sb.append("-").append(value);
        }
    }

    private void sessionEndAccess(WxCpXmlMessage wxMessage) {
        InternalSession session = ((InternalSessionManager)this.sessionManager).findSession(wxMessage.getFromUserName());
        if (session != null) {
            session.endAccess();
        }
    }
}

