/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpMeetingService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.oa.meeting.WxCpMeeting;
import me.chanjar.weixin.cp.bean.oa.meeting.WxCpMeetingUpdateResult;
import me.chanjar.weixin.cp.bean.oa.meeting.WxCpUserMeetingIdResult;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;

public class WxCpMeetingServiceImpl
implements WxCpMeetingService {
    private final WxCpService cpService;

    @Override
    public String create(WxCpMeeting meeting) throws WxErrorException {
        return this.cpService.post(this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/meeting/create"), WxCpGsonBuilder.create().toJson((Object)meeting));
    }

    @Override
    public WxCpMeetingUpdateResult update(WxCpMeeting meeting) throws WxErrorException {
        String response = this.cpService.post(this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/meeting/update"), WxCpGsonBuilder.create().toJson((Object)meeting));
        return (WxCpMeetingUpdateResult)WxCpGsonBuilder.create().fromJson(response, WxCpMeetingUpdateResult.class);
    }

    @Override
    public void cancel(String meetingId) throws WxErrorException {
        this.cpService.post(this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/meeting/cancel"), WxCpGsonBuilder.create().toJson((Object)ImmutableMap.of((Object)"meetingid", (Object)meetingId)));
    }

    @Override
    public WxCpMeeting getDetail(String meetingId) throws WxErrorException {
        String response = this.cpService.post(this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/meeting/get_info"), WxCpGsonBuilder.create().toJson((Object)ImmutableMap.of((Object)"meetingid", (Object)meetingId)));
        return (WxCpMeeting)WxCpGsonBuilder.create().fromJson(response, WxCpMeeting.class);
    }

    @Override
    public WxCpUserMeetingIdResult getUserMeetingIds(String userId, String cursor, Integer limit, Long beginTime, Long endTime) throws WxErrorException {
        HashMap<String, Object> param = new HashMap<String, Object>(3);
        param.put("userid", userId);
        if (cursor != null) {
            param.put("cursor", cursor);
        }
        if (limit != null) {
            param.put("limit", limit);
        }
        if (limit != null) {
            param.put("begin_time", beginTime);
        }
        if (limit != null) {
            param.put("end_time", endTime);
        }
        String response = this.cpService.post(this.cpService.getWxCpConfigStorage().getApiUrl("/cgi-bin/meeting/get_user_meetingid"), WxCpGsonBuilder.create().toJson(param));
        return (WxCpUserMeetingIdResult)WxCpGsonBuilder.create().fromJson(response, WxCpUserMeetingIdResult.class);
    }

    public WxCpMeetingServiceImpl(WxCpService cpService) {
        this.cpService = cpService;
    }
}

