/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.tp.service.impl;

import com.google.gson.JsonObject;
import lombok.NonNull;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.cp.bean.oa.WxCpApprovalDetailResult;
import me.chanjar.weixin.cp.bean.oa.WxCpOaApplyEventRequest;
import me.chanjar.weixin.cp.bean.oa.WxCpOaApprovalTemplateResult;
import me.chanjar.weixin.cp.tp.service.WxCpTpOAService;
import me.chanjar.weixin.cp.tp.service.WxCpTpService;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;

public class WxCpTpOAServiceImpl
implements WxCpTpOAService {
    private final WxCpTpService mainService;

    @Override
    public String apply(WxCpOaApplyEventRequest request, String corpId) throws WxErrorException {
        String url = this.mainService.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/oa/applyevent") + "?access_token=" + this.mainService.getWxCpTpConfigStorage().getAccessToken(corpId);
        String responseContent = this.mainService.post(url, request.toJson());
        return GsonParser.parse((String)responseContent).get("sp_no").getAsString();
    }

    @Override
    public WxCpOaApprovalTemplateResult getTemplateDetail(@NonNull String templateId, String corpId) throws WxErrorException {
        if (templateId == null) {
            throw new NullPointerException("templateId is marked non-null but is null");
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("template_id", templateId);
        String url = this.mainService.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/oa/gettemplatedetail") + "?access_token=" + this.mainService.getWxCpTpConfigStorage().getAccessToken(corpId);
        String responseContent = this.mainService.post(url, jsonObject.toString());
        return (WxCpOaApprovalTemplateResult)WxCpGsonBuilder.create().fromJson(responseContent, WxCpOaApprovalTemplateResult.class);
    }

    @Override
    public String copyTemplate(@NonNull String openTemplateId, String corpId) throws WxErrorException {
        if (openTemplateId == null) {
            throw new NullPointerException("openTemplateId is marked non-null but is null");
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("open_template_id", openTemplateId);
        String url = this.mainService.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/oa/approval/copytemplate") + "?access_token=" + this.mainService.getWxCpTpConfigStorage().getAccessToken(corpId);
        String responseContent = this.mainService.post(url, jsonObject.toString());
        return GsonParser.parse((String)responseContent).get("template_id").getAsString();
    }

    @Override
    public WxCpApprovalDetailResult getApprovalDetail(@NonNull String spNo, String corpId) throws WxErrorException {
        if (spNo == null) {
            throw new NullPointerException("spNo is marked non-null but is null");
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("sp_no", spNo);
        String url = this.mainService.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/oa/getapprovaldetail") + "?access_token=" + this.mainService.getWxCpTpConfigStorage().getAccessToken(corpId);
        String responseContent = this.mainService.post(url, jsonObject.toString());
        return (WxCpApprovalDetailResult)WxCpGsonBuilder.create().fromJson(responseContent, WxCpApprovalDetailResult.class);
    }

    public WxCpTpOAServiceImpl(WxCpTpService mainService) {
        this.mainService = mainService;
    }
}

