/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.tp.service.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.cp.bean.WxCpTpTag;
import me.chanjar.weixin.cp.bean.WxCpTpTagAddOrRemoveUsersResult;
import me.chanjar.weixin.cp.bean.WxCpTpTagGetResult;
import me.chanjar.weixin.cp.config.WxCpTpConfigStorage;
import me.chanjar.weixin.cp.tp.service.WxCpTpService;
import me.chanjar.weixin.cp.tp.service.WxCpTpTagService;
import me.chanjar.weixin.cp.util.json.WxCpGsonBuilder;

public class WxCpTpTagServiceImpl
implements WxCpTpTagService {
    private final WxCpTpService mainService;

    @Override
    public String create(String name, Integer id) throws WxErrorException {
        JsonObject o = new JsonObject();
        o.addProperty("tagname", name);
        if (id != null) {
            o.addProperty("tagid", (Number)id);
        }
        return this.create(o);
    }

    private String create(JsonObject param) throws WxErrorException {
        String url = this.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/tag/create");
        String responseContent = this.mainService.post(url, param.toString());
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        return jsonObject.get("tagid").getAsString();
    }

    @Override
    public void update(String tagId, String tagName) throws WxErrorException {
        String url = this.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/tag/update");
        JsonObject o = new JsonObject();
        o.addProperty("tagid", tagId);
        o.addProperty("tagname", tagName);
        this.mainService.post(url, o.toString());
    }

    @Override
    public void delete(String tagId) throws WxErrorException {
        String url = String.format(this.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/tag/delete?tagid=%s"), tagId);
        this.mainService.get(url, null);
    }

    @Override
    public List<WxCpTpTag> listAll() throws WxErrorException {
        String url = this.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/tag/list");
        String responseContent = this.mainService.get(url, null);
        JsonObject tmpJson = GsonParser.parse((String)responseContent);
        return (List)WxCpGsonBuilder.create().fromJson(tmpJson.get("taglist"), new TypeToken<List<WxCpTpTag>>(){}.getType());
    }

    @Override
    public WxCpTpTagGetResult get(String tagId) throws WxErrorException {
        if (tagId == null) {
            throw new IllegalArgumentException("\u7f3a\u5c11tagId\u53c2\u6570");
        }
        String url = String.format(this.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/tag/get?tagid=%s"), tagId);
        String responseContent = this.mainService.get(url, null);
        return WxCpTpTagGetResult.deserialize(responseContent);
    }

    @Override
    public WxCpTpTagAddOrRemoveUsersResult addUsers2Tag(String tagId, List<String> userIds, List<String> partyIds) throws WxErrorException {
        String url = this.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/tag/addtagusers");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("tagid", tagId);
        this.addUserIdsAndPartyIdsToJson(userIds, partyIds, jsonObject);
        return WxCpTpTagAddOrRemoveUsersResult.deserialize(this.mainService.post(url, jsonObject.toString()));
    }

    @Override
    public WxCpTpTagAddOrRemoveUsersResult removeUsersFromTag(String tagId, List<String> userIds, List<String> partyIds) throws WxErrorException {
        String url = this.getWxCpTpConfigStorage().getApiUrl("/cgi-bin/tag/deltagusers");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("tagid", tagId);
        this.addUserIdsAndPartyIdsToJson(userIds, partyIds, jsonObject);
        return WxCpTpTagAddOrRemoveUsersResult.deserialize(this.mainService.post(url, jsonObject.toString()));
    }

    private void addUserIdsAndPartyIdsToJson(List<String> userIds, List<String> partyIds, JsonObject jsonObject) {
        JsonArray jsonArray;
        if (userIds != null) {
            jsonArray = new JsonArray();
            for (String userId : userIds) {
                jsonArray.add((JsonElement)new JsonPrimitive(userId));
            }
            jsonObject.add("userlist", (JsonElement)jsonArray);
        }
        if (partyIds != null) {
            jsonArray = new JsonArray();
            for (String userId : partyIds) {
                jsonArray.add((JsonElement)new JsonPrimitive(userId));
            }
            jsonObject.add("partylist", (JsonElement)jsonArray);
        }
    }

    private WxCpTpConfigStorage getWxCpTpConfigStorage() {
        return this.mainService.getWxCpTpConfigStorage();
    }

    public WxCpTpTagServiceImpl(WxCpTpService mainService) {
        this.mainService = mainService;
    }
}

