/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.api.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import lombok.NonNull;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.error.WxCpErrorMsgEnum;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.util.BeanUtils;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.MediaUploadRequestExecutor;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.cp.api.WxCpExternalContactService;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpBaseResp;
import me.chanjar.weixin.cp.bean.external.WxCpAddMomentResult;
import me.chanjar.weixin.cp.bean.external.WxCpAddMomentTask;
import me.chanjar.weixin.cp.bean.external.WxCpContactWayInfo;
import me.chanjar.weixin.cp.bean.external.WxCpContactWayResult;
import me.chanjar.weixin.cp.bean.external.WxCpExternalUserIdList;
import me.chanjar.weixin.cp.bean.external.WxCpGetMomentComments;
import me.chanjar.weixin.cp.bean.external.WxCpGetMomentCustomerList;
import me.chanjar.weixin.cp.bean.external.WxCpGetMomentList;
import me.chanjar.weixin.cp.bean.external.WxCpGetMomentSendResult;
import me.chanjar.weixin.cp.bean.external.WxCpGetMomentTask;
import me.chanjar.weixin.cp.bean.external.WxCpGetMomentTaskResult;
import me.chanjar.weixin.cp.bean.external.WxCpGroupJoinWayInfo;
import me.chanjar.weixin.cp.bean.external.WxCpGroupJoinWayResult;
import me.chanjar.weixin.cp.bean.external.WxCpGroupWelcomeTemplateResult;
import me.chanjar.weixin.cp.bean.external.WxCpMsgTemplate;
import me.chanjar.weixin.cp.bean.external.WxCpMsgTemplateAddResult;
import me.chanjar.weixin.cp.bean.external.WxCpNewExternalUserIdList;
import me.chanjar.weixin.cp.bean.external.WxCpProductAlbumInfo;
import me.chanjar.weixin.cp.bean.external.WxCpProductAlbumListResult;
import me.chanjar.weixin.cp.bean.external.WxCpProductAlbumResult;
import me.chanjar.weixin.cp.bean.external.WxCpUpdateRemarkRequest;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalContactList;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalGroupChatInfo;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalGroupChatList;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalGroupChatStatistic;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalGroupChatTransferResp;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalTagGroupInfo;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalTagGroupList;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalUnassignList;
import me.chanjar.weixin.cp.bean.external.WxCpUserExternalUserBehaviorStatistic;
import me.chanjar.weixin.cp.bean.external.WxCpUserTransferCustomerReq;
import me.chanjar.weixin.cp.bean.external.WxCpUserTransferCustomerResp;
import me.chanjar.weixin.cp.bean.external.WxCpUserTransferResultResp;
import me.chanjar.weixin.cp.bean.external.WxCpUserWithExternalPermission;
import me.chanjar.weixin.cp.bean.external.WxCpWelcomeMsg;
import me.chanjar.weixin.cp.bean.external.acquisition.WxCpCustomerAcquisitionCreateResult;
import me.chanjar.weixin.cp.bean.external.acquisition.WxCpCustomerAcquisitionCustomerList;
import me.chanjar.weixin.cp.bean.external.acquisition.WxCpCustomerAcquisitionInfo;
import me.chanjar.weixin.cp.bean.external.acquisition.WxCpCustomerAcquisitionList;
import me.chanjar.weixin.cp.bean.external.acquisition.WxCpCustomerAcquisitionQuota;
import me.chanjar.weixin.cp.bean.external.acquisition.WxCpCustomerAcquisitionRequest;
import me.chanjar.weixin.cp.bean.external.acquisition.WxCpCustomerAcquisitionStatistic;
import me.chanjar.weixin.cp.bean.external.contact.WxCpExternalContactBatchInfo;
import me.chanjar.weixin.cp.bean.external.contact.WxCpExternalContactInfo;
import me.chanjar.weixin.cp.bean.external.contact.WxCpGroupMsgListResult;
import me.chanjar.weixin.cp.bean.external.contact.WxCpGroupMsgResult;
import me.chanjar.weixin.cp.bean.external.contact.WxCpGroupMsgSendResult;
import me.chanjar.weixin.cp.bean.external.contact.WxCpGroupMsgTaskResult;
import me.chanjar.weixin.cp.bean.external.interceptrule.WxCpInterceptRule;
import me.chanjar.weixin.cp.bean.external.interceptrule.WxCpInterceptRuleAddRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class WxCpExternalContactServiceImpl
implements WxCpExternalContactService {
    private final WxCpService mainService;

    @Override
    public WxCpContactWayResult addContactWay(WxCpContactWayInfo info) throws WxErrorException {
        if (info.getContactWay().getUsers() != null && info.getContactWay().getUsers().size() > 100) {
            throw new WxRuntimeException("\u300c\u8054\u7cfb\u6211\u300d\u4f7f\u7528\u4eba\u6570\u9ed8\u8ba4\u9650\u5236\u4e0d\u8d85\u8fc7100\u4eba(\u5305\u62ec\u90e8\u95e8\u5c55\u5f00\u540e\u7684\u4eba\u6570)");
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/add_contact_way");
        return WxCpContactWayResult.fromJson(this.mainService.post(url, info.getContactWay().toJson()));
    }

    @Override
    public WxCpContactWayInfo getContactWay(String configId) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("config_id", configId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_contact_way");
        return WxCpContactWayInfo.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpBaseResp updateContactWay(WxCpContactWayInfo info) throws WxErrorException {
        if (StringUtils.isBlank((CharSequence)info.getContactWay().getConfigId())) {
            throw new WxRuntimeException("\u66f4\u65b0\u300c\u8054\u7cfb\u6211\u300d\u65b9\u5f0f\u9700\u8981\u6307\u5b9aconfigId");
        }
        if (info.getContactWay().getUsers() != null && info.getContactWay().getUsers().size() > 100) {
            throw new WxRuntimeException("\u300c\u8054\u7cfb\u6211\u300d\u4f7f\u7528\u4eba\u6570\u9ed8\u8ba4\u9650\u5236\u4e0d\u8d85\u8fc7100\u4eba(\u5305\u62ec\u90e8\u95e8\u5c55\u5f00\u540e\u7684\u4eba\u6570)");
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/update_contact_way");
        return WxCpBaseResp.fromJson(this.mainService.post(url, info.getContactWay().toJson()));
    }

    @Override
    public WxCpBaseResp deleteContactWay(String configId) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("config_id", configId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/del_contact_way");
        return WxCpBaseResp.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpBaseResp closeTempChat(String userId, String externalUserId) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("userid", userId);
        json.addProperty("external_userid", externalUserId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/close_temp_chat");
        return WxCpBaseResp.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpExternalContactInfo getExternalContact(String externalUserId) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/crm/get_external_contact?external_userid=" + externalUserId);
        return WxCpExternalContactInfo.fromJson(this.mainService.get(url, null));
    }

    @Override
    public WxCpExternalContactInfo getContactDetail(String externalUserId, String cursor) throws WxErrorException {
        String params = externalUserId;
        if (StringUtils.isNotEmpty((CharSequence)cursor)) {
            params = params + "&cursor=" + cursor;
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get?external_userid=" + params);
        return WxCpExternalContactInfo.fromJson(this.mainService.get(url, null));
    }

    @Override
    public String convertToOpenid(String externalUserId) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("external_userid", externalUserId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/convert_to_openid");
        String responseContent = this.mainService.post(url, json.toString());
        return GsonParser.parse((String)responseContent).get("openid").getAsString();
    }

    @Override
    public String unionidToExternalUserid(String unionid, String openid) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("unionid", unionid);
        if (StringUtils.isNotEmpty((CharSequence)openid)) {
            json.addProperty("openid", openid);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/unionid_to_external_userid");
        String responseContent = this.mainService.post(url, json.toString());
        return GsonParser.parse((String)responseContent).get("external_userid").getAsString();
    }

    @Override
    public String toServiceExternalUserid(String externalUserid) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("external_userid", externalUserid);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/to_service_external_userid");
        String responseContent = this.mainService.post(url, json.toString());
        return GsonParser.parse((String)responseContent).get("external_userid").getAsString();
    }

    @Override
    public String fromServiceExternalUserid(String externalUserid, String sourceAgentId) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("external_userid", externalUserid);
        json.addProperty("source_agentid", sourceAgentId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/from_service_external_userid");
        String responseContent = this.mainService.post(url, json.toString());
        return GsonParser.parse((String)responseContent).get("external_userid").getAsString();
    }

    @Override
    public WxCpExternalUserIdList unionidToExternalUserid3rd(String unionid, String openid, String corpid) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("unionid", unionid);
        json.addProperty("openid", openid);
        if (StringUtils.isNotEmpty((CharSequence)corpid)) {
            json.addProperty("corpid", corpid);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/service/externalcontact/unionid_to_external_userid_3rd");
        return WxCpExternalUserIdList.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpNewExternalUserIdList getNewExternalUserId(String[] externalUserIdList) throws WxErrorException {
        JsonObject json = new JsonObject();
        if (ArrayUtils.isNotEmpty((Object[])externalUserIdList)) {
            json.add("external_userid_list", (JsonElement)new Gson().toJsonTree((Object)externalUserIdList).getAsJsonArray());
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_new_external_userid");
        return WxCpNewExternalUserIdList.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpBaseResp finishExternalUserIdMigration(String corpid) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("corpid", corpid);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/finish_external_userid_migration");
        return WxCpBaseResp.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public String opengidToChatid(String opengid) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("opengid", opengid);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/opengid_to_chatid");
        String responseContent = this.mainService.post(url, json.toString());
        return GsonParser.parse((String)responseContent).get("chat_id").getAsString();
    }

    @Override
    public WxCpExternalContactBatchInfo getContactDetailBatch(String[] userIdList, String cursor, Integer limit) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/batch/get_by_user?");
        JsonObject json = new JsonObject();
        json.add("userid_list", (JsonElement)new Gson().toJsonTree((Object)userIdList).getAsJsonArray());
        if (StringUtils.isNotBlank((CharSequence)cursor)) {
            json.addProperty("cursor", cursor);
        }
        if (limit != null) {
            json.addProperty("limit", (Number)limit);
        }
        String responseContent = this.mainService.post(url, json.toString());
        return WxCpExternalContactBatchInfo.fromJson(responseContent);
    }

    @Override
    public void updateRemark(WxCpUpdateRemarkRequest request) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/remark");
        this.mainService.post(url, request.toJson());
    }

    @Override
    public List<String> listExternalContacts(String userId) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/list?userid=" + userId);
        try {
            String responseContent = this.mainService.get(url, null);
            return WxCpUserExternalContactList.fromJson(responseContent).getExternalUserId();
        }
        catch (WxErrorException e) {
            if (e.getError().getErrorCode() == WxCpErrorMsgEnum.CODE_84061.getCode()) {
                return Collections.emptyList();
            }
            throw e;
        }
    }

    @Override
    public List<String> listFollowers() throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_follow_user_list");
        String responseContent = this.mainService.get(url, null);
        return WxCpUserWithExternalPermission.fromJson(responseContent).getFollowers();
    }

    @Override
    public WxCpUserExternalUnassignList listUnassignedList(Integer pageIndex, String cursor, Integer pageSize) throws WxErrorException {
        JsonObject json = new JsonObject();
        if (pageIndex != null) {
            json.addProperty("page_id", (Number)pageIndex);
        }
        json.addProperty("cursor", StringUtils.isEmpty((CharSequence)cursor) ? "" : cursor);
        json.addProperty("page_size", (Number)(pageSize == null ? 1000 : pageSize));
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_unassigned_list");
        return WxCpUserExternalUnassignList.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpBaseResp transferExternalContact(String externalUserid, String handOverUserid, String takeOverUserid) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("external_userid", externalUserid);
        json.addProperty("handover_userid", handOverUserid);
        json.addProperty("takeover_userid", takeOverUserid);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/transfer");
        return WxCpBaseResp.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpUserTransferCustomerResp transferCustomer(WxCpUserTransferCustomerReq req) throws WxErrorException {
        BeanUtils.checkRequiredFields((Object)req);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/transfer_customer");
        String result = this.mainService.post(url, req.toJson());
        return WxCpUserTransferCustomerResp.fromJson(result);
    }

    @Override
    public WxCpUserTransferResultResp transferResult(String handOverUserid, String takeOverUserid, String cursor) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("cursor", cursor);
        json.addProperty("handover_userid", handOverUserid);
        json.addProperty("takeover_userid", takeOverUserid);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/transfer_result");
        return WxCpUserTransferResultResp.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpUserTransferCustomerResp resignedTransferCustomer(WxCpUserTransferCustomerReq req) throws WxErrorException {
        BeanUtils.checkRequiredFields((Object)req);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/resigned/transfer_customer");
        return WxCpUserTransferCustomerResp.fromJson(this.mainService.post(url, req.toJson()));
    }

    @Override
    public WxCpUserTransferResultResp resignedTransferResult(String handOverUserid, String takeOverUserid, String cursor) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("cursor", cursor);
        json.addProperty("handover_userid", handOverUserid);
        json.addProperty("takeover_userid", takeOverUserid);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/resigned/transfer_result");
        return WxCpUserTransferResultResp.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpUserExternalGroupChatList listGroupChat(Integer pageIndex, Integer pageSize, int status, String[] userIds, String[] partyIds) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("offset", (Number)(pageIndex == null ? 0 : pageIndex));
        json.addProperty("limit", (Number)(pageSize == null ? 100 : pageSize));
        json.addProperty("status_filter", (Number)status);
        if (ArrayUtils.isNotEmpty((Object[])userIds) || ArrayUtils.isNotEmpty((Object[])partyIds)) {
            JsonObject ownerFilter = new JsonObject();
            if (ArrayUtils.isNotEmpty((Object[])userIds)) {
                ownerFilter.add("userid_list", (JsonElement)new Gson().toJsonTree((Object)userIds).getAsJsonArray());
            }
            if (ArrayUtils.isNotEmpty((Object[])partyIds)) {
                ownerFilter.add("partyid_list", (JsonElement)new Gson().toJsonTree((Object)partyIds).getAsJsonArray());
            }
            json.add("owner_filter", (JsonElement)ownerFilter);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/list");
        return WxCpUserExternalGroupChatList.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpUserExternalGroupChatList listGroupChat(Integer limit, String cursor, int status, String[] userIds) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("cursor", cursor == null ? "" : cursor);
        json.addProperty("limit", (Number)(limit == null ? 100 : limit));
        json.addProperty("status_filter", (Number)status);
        if (ArrayUtils.isNotEmpty((Object[])userIds)) {
            JsonObject ownerFilter = new JsonObject();
            if (ArrayUtils.isNotEmpty((Object[])userIds)) {
                ownerFilter.add("userid_list", (JsonElement)new Gson().toJsonTree((Object)userIds).getAsJsonArray());
            }
            json.add("owner_filter", (JsonElement)ownerFilter);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/list");
        return WxCpUserExternalGroupChatList.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpUserExternalGroupChatInfo getGroupChat(String chatId, Integer needName) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("chat_id", chatId);
        json.addProperty("need_name", (Number)needName);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/get");
        return WxCpUserExternalGroupChatInfo.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpUserExternalGroupChatTransferResp transferGroupChat(String[] chatIds, String newOwner) throws WxErrorException {
        JsonObject json = new JsonObject();
        if (ArrayUtils.isNotEmpty((Object[])chatIds)) {
            json.add("chat_id_list", (JsonElement)new Gson().toJsonTree((Object)chatIds).getAsJsonArray());
        }
        json.addProperty("new_owner", newOwner);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/transfer");
        return WxCpUserExternalGroupChatTransferResp.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpUserExternalGroupChatTransferResp onjobTransferGroupChat(String[] chatIds, String newOwner) throws WxErrorException {
        JsonObject json = new JsonObject();
        if (ArrayUtils.isNotEmpty((Object[])chatIds)) {
            json.add("chat_id_list", (JsonElement)new Gson().toJsonTree((Object)chatIds).getAsJsonArray());
        }
        json.addProperty("new_owner", newOwner);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/onjob_transfer");
        return WxCpUserExternalGroupChatTransferResp.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpUserExternalUserBehaviorStatistic getUserBehaviorStatistic(Date startTime, Date endTime, String[] userIds, String[] partyIds) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("start_time", (Number)(startTime.getTime() / 1000L));
        json.addProperty("end_time", (Number)(endTime.getTime() / 1000L));
        if (ArrayUtils.isNotEmpty((Object[])userIds) || ArrayUtils.isNotEmpty((Object[])partyIds)) {
            if (ArrayUtils.isNotEmpty((Object[])userIds)) {
                json.add("userid", (JsonElement)new Gson().toJsonTree((Object)userIds).getAsJsonArray());
            }
            if (ArrayUtils.isNotEmpty((Object[])partyIds)) {
                json.add("partyid", (JsonElement)new Gson().toJsonTree((Object)partyIds).getAsJsonArray());
            }
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_user_behavior_data");
        return WxCpUserExternalUserBehaviorStatistic.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpUserExternalGroupChatStatistic getGroupChatStatistic(Date startTime, Integer orderBy, Integer orderAsc, Integer pageIndex, Integer pageSize, String[] userIds, String[] partyIds) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("day_begin_time", (Number)(startTime.getTime() / 1000L));
        json.addProperty("order_by", (Number)(orderBy == null ? 1 : orderBy));
        json.addProperty("order_asc", (Number)(orderAsc == null ? 0 : orderAsc));
        json.addProperty("offset", (Number)(pageIndex == null ? 0 : pageIndex));
        json.addProperty("limit", (Number)(pageSize == null ? 500 : pageSize));
        if (ArrayUtils.isNotEmpty((Object[])userIds) || ArrayUtils.isNotEmpty((Object[])partyIds)) {
            JsonObject ownerFilter = new JsonObject();
            if (ArrayUtils.isNotEmpty((Object[])userIds)) {
                ownerFilter.add("userid_list", (JsonElement)new Gson().toJsonTree((Object)userIds).getAsJsonArray());
            }
            if (ArrayUtils.isNotEmpty((Object[])partyIds)) {
                ownerFilter.add("partyid_list", (JsonElement)new Gson().toJsonTree((Object)partyIds).getAsJsonArray());
            }
            json.add("owner_filter", (JsonElement)ownerFilter);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/statistic");
        return WxCpUserExternalGroupChatStatistic.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpMsgTemplateAddResult addMsgTemplate(WxCpMsgTemplate wxCpMsgTemplate) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/add_msg_template");
        return WxCpMsgTemplateAddResult.fromJson(this.mainService.post(url, wxCpMsgTemplate.toJson()));
    }

    @Override
    public WxCpBaseResp remindGroupMsgSend(String msgId) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("msgid", msgId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/remind_groupmsg_send");
        return WxCpBaseResp.fromJson(this.mainService.post(url, params.toString()));
    }

    @Override
    public WxCpBaseResp cancelGroupMsgSend(String msgId) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("msgid", msgId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/cancel_groupmsg_send");
        return WxCpBaseResp.fromJson(this.mainService.post(url, params.toString()));
    }

    @Override
    public void sendWelcomeMsg(WxCpWelcomeMsg msg) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/send_welcome_msg");
        this.mainService.post(url, msg.toJson());
    }

    @Override
    public WxCpUserExternalTagGroupList getCorpTagList(String[] tagId) throws WxErrorException {
        JsonObject json = new JsonObject();
        if (ArrayUtils.isNotEmpty((Object[])tagId)) {
            json.add("tag_id", (JsonElement)new Gson().toJsonTree((Object)tagId).getAsJsonArray());
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_corp_tag_list");
        return WxCpUserExternalTagGroupList.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpUserExternalTagGroupList getCorpTagList(String[] tagId, String[] groupId) throws WxErrorException {
        JsonObject json = new JsonObject();
        if (ArrayUtils.isNotEmpty((Object[])tagId)) {
            json.add("tag_id", (JsonElement)new Gson().toJsonTree((Object)tagId).getAsJsonArray());
        }
        if (ArrayUtils.isNotEmpty((Object[])groupId)) {
            json.add("group_id", (JsonElement)new Gson().toJsonTree((Object)groupId).getAsJsonArray());
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_corp_tag_list");
        return WxCpUserExternalTagGroupList.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpUserExternalTagGroupInfo addCorpTag(WxCpUserExternalTagGroupInfo tagGroup) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/add_corp_tag");
        return WxCpUserExternalTagGroupInfo.fromJson(this.mainService.post(url, tagGroup.getTagGroup().toJson()));
    }

    @Override
    public WxCpBaseResp editCorpTag(String id, String name, Integer order) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("id", id);
        json.addProperty("name", name);
        json.addProperty("order", (Number)order);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/edit_corp_tag");
        return WxCpBaseResp.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpBaseResp delCorpTag(String[] tagId, String[] groupId) throws WxErrorException {
        JsonObject json = new JsonObject();
        if (ArrayUtils.isNotEmpty((Object[])tagId)) {
            json.add("tag_id", (JsonElement)new Gson().toJsonTree((Object)tagId).getAsJsonArray());
        }
        if (ArrayUtils.isNotEmpty((Object[])groupId)) {
            json.add("group_id", (JsonElement)new Gson().toJsonTree((Object)groupId).getAsJsonArray());
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/del_corp_tag");
        return WxCpBaseResp.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpBaseResp markTag(String userid, String externalUserid, String[] addTag, String[] removeTag) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("userid", userid);
        json.addProperty("external_userid", externalUserid);
        if (ArrayUtils.isNotEmpty((Object[])addTag)) {
            json.add("add_tag", (JsonElement)new Gson().toJsonTree((Object)addTag).getAsJsonArray());
        }
        if (ArrayUtils.isNotEmpty((Object[])removeTag)) {
            json.add("remove_tag", (JsonElement)new Gson().toJsonTree((Object)removeTag).getAsJsonArray());
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/mark_tag");
        return WxCpBaseResp.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpAddMomentResult addMomentTask(WxCpAddMomentTask task) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/add_moment_task");
        return WxCpAddMomentResult.fromJson(this.mainService.post(url, task.toJson()));
    }

    @Override
    public WxCpGetMomentTaskResult getMomentTaskResult(String jobId) throws WxErrorException {
        String params = "&jobid=" + jobId;
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_moment_task_result");
        return WxCpGetMomentTaskResult.fromJson(this.mainService.get(url, params));
    }

    @Override
    public WxCpGetMomentList getMomentList(Long startTime, Long endTime, String creator, Integer filterType, String cursor, Integer limit) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("start_time", (Number)startTime);
        json.addProperty("end_time", (Number)endTime);
        if (!StringUtils.isEmpty((CharSequence)creator)) {
            json.addProperty("creator", creator);
        }
        if (filterType != null) {
            json.addProperty("filter_type", (Number)filterType);
        }
        if (!StringUtils.isEmpty((CharSequence)cursor)) {
            json.addProperty("cursor", cursor);
        }
        if (limit != null) {
            json.addProperty("limit", (Number)limit);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_moment_list");
        return WxCpGetMomentList.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpGetMomentTask getMomentTask(String momentId, String cursor, Integer limit) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("moment_id", momentId);
        if (!StringUtils.isEmpty((CharSequence)cursor)) {
            json.addProperty("cursor", cursor);
        }
        if (limit != null) {
            json.addProperty("limit", (Number)limit);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_moment_task");
        return WxCpGetMomentTask.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpGetMomentCustomerList getMomentCustomerList(String momentId, String userId, String cursor, Integer limit) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("moment_id", momentId);
        json.addProperty("userid", userId);
        if (!StringUtils.isEmpty((CharSequence)cursor)) {
            json.addProperty("cursor", cursor);
        }
        if (limit != null) {
            json.addProperty("limit", (Number)limit);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_moment_customer_list");
        return WxCpGetMomentCustomerList.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpGetMomentSendResult getMomentSendResult(String momentId, String userId, String cursor, Integer limit) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("moment_id", momentId);
        json.addProperty("userid", userId);
        if (!StringUtils.isEmpty((CharSequence)cursor)) {
            json.addProperty("cursor", cursor);
        }
        if (limit != null) {
            json.addProperty("limit", (Number)limit);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_moment_send_result");
        return WxCpGetMomentSendResult.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpGetMomentComments getMomentComments(String momentId, String userId) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("moment_id", momentId);
        json.addProperty("userid", userId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_moment_comments");
        return WxCpGetMomentComments.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpGroupMsgListResult getGroupMsgListV2(String chatType, Date startTime, Date endTime, String creator, Integer filterType, Integer limit, String cursor) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("chat_type", chatType);
        json.addProperty("start_time", (Number)(startTime.getTime() / 1000L));
        json.addProperty("end_time", (Number)(endTime.getTime() / 1000L));
        json.addProperty("creator", creator);
        json.addProperty("filter_type", (Number)filterType);
        json.addProperty("limit", (Number)limit);
        json.addProperty("cursor", cursor);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_groupmsg_list_v2");
        return WxCpGroupMsgListResult.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpGroupMsgSendResult getGroupMsgSendResult(String msgid, String userid, Integer limit, String cursor) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("msgid", msgid);
        json.addProperty("userid", userid);
        json.addProperty("limit", (Number)limit);
        json.addProperty("cursor", cursor);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_groupmsg_send_result");
        return WxCpGroupMsgSendResult.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpGroupMsgResult getGroupMsgResult(String msgid, Integer limit, String cursor) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("msgid", msgid);
        json.addProperty("limit", (Number)limit);
        json.addProperty("cursor", cursor);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_group_msg_result");
        return WxCpGroupMsgResult.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpGroupMsgTaskResult getGroupMsgTask(String msgid, Integer limit, String cursor) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_groupmsg_task");
        return WxCpGroupMsgTaskResult.fromJson(this.mainService.post(url, GsonHelper.buildJsonObject((Object[])new Object[]{"msgid", msgid, "limit", limit, "cursor", cursor})));
    }

    @Override
    public String addGroupWelcomeTemplate(WxCpGroupWelcomeTemplateResult template) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/group_welcome_template/add");
        String responseContent = this.mainService.post(url, template.toJson());
        return GsonParser.parse((String)responseContent).get("template_id").getAsString();
    }

    @Override
    public WxCpBaseResp editGroupWelcomeTemplate(WxCpGroupWelcomeTemplateResult template) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/group_welcome_template/edit");
        return WxCpGroupWelcomeTemplateResult.fromJson(this.mainService.post(url, template.toJson()));
    }

    @Override
    public WxCpGroupWelcomeTemplateResult getGroupWelcomeTemplate(String templateId) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("template_id", templateId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/group_welcome_template/get");
        return WxCpGroupWelcomeTemplateResult.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpBaseResp delGroupWelcomeTemplate(String templateId, String agentId) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("template_id", templateId);
        if (!StringUtils.isEmpty((CharSequence)agentId)) {
            json.addProperty("agentid", agentId);
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/group_welcome_template/del");
        return WxCpBaseResp.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpProductAlbumListResult getProductAlbumList(Integer limit, String cursor) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("limit", (Number)limit);
        json.addProperty("cursor", cursor);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_product_album_list");
        return WxCpProductAlbumListResult.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxCpProductAlbumResult getProductAlbum(String productId) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("product_id", productId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/get_product_album");
        return WxCpProductAlbumResult.fromJson(this.mainService.post(url, json.toString()));
    }

    @Override
    public WxMediaUploadResult uploadAttachment(String mediaType, String fileType, Integer attachmentType, InputStream inputStream) throws WxErrorException, IOException {
        return this.uploadAttachment(mediaType, attachmentType, FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)fileType));
    }

    @Override
    public WxMediaUploadResult uploadAttachment(String mediaType, Integer attachmentType, File file) throws WxErrorException {
        String params = "?media_type=" + mediaType + "&attachment_type=" + attachmentType;
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/media/upload_attachment" + params);
        return (WxMediaUploadResult)this.mainService.execute(MediaUploadRequestExecutor.create(this.mainService.getRequestHttp()), url, file);
    }

    @Override
    public String addInterceptRule(WxCpInterceptRuleAddRequest ruleAddRequest) throws WxErrorException {
        String responseContent = this.mainService.post(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/add_intercept_rule"), ruleAddRequest);
        return GsonParser.parse((String)responseContent).get("rule_id").getAsString();
    }

    @Override
    public void updateInterceptRule(WxCpInterceptRule interceptRule) throws WxErrorException {
        this.mainService.post(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/update_intercept_rule"), interceptRule);
    }

    @Override
    public void delInterceptRule(String ruleId) throws WxErrorException {
        this.mainService.post(this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/del_intercept_rule"), GsonHelper.buildJsonObject((Object[])new Object[]{"rule_id", ruleId}));
    }

    @Override
    public String addProductAlbum(WxCpProductAlbumInfo wxCpProductAlbumInfo) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/add_product_album");
        String responseContent = this.mainService.post(url, wxCpProductAlbumInfo.toJson());
        return GsonParser.parse((String)responseContent).get("product_id").getAsString();
    }

    @Override
    public void updateProductAlbum(WxCpProductAlbumInfo wxCpProductAlbumInfo) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/update_product_album");
        this.mainService.post(url, wxCpProductAlbumInfo.toJson());
    }

    @Override
    public void deleteProductAlbum(String productId) throws WxErrorException {
        JsonObject o = new JsonObject();
        o.addProperty("product_id", productId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/delete_product_album");
        this.mainService.post(url, o.toString());
    }

    @Override
    public WxCpCustomerAcquisitionList customerAcquisitionLinkList(Integer limit, String cursor) throws WxErrorException {
        JsonObject o = new JsonObject();
        o.addProperty("limit", (Number)limit);
        o.addProperty("cursor", cursor);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/customer_acquisition/list_link");
        return WxCpCustomerAcquisitionList.fromJson(this.mainService.post(url, o));
    }

    @Override
    public WxCpCustomerAcquisitionInfo customerAcquisitionLinkGet(String linkId) throws WxErrorException {
        JsonObject o = new JsonObject();
        o.addProperty("link_id", linkId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/customer_acquisition/get");
        return WxCpCustomerAcquisitionInfo.fromJson(this.mainService.post(url, o));
    }

    @Override
    public WxCpCustomerAcquisitionCreateResult customerAcquisitionLinkCreate(WxCpCustomerAcquisitionRequest wxCpCustomerAcquisitionRequest) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/customer_acquisition/create_link");
        return WxCpCustomerAcquisitionCreateResult.fromJson(this.mainService.post(url, wxCpCustomerAcquisitionRequest.toJson()));
    }

    @Override
    public WxCpBaseResp customerAcquisitionUpdate(WxCpCustomerAcquisitionRequest wxCpCustomerAcquisitionRequest) throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/customer_acquisition/update_link");
        return WxCpBaseResp.fromJson(this.mainService.post(url, wxCpCustomerAcquisitionRequest.toJson()));
    }

    @Override
    public WxCpBaseResp customerAcquisitionLinkDelete(String linkId) throws WxErrorException {
        JsonObject o = new JsonObject();
        o.addProperty("link_id", linkId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/customer_acquisition/delete_link");
        return WxCpBaseResp.fromJson(this.mainService.post(url, o));
    }

    @Override
    public WxCpCustomerAcquisitionCustomerList customerAcquisitionCustomer(String linkId, Integer limit, String cursor) throws WxErrorException {
        JsonObject o = new JsonObject();
        o.addProperty("link_id", linkId);
        o.addProperty("limit", (Number)limit);
        o.addProperty("cursor", cursor);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/customer_acquisition/customer");
        return WxCpCustomerAcquisitionCustomerList.fromJson(this.mainService.post(url, o));
    }

    @Override
    public WxCpCustomerAcquisitionQuota customerAcquisitionQuota() throws WxErrorException {
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/customer_acquisition_quota");
        return WxCpCustomerAcquisitionQuota.fromJson(this.mainService.get(url, null));
    }

    @Override
    public WxCpCustomerAcquisitionStatistic customerAcquisitionStatistic(String linkId, @NonNull Date startTime, @NonNull Date endTime) throws WxErrorException {
        if (startTime == null) {
            throw new NullPointerException("startTime is marked non-null but is null");
        }
        if (endTime == null) {
            throw new NullPointerException("endTime is marked non-null but is null");
        }
        long endTimestamp = endTime.getTime() / 1000L;
        long startTimestamp = startTime.getTime() / 1000L;
        JsonObject o = new JsonObject();
        o.addProperty("link_id", linkId);
        o.addProperty("start_time", (Number)startTimestamp);
        o.addProperty("end_time", (Number)endTimestamp);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/customer_acquisition/statistic");
        return WxCpCustomerAcquisitionStatistic.fromJson(this.mainService.post(url, o));
    }

    @Override
    public WxCpGroupJoinWayResult addJoinWay(WxCpGroupJoinWayInfo wxCpGroupJoinWayInfo) throws WxErrorException {
        if (wxCpGroupJoinWayInfo.getJoinWay().getChatIdList() != null && wxCpGroupJoinWayInfo.getJoinWay().getChatIdList().size() > 5) {
            throw new WxRuntimeException("\u4f7f\u7528\u8be5\u914d\u7f6e\u7684\u5ba2\u6237\u7fa4ID\u5217\u8868\uff0c\u652f\u63015\u4e2a");
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/add_join_way");
        return WxCpGroupJoinWayResult.fromJson(this.mainService.post(url, wxCpGroupJoinWayInfo.getJoinWay().toJson()));
    }

    @Override
    public WxCpBaseResp updateJoinWay(WxCpGroupJoinWayInfo wxCpGroupJoinWayInfo) throws WxErrorException {
        if (wxCpGroupJoinWayInfo.getJoinWay().getChatIdList() != null && wxCpGroupJoinWayInfo.getJoinWay().getChatIdList().size() > 5) {
            throw new WxRuntimeException("\u4f7f\u7528\u8be5\u914d\u7f6e\u7684\u5ba2\u6237\u7fa4ID\u5217\u8868\uff0c\u652f\u63015\u4e2a");
        }
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/update_join_way");
        return WxCpBaseResp.fromJson(this.mainService.post(url, wxCpGroupJoinWayInfo.getJoinWay().toJson()));
    }

    @Override
    public WxCpGroupJoinWayInfo getJoinWay(String configId) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("config_id", configId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/get_join_way");
        return WxCpGroupJoinWayInfo.fromJson(this.mainService.post(url, json));
    }

    @Override
    public WxCpBaseResp delJoinWay(String configId) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("config_id", configId);
        String url = this.mainService.getWxCpConfigStorage().getApiUrl("/cgi-bin/externalcontact/groupchat/del_join_way");
        return WxCpBaseResp.fromJson(this.mainService.post(url, json));
    }

    public WxCpExternalContactServiceImpl(WxCpService mainService) {
        this.mainService = mainService;
    }
}

