/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaMediaService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.BaseMediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.MediaUploadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;

public class WxMaMediaServiceImpl
implements WxMaMediaService {
    private WxMaService wxMaService;

    public WxMaMediaServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }

    @Override
    public WxMediaUploadResult uploadMedia(String mediaType, String fileType, InputStream inputStream) throws WxErrorException {
        try {
            return this.uploadMedia(mediaType, FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)fileType));
        }
        catch (IOException e) {
            throw new WxErrorException(WxError.builder().errorMsg(e.getMessage()).build(), (Throwable)e);
        }
    }

    @Override
    public WxMediaUploadResult uploadMedia(String mediaType, File file) throws WxErrorException {
        String url = String.format("https://api.weixin.qq.com/cgi-bin/media/upload?type=%s", mediaType);
        return (WxMediaUploadResult)this.wxMaService.execute(MediaUploadRequestExecutor.create((RequestHttp)this.wxMaService.getRequestHttp()), url, file);
    }

    @Override
    public File getMedia(String mediaId) throws WxErrorException {
        try {
            RequestExecutor executor = BaseMediaDownloadRequestExecutor.create((RequestHttp)this.wxMaService.getRequestHttp(), (File)Files.createTempDirectory("wxma", new FileAttribute[0]).toFile());
            return (File)this.wxMaService.execute(executor, "https://api.weixin.qq.com/cgi-bin/media/get", "media_id=" + mediaId);
        }
        catch (IOException e) {
            throw new WxErrorException(WxError.builder().errorMsg(e.getMessage()).build(), (Throwable)e);
        }
    }
}

