/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaQrcodeService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaCodeLineColor;
import cn.binarywang.wx.miniapp.bean.WxMaQrcode;
import cn.binarywang.wx.miniapp.bean.WxMaWxcode;
import cn.binarywang.wx.miniapp.bean.WxaCodeUnlimit;
import cn.binarywang.wx.miniapp.util.http.QrCodeRequestExecutor;
import java.io.File;
import me.chanjar.weixin.common.error.WxErrorException;

public class WxMaQrcodeServiceImpl
implements WxMaQrcodeService {
    private WxMaService wxMaService;

    public WxMaQrcodeServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }

    @Override
    public File createQrcode(String path, int width) throws WxErrorException {
        return this.wxMaService.execute(new QrCodeRequestExecutor(this.wxMaService.getRequestHttp()), "https://api.weixin.qq.com/cgi-bin/wxaapp/createwxaqrcode", new WxMaQrcode(path, width));
    }

    @Override
    public File createQrcode(String path) throws WxErrorException {
        return this.createQrcode(path, 430);
    }

    @Override
    public File createWxaCode(String path, int width, boolean autoColor, WxMaCodeLineColor lineColor, boolean isHyaline) throws WxErrorException {
        WxMaWxcode wxMaWxcode = new WxMaWxcode();
        wxMaWxcode.setPath(path);
        wxMaWxcode.setWidth(width);
        wxMaWxcode.setAutoColor(autoColor);
        wxMaWxcode.setLineColor(lineColor);
        wxMaWxcode.setHyaline(isHyaline);
        return this.wxMaService.execute(new QrCodeRequestExecutor(this.wxMaService.getRequestHttp()), "https://api.weixin.qq.com/wxa/getwxacode", wxMaWxcode);
    }

    @Override
    public File createWxaCode(String path, int width) throws WxErrorException {
        return this.createWxaCode(path, width, true, null, false);
    }

    @Override
    public File createWxaCode(String path) throws WxErrorException {
        return this.createWxaCode(path, 430, true, null, false);
    }

    @Override
    public File createWxaCodeUnlimit(String scene, String page, int width, boolean autoColor, WxMaCodeLineColor lineColor, boolean isHyaline) throws WxErrorException {
        WxaCodeUnlimit wxaCodeUnlimit = new WxaCodeUnlimit();
        wxaCodeUnlimit.setScene(scene);
        wxaCodeUnlimit.setPage(page);
        wxaCodeUnlimit.setWidth(width);
        wxaCodeUnlimit.setAutoColor(autoColor);
        wxaCodeUnlimit.setLineColor(lineColor);
        wxaCodeUnlimit.setHyaline(isHyaline);
        return this.wxMaService.execute(new QrCodeRequestExecutor(this.wxMaService.getRequestHttp()), "https://api.weixin.qq.com/wxa/getwxacodeunlimit", wxaCodeUnlimit);
    }

    @Override
    public File createWxaCodeUnlimit(String scene, String page) throws WxErrorException {
        return this.createWxaCodeUnlimit(scene, page, 430, true, null, false);
    }
}

