/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.WxMaTemplateService;
import cn.binarywang.wx.miniapp.bean.template.WxMaTemplateAddResult;
import cn.binarywang.wx.miniapp.bean.template.WxMaTemplateLibraryGetResult;
import cn.binarywang.wx.miniapp.bean.template.WxMaTemplateLibraryListResult;
import cn.binarywang.wx.miniapp.bean.template.WxMaTemplateListResult;
import java.util.HashMap;
import java.util.List;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;

public class WxMaTemplateServiceImpl
implements WxMaTemplateService {
    private WxMaService wxMaService;

    public WxMaTemplateServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }

    @Override
    public WxMaTemplateLibraryListResult findTemplateLibraryList(int offset, int count) throws WxErrorException {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("offset", offset);
        params.put("count", count);
        String responseText = this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/wxopen/template/library/list", WxGsonBuilder.create().toJson(params));
        WxError wxError = WxError.fromJson((String)responseText);
        if (wxError.getErrorCode() == 0) {
            return WxMaTemplateLibraryListResult.fromJson(responseText);
        }
        throw new WxErrorException(wxError);
    }

    @Override
    public WxMaTemplateLibraryGetResult findTemplateLibraryKeywordList(String id) throws WxErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", id);
        String responseText = this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/wxopen/template/library/get", WxGsonBuilder.create().toJson(params));
        WxError wxError = WxError.fromJson((String)responseText);
        if (wxError.getErrorCode() == 0) {
            return WxMaTemplateLibraryGetResult.fromJson(responseText);
        }
        throw new WxErrorException(wxError);
    }

    @Override
    public WxMaTemplateAddResult addTemplate(String id, List<Integer> keywordIdList) throws WxErrorException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("keyword_id_list", keywordIdList.toArray());
        String responseText = this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/wxopen/template/add", WxGsonBuilder.create().toJson(params));
        WxError wxError = WxError.fromJson((String)responseText);
        if (wxError.getErrorCode() == 0) {
            return WxMaTemplateAddResult.fromJson(responseText);
        }
        throw new WxErrorException(wxError);
    }

    @Override
    public WxMaTemplateListResult findTemplateList(int offset, int count) throws WxErrorException {
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("offset", offset);
        params.put("count", count);
        String responseText = this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/wxopen/template/list", WxGsonBuilder.create().toJson(params));
        WxError wxError = WxError.fromJson((String)responseText);
        if (wxError.getErrorCode() == 0) {
            return WxMaTemplateListResult.fromJson(responseText);
        }
        throw new WxErrorException(wxError);
    }

    @Override
    public boolean delTemplate(String templateId) throws WxErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("template_id", templateId);
        String responseText = this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/wxopen/template/del", WxGsonBuilder.create().toJson(params));
        WxError wxError = WxError.fromJson((String)responseText);
        if (wxError.getErrorCode() == 0) {
            return true;
        }
        throw new WxErrorException(wxError);
    }
}

