/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaExpressService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.express.WxMaExpressAccount;
import cn.binarywang.wx.miniapp.bean.express.WxMaExpressDelivery;
import cn.binarywang.wx.miniapp.bean.express.WxMaExpressPath;
import cn.binarywang.wx.miniapp.bean.express.WxMaExpressPrinter;
import cn.binarywang.wx.miniapp.bean.express.request.WxMaExpressAddOrderRequest;
import cn.binarywang.wx.miniapp.bean.express.request.WxMaExpressBindAccountRequest;
import cn.binarywang.wx.miniapp.bean.express.request.WxMaExpressGetOrderRequest;
import cn.binarywang.wx.miniapp.bean.express.request.WxMaExpressPrinterUpdateRequest;
import cn.binarywang.wx.miniapp.bean.express.request.WxMaExpressTestUpdateOrderRequest;
import cn.binarywang.wx.miniapp.bean.express.result.WxMaExpressOrderInfoResult;
import cn.binarywang.wx.miniapp.util.json.WxMaGsonBuilder;
import java.util.HashMap;
import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;

public class WxMaExpressServiceImpl
implements WxMaExpressService {
    private WxMaService wxMaService;

    @Override
    public List<WxMaExpressDelivery> getAllDelivery() throws WxErrorException {
        String responseContent = this.wxMaService.get("https://api.weixin.qq.com/cgi-bin/express/business/delivery/getall", null);
        return WxMaExpressDelivery.fromJson(responseContent);
    }

    @Override
    public List<WxMaExpressAccount> getAllAccount() throws WxErrorException {
        String responseContent = this.wxMaService.get("https://api.weixin.qq.com/cgi-bin/express/business/account/getall", null);
        return WxMaExpressAccount.fromJsonList(responseContent);
    }

    @Override
    public void bindAccount(WxMaExpressBindAccountRequest wxMaExpressBindAccountRequest) throws WxErrorException {
        this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/express/business/account/bind", wxMaExpressBindAccountRequest.toJson());
    }

    @Override
    public Integer getQuota(WxMaExpressBindAccountRequest wxMaExpressBindAccountRequest) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/express/business/quota/get", wxMaExpressBindAccountRequest.toJson());
        WxMaExpressAccount account = WxMaExpressAccount.fromJson(responseContent);
        return account.getQuotaNum();
    }

    @Override
    public void updatePrinter(WxMaExpressPrinterUpdateRequest wxMaExpressPrinterUpdateRequest) throws WxErrorException {
        this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/express/business/printer/update", wxMaExpressPrinterUpdateRequest.toJson());
    }

    @Override
    public WxMaExpressPrinter getPrinter() throws WxErrorException {
        String responseContent = this.wxMaService.get("https://api.weixin.qq.com/cgi-bin/express/business/printer/getall", null);
        return WxMaExpressPrinter.fromJson(responseContent);
    }

    @Override
    public WxMaExpressOrderInfoResult addOrder(WxMaExpressAddOrderRequest wxMaExpressAddOrderRequest) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/express/business/order/add", wxMaExpressAddOrderRequest.toJson());
        return WxMaExpressOrderInfoResult.fromJson(responseContent);
    }

    @Override
    public List<WxMaExpressOrderInfoResult> batchGetOrder(List<WxMaExpressGetOrderRequest> requests) throws WxErrorException {
        HashMap<String, List<WxMaExpressGetOrderRequest>> param = new HashMap<String, List<WxMaExpressGetOrderRequest>>(1);
        param.put("order_list", requests);
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/express/business/order/batchget", WxMaGsonBuilder.create().toJson(param));
        return WxMaExpressOrderInfoResult.toList(responseContent);
    }

    @Override
    public void cancelOrder(WxMaExpressGetOrderRequest wxMaExpressGetOrderRequest) throws WxErrorException {
        this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/express/business/order/cancel", wxMaExpressGetOrderRequest.toJson());
    }

    @Override
    public WxMaExpressOrderInfoResult getOrder(WxMaExpressGetOrderRequest wxMaExpressGetOrderRequest) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/express/business/order/get", wxMaExpressGetOrderRequest.toJson());
        return WxMaExpressOrderInfoResult.fromJson(responseContent);
    }

    @Override
    public WxMaExpressPath getPath(WxMaExpressGetOrderRequest wxMaExpressGetOrderRequest) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/express/business/path/get", wxMaExpressGetOrderRequest.toJson());
        return WxMaExpressPath.fromJson(responseContent);
    }

    @Override
    public void testUpdateOrder(WxMaExpressTestUpdateOrderRequest wxMaExpressTestUpdateOrderRequest) throws WxErrorException {
        this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/express/business/test_update_order", wxMaExpressTestUpdateOrderRequest.toJson());
    }

    public WxMaExpressServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

