/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaSecCheckService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaMediaAsyncCheckResult;
import cn.binarywang.wx.miniapp.bean.security.WxMaMsgSecCheckCheckRequest;
import cn.binarywang.wx.miniapp.bean.security.WxMaMsgSecCheckCheckResponse;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import me.chanjar.weixin.common.bean.result.WxMediaUploadResult;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.MediaUploadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.json.GsonParser;
import org.apache.commons.io.FileUtils;

public class WxMaSecCheckServiceImpl
implements WxMaSecCheckService {
    private final WxMaService service;

    @Override
    public boolean checkImage(File file) throws WxErrorException {
        WxMediaUploadResult result = (WxMediaUploadResult)this.service.execute(MediaUploadRequestExecutor.create((RequestHttp)this.service.getRequestHttp()), "https://api.weixin.qq.com/wxa/img_sec_check", file);
        return result != null;
    }

    @Override
    public boolean checkImage(String fileUrl) throws WxErrorException {
        File file = new File(FileUtils.getTempDirectory(), System.currentTimeMillis() + ".tmp");
        try {
            URL url = new URL(fileUrl);
            FileUtils.copyURLToFile((URL)url, (File)file);
        }
        catch (IOException e) {
            throw new WxErrorException(WxError.builder().errorCode(-1).errorMsg("\u6587\u4ef6\u5730\u5740\u8bfb\u53d6\u5f02\u5e38").build(), (Throwable)e);
        }
        return this.checkImage(file);
    }

    @Override
    public boolean checkMessage(String msgString) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("content", msgString);
        this.service.post("https://api.weixin.qq.com/wxa/msg_sec_check", jsonObject.toString());
        return true;
    }

    @Override
    public WxMaMsgSecCheckCheckResponse checkMessage(WxMaMsgSecCheckCheckRequest msgRequest) throws WxErrorException {
        String response = this.service.post("https://api.weixin.qq.com/wxa/msg_sec_check", msgRequest);
        JsonObject jsonObject = GsonParser.parse((String)response);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)response, (WxType)WxType.MiniApp));
        }
        return (WxMaMsgSecCheckCheckResponse)WxMaGsonBuilder.create().fromJson(response, WxMaMsgSecCheckCheckResponse.class);
    }

    @Override
    public WxMaMediaAsyncCheckResult mediaCheckAsync(String mediaUrl, int mediaType) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("media_url", mediaUrl);
        jsonObject.addProperty("media_type", (Number)mediaType);
        return WxMaMediaAsyncCheckResult.fromJson(this.service.post("https://api.weixin.qq.com/wxa/media_check_async", jsonObject.toString()));
    }

    public WxMaSecCheckServiceImpl(WxMaService service) {
        this.service = service;
    }
}

