/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.config.impl;

import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import lombok.NonNull;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.redis.RedissonWxRedisOps;
import me.chanjar.weixin.common.redis.WxRedisOps;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RedissonClient;

public class WxMaRedissonConfigImpl
extends WxMaDefaultConfigImpl {
    protected static final String LOCK_KEY = "wechat_ma_lock:";
    protected static final String MA_ACCESS_TOKEN_KEY = "wechat_ma_access_token_key:";
    protected static final String MA_JSAPI_TICKET_KEY = "wechat_ma_jsapi_ticket_key:";
    protected static final String MA_CARD_API_TICKET_KEY = "wechat_ma_card_api_ticket_key:";
    protected String keyPrefix;
    protected String accessTokenKey;
    protected String jsapiTicketKey;
    protected String cardApiTicketKey;
    protected String lockKey;
    private final WxRedisOps redisOps;

    public WxMaRedissonConfigImpl(@NonNull RedissonClient redissonClient, String keyPrefix) {
        this((WxRedisOps)new RedissonWxRedisOps(redissonClient), keyPrefix);
        if (redissonClient == null) {
            throw new NullPointerException("redissonClient is marked non-null but is null");
        }
    }

    public WxMaRedissonConfigImpl(@NonNull RedissonClient redissonClient) {
        this(redissonClient, null);
        if (redissonClient == null) {
            throw new NullPointerException("redissonClient is marked non-null but is null");
        }
    }

    private WxMaRedissonConfigImpl(@NonNull WxRedisOps redisOps, String keyPrefix) {
        if (redisOps == null) {
            throw new NullPointerException("redisOps is marked non-null but is null");
        }
        this.redisOps = redisOps;
        this.keyPrefix = keyPrefix;
    }

    @Override
    public void setAppid(String appid) {
        super.setAppid(appid);
        String prefix = StringUtils.isBlank((CharSequence)this.keyPrefix) ? "" : (StringUtils.endsWith((CharSequence)this.keyPrefix, (CharSequence)":") ? this.keyPrefix : this.keyPrefix + ":");
        this.lockKey = prefix + LOCK_KEY.concat(appid);
        this.accessTokenKey = prefix + MA_ACCESS_TOKEN_KEY.concat(appid);
        this.jsapiTicketKey = prefix + MA_JSAPI_TICKET_KEY.concat(appid);
        this.cardApiTicketKey = prefix + MA_CARD_API_TICKET_KEY.concat(appid);
    }

    protected Lock getLockByKey(String key) {
        return this.redisOps.getLock(key);
    }

    @Override
    public Lock getAccessTokenLock() {
        return this.getLockByKey(this.lockKey.concat(":").concat("accessToken"));
    }

    @Override
    public Lock getCardApiTicketLock() {
        return this.getLockByKey(this.lockKey.concat(":").concat("cardApiTicket"));
    }

    @Override
    public Lock getJsapiTicketLock() {
        return this.getLockByKey(this.lockKey.concat(":").concat("jsapiTicket"));
    }

    @Override
    public String getAccessToken() {
        return this.redisOps.getValue(this.accessTokenKey);
    }

    @Override
    public boolean isAccessTokenExpired() {
        Long expire = this.redisOps.getExpire(this.accessTokenKey);
        return expire == null || expire < 2L;
    }

    @Override
    public void updateAccessToken(WxAccessToken accessToken) {
        this.redisOps.setValue(this.accessTokenKey, accessToken.getAccessToken(), accessToken.getExpiresIn(), TimeUnit.SECONDS);
    }

    @Override
    public void updateAccessToken(String accessToken, int expiresInSeconds) {
        this.redisOps.setValue(this.accessTokenKey, accessToken, expiresInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public String getJsapiTicket() {
        return this.redisOps.getValue(this.jsapiTicketKey);
    }

    @Override
    public boolean isJsapiTicketExpired() {
        Long expire = this.redisOps.getExpire(this.jsapiTicketKey);
        return expire == null || expire < 2L;
    }

    @Override
    public void expireJsapiTicket() {
        this.redisOps.expire(this.jsapiTicketKey, 0, TimeUnit.SECONDS);
    }

    @Override
    public void updateJsapiTicket(String jsapiTicket, int expiresInSeconds) {
        this.redisOps.setValue(this.jsapiTicketKey, jsapiTicket, expiresInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public String getCardApiTicket() {
        return this.redisOps.getValue(this.cardApiTicketKey);
    }

    @Override
    public boolean isCardApiTicketExpired() {
        Long expire = this.redisOps.getExpire(this.cardApiTicketKey);
        return expire == null || expire < 2L;
    }

    @Override
    public void expireCardApiTicket() {
        this.redisOps.expire(this.cardApiTicketKey, 0, TimeUnit.SECONDS);
    }

    @Override
    public void updateCardApiTicket(String cardApiTicket, int expiresInSeconds) {
        this.redisOps.setValue(this.cardApiTicketKey, cardApiTicket, expiresInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void expireAccessToken() {
        this.redisOps.expire(this.accessTokenKey, 0, TimeUnit.SECONDS);
    }
}

