/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.config;

import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.bean.WxAccessTokenEntity;
import me.chanjar.weixin.common.util.http.apache.ApacheHttpClientBuilder;

public interface WxMaConfig {
    default public void setUpdateAccessTokenBefore(Consumer<WxAccessTokenEntity> updateAccessTokenBefore) {
    }

    public String getAccessToken();

    public boolean isStableAccessToken();

    public void useStableAccessToken(boolean var1);

    public Lock getAccessTokenLock();

    public boolean isAccessTokenExpired();

    public void expireAccessToken();

    default public void updateAccessToken(WxAccessToken accessToken) {
        this.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
    }

    public void updateAccessToken(String var1, int var2);

    default public void updateAccessTokenProcessor(String accessToken, int expiresInSeconds) {
        WxAccessTokenEntity wxAccessTokenEntity = new WxAccessTokenEntity();
        wxAccessTokenEntity.setAppid(this.getAppid());
        wxAccessTokenEntity.setAccessToken(accessToken);
        wxAccessTokenEntity.setExpiresIn(expiresInSeconds);
        this.updateAccessTokenBefore(wxAccessTokenEntity);
        this.updateAccessToken(accessToken, expiresInSeconds);
    }

    default public void updateAccessTokenBefore(WxAccessTokenEntity wxAccessTokenEntity) {
    }

    public String getJsapiTicket();

    public Lock getJsapiTicketLock();

    public boolean isJsapiTicketExpired();

    public void expireJsapiTicket();

    public void updateJsapiTicket(String var1, int var2);

    public String getCardApiTicket();

    public Lock getCardApiTicketLock();

    public boolean isCardApiTicketExpired();

    public void expireCardApiTicket();

    public void updateCardApiTicket(String var1, int var2);

    public String getAppid();

    public String getSecret();

    public String getToken();

    public String getAesKey();

    public String getOriginalId();

    public String getCloudEnv();

    public String getMsgDataFormat();

    public long getExpiresTime();

    public String getHttpProxyHost();

    public int getHttpProxyPort();

    public String getHttpProxyUsername();

    public String getHttpProxyPassword();

    public int getRetrySleepMillis();

    public int getMaxRetryTimes();

    public ApacheHttpClientBuilder getApacheHttpClientBuilder();

    public boolean autoRefreshToken();

    public void setApiHostUrl(String var1);

    public String getApiHostUrl();

    public String getAccessTokenUrl();

    public void setAccessTokenUrl(String var1);
}

