/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaImmediateDeliveryService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaBaseResponse;
import cn.binarywang.wx.miniapp.bean.delivery.AbnormalConfirmRequest;
import cn.binarywang.wx.miniapp.bean.delivery.AbnormalConfirmResponse;
import cn.binarywang.wx.miniapp.bean.delivery.AddOrderRequest;
import cn.binarywang.wx.miniapp.bean.delivery.AddOrderResponse;
import cn.binarywang.wx.miniapp.bean.delivery.BindAccountResponse;
import cn.binarywang.wx.miniapp.bean.delivery.CancelOrderRequest;
import cn.binarywang.wx.miniapp.bean.delivery.CancelOrderResponse;
import cn.binarywang.wx.miniapp.bean.delivery.FollowWaybillRequest;
import cn.binarywang.wx.miniapp.bean.delivery.FollowWaybillResponse;
import cn.binarywang.wx.miniapp.bean.delivery.GetDeliveryListResponse;
import cn.binarywang.wx.miniapp.bean.delivery.GetOrderRequest;
import cn.binarywang.wx.miniapp.bean.delivery.GetOrderResponse;
import cn.binarywang.wx.miniapp.bean.delivery.MockUpdateOrderRequest;
import cn.binarywang.wx.miniapp.bean.delivery.MockUpdateOrderResponse;
import cn.binarywang.wx.miniapp.bean.delivery.QueryFollowTraceRequest;
import cn.binarywang.wx.miniapp.bean.delivery.QueryFollowTraceResponse;
import cn.binarywang.wx.miniapp.bean.delivery.QueryWaybillTraceRequest;
import cn.binarywang.wx.miniapp.bean.delivery.QueryWaybillTraceResponse;
import cn.binarywang.wx.miniapp.bean.delivery.TraceWaybillRequest;
import cn.binarywang.wx.miniapp.bean.delivery.TraceWaybillResponse;
import cn.binarywang.wx.miniapp.bean.delivery.UpdateWaybillGoodsRequest;
import cn.binarywang.wx.miniapp.bean.delivery.base.WxMaDeliveryBaseResponse;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class WxMaImmediateDeliveryServiceImpl
implements WxMaImmediateDeliveryService {
    public static final String SF_ERR_CODE = "resultcode";
    public static final String SF_ERR_MSG = "resultmsg";
    public static final int SUCCESS_CODE = 0;
    private final WxMaService wxMaService;

    @Override
    public BindAccountResponse getBindAccount() throws WxErrorException {
        return this.parse(this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/express/local/business/shop/get", "{}"), BindAccountResponse.class);
    }

    @Override
    public AddOrderResponse addOrder(AddOrderRequest request) throws WxErrorException {
        request.getDeliverySign();
        return this.parse(this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/express/local/business/order/add", request), AddOrderResponse.class);
    }

    @Override
    public GetOrderResponse getOrder(GetOrderRequest request) throws WxErrorException {
        request.getDeliverySign();
        return this.parse(this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/express/local/business/order/get", request), GetOrderResponse.class);
    }

    @Override
    public CancelOrderResponse cancelOrder(CancelOrderRequest request) throws WxErrorException {
        request.getDeliverySign();
        return this.parse(this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/express/local/business/order/cancel", request), CancelOrderResponse.class);
    }

    @Override
    public AbnormalConfirmResponse abnormalConfirm(AbnormalConfirmRequest request) throws WxErrorException {
        request.getDeliverySign();
        return this.parse(this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/express/local/business/order/confirm_return", request), AbnormalConfirmResponse.class);
    }

    @Override
    public MockUpdateOrderResponse mockUpdateOrder(MockUpdateOrderRequest request) throws WxErrorException {
        return this.parse(this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/express/local/business/test_update_order", request), MockUpdateOrderResponse.class);
    }

    @Override
    public TraceWaybillResponse traceWaybill(TraceWaybillRequest request) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/express/delivery/open_msg/trace_waybill", request);
        TraceWaybillResponse response = TraceWaybillResponse.fromJson(responseContent);
        if (response.getErrcode() == -1) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return response;
    }

    @Override
    public QueryWaybillTraceResponse queryWaybillTrace(QueryWaybillTraceRequest request) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/express/delivery/open_msg/query_trace", request);
        QueryWaybillTraceResponse response = QueryWaybillTraceResponse.fromJson(responseContent);
        if (response.getErrcode() == -1) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return response;
    }

    @Override
    public FollowWaybillResponse followWaybill(FollowWaybillRequest request) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/express/delivery/open_msg/follow_waybill", request);
        FollowWaybillResponse response = FollowWaybillResponse.fromJson(responseContent);
        if (response.getErrcode() == -1) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return response;
    }

    @Override
    public QueryFollowTraceResponse queryFollowTrace(QueryFollowTraceRequest request) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/express/delivery/open_msg/query_follow_trace", request);
        QueryFollowTraceResponse response = QueryFollowTraceResponse.fromJson(responseContent);
        if (response.getErrcode() == -1) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return response;
    }

    @Override
    public GetDeliveryListResponse getDeliveryList() throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/express/delivery/open_msg/get_delivery_list", "{}");
        GetDeliveryListResponse response = GetDeliveryListResponse.fromJson(responseContent);
        if (response.getErrcode() == -1) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return response;
    }

    @Override
    public WxMaBaseResponse updateWaybillGoods(UpdateWaybillGoodsRequest request) throws WxErrorException {
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/cgi-bin/express/delivery/open_msg/get_delivery_list", request);
        WxMaBaseResponse response = (WxMaBaseResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaBaseResponse.class);
        if (response.getErrcode() == -1) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return response;
    }

    private <T extends WxMaDeliveryBaseResponse> T parse(String responseContent, Class<T> valueType) throws WxErrorException {
        if (StringUtils.isBlank((CharSequence)responseContent)) {
            throw new RuntimeException("the responseContent cannot be empty");
        }
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        JsonElement element = jsonObject.get("errcode");
        if (!ObjectUtils.isEmpty((Object)element) && 0 != element.getAsInt()) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        JsonElement delivery = jsonObject.get(SF_ERR_CODE);
        if (!ObjectUtils.isEmpty((Object)delivery) && 0 != delivery.getAsInt()) {
            throw new WxErrorException(jsonObject.get(SF_ERR_MSG).getAsString());
        }
        return WxMaDeliveryBaseResponse.fromJson(responseContent, valueType);
    }

    public WxMaImmediateDeliveryServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

