/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import me.chanjar.weixin.common.api.WxErrorExceptionHandler;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpMessageInterceptor;
import me.chanjar.weixin.mp.api.WxMpMessageMatcher;
import me.chanjar.weixin.mp.api.WxMpMessageRouter;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import org.apache.commons.lang3.StringUtils;

public class WxMpMessageRouterRule {
    private final WxMpMessageRouter routerBuilder;
    private boolean async = true;
    private String fromUser;
    private String msgType;
    private String event;
    private String eventKey;
    private String eventKeyRegex;
    private String content;
    private String rContent;
    private WxMpMessageMatcher matcher;
    private boolean reEnter = false;
    private List<WxMpMessageHandler> handlers = new ArrayList<WxMpMessageHandler>();
    private List<WxMpMessageInterceptor> interceptors = new ArrayList<WxMpMessageInterceptor>();

    public WxMpMessageRouterRule(WxMpMessageRouter routerBuilder) {
        this.routerBuilder = routerBuilder;
    }

    public WxMpMessageRouterRule async(boolean async) {
        this.async = async;
        return this;
    }

    public WxMpMessageRouterRule msgType(String msgType) {
        this.msgType = msgType;
        return this;
    }

    public WxMpMessageRouterRule event(String event) {
        this.event = event;
        return this;
    }

    public WxMpMessageRouterRule eventKey(String eventKey) {
        this.eventKey = eventKey;
        return this;
    }

    public WxMpMessageRouterRule eventKeyRegex(String regex) {
        this.eventKeyRegex = regex;
        return this;
    }

    public WxMpMessageRouterRule content(String content) {
        this.content = content;
        return this;
    }

    public WxMpMessageRouterRule rContent(String regex) {
        this.rContent = regex;
        return this;
    }

    public WxMpMessageRouterRule fromUser(String fromUser) {
        this.fromUser = fromUser;
        return this;
    }

    public WxMpMessageRouterRule matcher(WxMpMessageMatcher matcher) {
        this.matcher = matcher;
        return this;
    }

    public WxMpMessageRouterRule interceptor(WxMpMessageInterceptor interceptor) {
        return this.interceptor(interceptor, null);
    }

    public WxMpMessageRouterRule interceptor(WxMpMessageInterceptor interceptor, WxMpMessageInterceptor ... otherInterceptors) {
        this.interceptors.add(interceptor);
        if (otherInterceptors != null && otherInterceptors.length > 0) {
            for (WxMpMessageInterceptor i : otherInterceptors) {
                this.interceptors.add(i);
            }
        }
        return this;
    }

    public WxMpMessageRouterRule handler(WxMpMessageHandler handler) {
        return this.handler(handler, null);
    }

    public WxMpMessageRouterRule handler(WxMpMessageHandler handler, WxMpMessageHandler ... otherHandlers) {
        this.handlers.add(handler);
        if (otherHandlers != null && otherHandlers.length > 0) {
            for (WxMpMessageHandler i : otherHandlers) {
                this.handlers.add(i);
            }
        }
        return this;
    }

    public WxMpMessageRouter end() {
        this.routerBuilder.getRules().add(this);
        return this.routerBuilder;
    }

    public WxMpMessageRouter next() {
        this.reEnter = true;
        return this.end();
    }

    protected boolean test(WxMpXmlMessage wxMessage) {
        return !(this.fromUser != null && !this.fromUser.equals(wxMessage.getFromUser()) || this.msgType != null && !this.msgType.equalsIgnoreCase(wxMessage.getMsgType()) || this.event != null && !this.event.equalsIgnoreCase(wxMessage.getEvent()) || this.eventKey != null && !this.eventKey.equalsIgnoreCase(wxMessage.getEventKey()) || this.eventKeyRegex != null && !Pattern.matches(this.eventKeyRegex, StringUtils.trimToEmpty((String)wxMessage.getEventKey())) || this.content != null && !this.content.equals(StringUtils.trimToNull((String)wxMessage.getContent())) || this.rContent != null && !Pattern.matches(this.rContent, StringUtils.trimToEmpty((String)wxMessage.getContent())) || this.matcher != null && !this.matcher.match(wxMessage));
    }

    protected WxMpXmlOutMessage service(WxMpXmlMessage wxMessage, Map<String, Object> context, WxMpService wxMpService, WxSessionManager sessionManager, WxErrorExceptionHandler exceptionHandler) {
        if (context == null) {
            context = new HashMap<String, Object>();
        }
        try {
            for (WxMpMessageInterceptor interceptor : this.interceptors) {
                if (interceptor.intercept(wxMessage, context, wxMpService, sessionManager)) continue;
                return null;
            }
            WxMpXmlOutMessage res = null;
            for (WxMpMessageHandler handler : this.handlers) {
                if (handler == null) continue;
                res = handler.handle(wxMessage, context, wxMpService, sessionManager);
            }
            return res;
        }
        catch (WxErrorException e) {
            exceptionHandler.handle(e);
            return null;
        }
    }

    public WxMpMessageRouter getRouterBuilder() {
        return this.routerBuilder;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public String getFromUser() {
        return this.fromUser;
    }

    public void setFromUser(String fromUser) {
        this.fromUser = fromUser;
    }

    public String getMsgType() {
        return this.msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

    public String getEvent() {
        return this.event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getEventKey() {
        return this.eventKey;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getrContent() {
        return this.rContent;
    }

    public void setrContent(String rContent) {
        this.rContent = rContent;
    }

    public WxMpMessageMatcher getMatcher() {
        return this.matcher;
    }

    public void setMatcher(WxMpMessageMatcher matcher) {
        this.matcher = matcher;
    }

    public boolean isReEnter() {
        return this.reEnter;
    }

    public void setReEnter(boolean reEnter) {
        this.reEnter = reEnter;
    }

    public List<WxMpMessageHandler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<WxMpMessageHandler> handlers) {
        this.handlers = handlers;
    }

    public List<WxMpMessageInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public void setInterceptors(List<WxMpMessageInterceptor> interceptors) {
        this.interceptors = interceptors;
    }
}

