/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.bean;

import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class WxMpUserQuery
implements Serializable {
    private static final long serialVersionUID = -1344224837373149313L;
    private List<WxMpUserQueryParam> queryParamList = new ArrayList<WxMpUserQueryParam>();

    public WxMpUserQuery() {
    }

    public WxMpUserQuery(List<String> openids) {
        this.add(openids);
    }

    public WxMpUserQuery add(List<String> openids) {
        for (String openid : openids) {
            this.add(openid);
        }
        return this;
    }

    public WxMpUserQuery add(String openid, String lang) {
        this.queryParamList.add(new WxMpUserQueryParam(openid, lang));
        return this;
    }

    public WxMpUserQuery add(String openid) {
        this.queryParamList.add(new WxMpUserQueryParam(openid));
        return this;
    }

    public WxMpUserQuery remove(String openid) {
        this.queryParamList.remove(new WxMpUserQueryParam(openid));
        return this;
    }

    public WxMpUserQuery remove(String openid, String lang) {
        this.queryParamList.remove(new WxMpUserQueryParam(openid, lang));
        return this;
    }

    public List<WxMpUserQueryParam> getQueryParamList() {
        return this.queryParamList;
    }

    public String toJsonString() {
        HashMap<String, List<WxMpUserQueryParam>> map = new HashMap<String, List<WxMpUserQueryParam>>();
        map.put("user_list", this.queryParamList);
        return new Gson().toJson(map);
    }

    public class WxMpUserQueryParam
    implements Serializable {
        private static final long serialVersionUID = -6863571795702385319L;
        private String openid;
        private String lang;

        public WxMpUserQueryParam(String openid, String lang) {
            this.openid = openid;
            this.lang = lang;
        }

        public WxMpUserQueryParam(String openid) {
            this.openid = openid;
            this.lang = "zh_CN";
        }

        public WxMpUserQueryParam() {
        }

        public String getOpenid() {
            return this.openid;
        }

        public void setOpenid(String openid) {
            this.openid = openid;
        }

        public String getLang() {
            return this.lang;
        }

        public void setLang(String lang) {
            this.lang = lang;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.lang == null ? 0 : this.lang.hashCode());
            result = 31 * result + (this.openid == null ? 0 : this.openid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WxMpUserQueryParam other = (WxMpUserQueryParam)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.lang == null ? other.lang != null : !this.lang.equals(other.lang)) {
                return false;
            }
            return !(this.openid == null ? other.openid != null : !this.openid.equals(other.openid));
        }

        private WxMpUserQuery getOuterType() {
            return WxMpUserQuery.this;
        }
    }
}

