/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpMemberCardService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.membercard.WxMpMemberCardActivatedMessage;
import me.chanjar.weixin.mp.bean.membercard.WxMpMemberCardUpdateMessage;
import me.chanjar.weixin.mp.bean.membercard.WxMpMemberCardUpdateResult;
import me.chanjar.weixin.mp.bean.membercard.WxMpMemberCardUserInfoResult;
import me.chanjar.weixin.mp.util.json.WxMpGsonBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMpMemberCardServiceImpl
implements WxMpMemberCardService {
    private final Logger log = LoggerFactory.getLogger(WxMpMemberCardServiceImpl.class);
    private static final String MEMBER_CARD_ACTIVATE = "https://api.weixin.qq.com/card/membercard/activate";
    private static final String MEMBER_CARD_USER_INFO_GET = "https://api.weixin.qq.com/card/membercard/userinfo/get";
    private static final String MEMBER_CARD_UPDATE_USER = "https://api.weixin.qq.com/card/membercard/updateuser";
    private WxMpService wxMpService;
    private static final Gson GSON = new Gson();

    WxMpMemberCardServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }

    @Override
    public WxMpService getWxMpService() {
        return this.wxMpService;
    }

    @Override
    public String activateMemberCard(WxMpMemberCardActivatedMessage activatedMessage) throws WxErrorException {
        return this.wxMpService.post(MEMBER_CARD_ACTIVATE, GSON.toJson((Object)activatedMessage));
    }

    @Override
    public WxMpMemberCardUserInfoResult getUserInfo(String cardId, String code) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("card_id", cardId);
        jsonObject.addProperty("code", code);
        String responseContent = this.getWxMpService().post(MEMBER_CARD_USER_INFO_GET, jsonObject.toString());
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return (WxMpMemberCardUserInfoResult)WxMpGsonBuilder.INSTANCE.create().fromJson(tmpJsonElement, new TypeToken<WxMpMemberCardUserInfoResult>(){}.getType());
    }

    @Override
    public WxMpMemberCardUpdateResult updateUserMemberCard(WxMpMemberCardUpdateMessage updateUserMessage) throws WxErrorException {
        String responseContent = this.getWxMpService().post(MEMBER_CARD_UPDATE_USER, GSON.toJson((Object)updateUserMessage));
        JsonElement tmpJsonElement = new JsonParser().parse(responseContent);
        return (WxMpMemberCardUpdateResult)WxMpGsonBuilder.INSTANCE.create().fromJson(tmpJsonElement, new TypeToken<WxMpMemberCardUpdateResult>(){}.getType());
    }
}

