/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.WxMpUserService;
import me.chanjar.weixin.mp.bean.WxMpUserQuery;
import me.chanjar.weixin.mp.bean.result.WxMpChangeOpenid;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import me.chanjar.weixin.mp.bean.result.WxMpUserList;
import me.chanjar.weixin.mp.util.json.WxMpGsonBuilder;

public class WxMpUserServiceImpl
implements WxMpUserService {
    private WxMpService wxMpService;

    public WxMpUserServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }

    @Override
    public void userUpdateRemark(String openid, String remark) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("openid", openid);
        json.addProperty("remark", remark);
        this.wxMpService.post("https://api.weixin.qq.com/cgi-bin/user/info/updateremark", json.toString());
    }

    @Override
    public WxMpUser userInfo(String openid) throws WxErrorException {
        return this.userInfo(openid, null);
    }

    @Override
    public WxMpUser userInfo(String openid, String lang) throws WxErrorException {
        lang = lang == null ? "zh_CN" : lang;
        String responseContent = this.wxMpService.get("https://api.weixin.qq.com/cgi-bin/user/info", "openid=" + openid + "&lang=" + lang);
        return WxMpUser.fromJson(responseContent);
    }

    @Override
    public WxMpUserList userList(String nextOpenid) throws WxErrorException {
        String responseContent = this.wxMpService.get("https://api.weixin.qq.com/cgi-bin/user/get", nextOpenid == null ? null : "next_openid=" + nextOpenid);
        return WxMpUserList.fromJson(responseContent);
    }

    @Override
    public List<WxMpChangeOpenid> changeOpenid(String fromAppid, List<String> openidList) throws WxErrorException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("from_appid", fromAppid);
        map.put("openid_list", openidList);
        String responseContent = this.wxMpService.post("http://api.weixin.qq.com/cgi-bin/changeopenid", WxMpGsonBuilder.create().toJson(map));
        return WxMpChangeOpenid.fromJsonList(responseContent);
    }

    @Override
    public List<WxMpUser> userInfoList(List<String> openidList) throws WxErrorException {
        return this.userInfoList(new WxMpUserQuery(openidList));
    }

    @Override
    public List<WxMpUser> userInfoList(WxMpUserQuery userQuery) throws WxErrorException {
        String responseContent = this.wxMpService.post("https://api.weixin.qq.com/cgi-bin/user/info/batchget", userQuery.toJsonString());
        return WxMpUser.fromJsonList(responseContent);
    }
}

