/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.util.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.mp.bean.WxMpMassNews;
import org.apache.commons.lang3.BooleanUtils;

public class WxMpMassNewsArticleGsonAdapter
implements JsonSerializer<WxMpMassNews.WxMpMassNewsArticle>,
JsonDeserializer<WxMpMassNews.WxMpMassNewsArticle> {
    public JsonElement serialize(WxMpMassNews.WxMpMassNewsArticle article, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject articleJson = new JsonObject();
        articleJson.addProperty("thumb_media_id", article.getThumbMediaId());
        articleJson.addProperty("title", article.getTitle());
        articleJson.addProperty("content", article.getContent());
        if (null != article.getAuthor()) {
            articleJson.addProperty("author", article.getAuthor());
        }
        if (null != article.getContentSourceUrl()) {
            articleJson.addProperty("content_source_url", article.getContentSourceUrl());
        }
        if (null != article.getDigest()) {
            articleJson.addProperty("digest", article.getDigest());
        }
        articleJson.addProperty("show_cover_pic", article.isShowCoverPic() ? "1" : "0");
        return articleJson;
    }

    public WxMpMassNews.WxMpMassNewsArticle deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonElement showCoverPic;
        JsonElement thumbMediaId;
        JsonElement digest;
        JsonElement author;
        JsonElement contentSourceUrl;
        JsonElement content;
        JsonObject articleInfo = jsonElement.getAsJsonObject();
        WxMpMassNews.WxMpMassNewsArticle article = new WxMpMassNews.WxMpMassNewsArticle();
        JsonElement title = articleInfo.get("title");
        if (title != null && !title.isJsonNull()) {
            article.setTitle(GsonHelper.getAsString((JsonElement)title));
        }
        if ((content = articleInfo.get("content")) != null && !content.isJsonNull()) {
            article.setContent(GsonHelper.getAsString((JsonElement)content));
        }
        if ((contentSourceUrl = articleInfo.get("content_source_url")) != null && !contentSourceUrl.isJsonNull()) {
            article.setContentSourceUrl(GsonHelper.getAsString((JsonElement)contentSourceUrl));
        }
        if ((author = articleInfo.get("author")) != null && !author.isJsonNull()) {
            article.setAuthor(GsonHelper.getAsString((JsonElement)author));
        }
        if ((digest = articleInfo.get("digest")) != null && !digest.isJsonNull()) {
            article.setDigest(GsonHelper.getAsString((JsonElement)digest));
        }
        if ((thumbMediaId = articleInfo.get("thumb_media_id")) != null && !thumbMediaId.isJsonNull()) {
            article.setThumbMediaId(GsonHelper.getAsString((JsonElement)thumbMediaId));
        }
        if ((showCoverPic = articleInfo.get("show_cover_pic")) != null && !showCoverPic.isJsonNull()) {
            article.setShowCoverPic(BooleanUtils.toBoolean((int)showCoverPic.getAsInt()));
        }
        return article;
    }
}

