/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import java.io.File;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.mp.api.WxMpAiOpenService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.enums.AiLangType;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;
import me.chanjar.weixin.mp.util.requestexecuter.voice.VoiceUploadRequestExecutor;

public class WxMpAiOpenServiceImpl
implements WxMpAiOpenService {
    private final WxMpService wxMpService;

    @Override
    public void uploadVoice(String voiceId, AiLangType lang, File voiceFile) throws WxErrorException {
        if (lang == null) {
            lang = AiLangType.zh_CN;
        }
        this.wxMpService.execute(VoiceUploadRequestExecutor.create(this.wxMpService.getRequestHttp()), String.format(WxMpApiUrl.AiOpen.VOICE_UPLOAD_URL.getUrl(this.wxMpService.getWxMpConfigStorage()), "mp3", voiceId, lang.getCode()), voiceFile);
    }

    @Override
    public String recogniseVoice(String voiceId, AiLangType lang, File voiceFile) throws WxErrorException {
        this.uploadVoice(voiceId, lang, voiceFile);
        return this.queryRecognitionResult(voiceId, lang);
    }

    @Override
    public String translate(AiLangType langFrom, AiLangType langTo, String content) throws WxErrorException {
        String response = this.wxMpService.post(String.format(WxMpApiUrl.AiOpen.TRANSLATE_URL.getUrl(this.wxMpService.getWxMpConfigStorage()), langFrom.getCode(), langTo.getCode()), content);
        WxError error = WxError.fromJson((String)response, (WxType)WxType.MP);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return GsonParser.parse((String)response).get("to_content").getAsString();
    }

    @Override
    public String queryRecognitionResult(String voiceId, AiLangType lang) throws WxErrorException {
        String response;
        WxError error;
        if (lang == null) {
            lang = AiLangType.zh_CN;
        }
        if ((error = WxError.fromJson((String)(response = this.wxMpService.get(WxMpApiUrl.AiOpen.VOICE_QUERY_RESULT_URL, String.format("voice_id=%s&lang=%s", voiceId, lang.getCode()))), (WxType)WxType.MP)).getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return GsonParser.parse((String)response).get("result").getAsString();
    }

    public WxMpAiOpenServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }
}

