/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.mp.api.WxMpMarketingService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.marketing.WxMpAdLeadFilter;
import me.chanjar.weixin.mp.bean.marketing.WxMpAdLeadResult;
import me.chanjar.weixin.mp.bean.marketing.WxMpUserAction;
import me.chanjar.weixin.mp.bean.marketing.WxMpUserActionSet;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMpMarketingServiceImpl
implements WxMpMarketingService {
    private static final Logger log = LoggerFactory.getLogger(WxMpMarketingServiceImpl.class);
    private final WxMpService wxMpService;

    @Override
    public long addUserActionSets(String type, String name, String description) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("type", type);
        json.addProperty("name", name);
        json.addProperty("description", description);
        String responseContent = this.wxMpService.post(WxMpApiUrl.Marketing.USER_ACTION_SETS_ADD, json.toString());
        JsonObject tmpJson = GsonParser.parse((String)responseContent);
        return tmpJson.get("data").getAsJsonObject().get("user_action_set_id").getAsLong();
    }

    @Override
    public List<WxMpUserActionSet> getUserActionSets(Long userActionSetId) throws WxErrorException {
        String responseContent = this.wxMpService.get(WxMpApiUrl.Marketing.USER_ACTION_SETS_GET, "version=v1.0&user_action_set_id=" + userActionSetId);
        return WxMpUserActionSet.fromJson(responseContent);
    }

    @Override
    public void addUserAction(List<WxMpUserAction> actions) throws WxErrorException {
        this.wxMpService.post(WxMpApiUrl.Marketing.USER_ACTIONS_ADD, WxMpUserAction.listToJson(actions));
    }

    @Override
    public WxMpAdLeadResult getAdLeads(Date beginDate, Date endDate, List<WxMpAdLeadFilter> filtering, Integer page, Integer pageSize) throws WxErrorException, IOException {
        Date today = new Date();
        if (beginDate == null) {
            beginDate = today;
        }
        if (endDate == null) {
            endDate = today;
        }
        String params = "version=v1.0";
        JsonObject dateRange = new JsonObject();
        dateRange.addProperty("begin_date", DateFormatUtils.format((Date)beginDate, (String)"yyyy-MM-dd"));
        dateRange.addProperty("end_date", DateFormatUtils.format((Date)endDate, (String)"yyyy-MM-dd"));
        params = params + "&date_range=" + URLEncoder.encode(dateRange.toString(), StandardCharsets.UTF_8.name());
        params = params + "&page=" + page;
        params = params + "&page_size=" + pageSize;
        if (filtering != null) {
            JsonArray filterJson = new JsonArray();
            for (WxMpAdLeadFilter filter : filtering) {
                filterJson.add((JsonElement)filter.toJsonObject());
            }
            params = params + "&filtering=" + URLEncoder.encode(filterJson.toString(), StandardCharsets.UTF_8.name());
        }
        String responseContent = this.wxMpService.get(WxMpApiUrl.Marketing.WECHAT_AD_LEADS_GET, params);
        return WxMpAdLeadResult.fromJson(responseContent);
    }

    public WxMpMarketingServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }
}

