/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.JsonObject;
import me.chanjar.weixin.common.bean.menu.WxMenu;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.mp.api.WxMpMenuService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.menu.WxMpGetSelfMenuInfoResult;
import me.chanjar.weixin.mp.bean.menu.WxMpMenu;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMpMenuServiceImpl
implements WxMpMenuService {
    private static final Logger log = LoggerFactory.getLogger(WxMpMenuServiceImpl.class);
    private final WxMpService wxMpService;

    @Override
    public String menuCreate(WxMenu menu) throws WxErrorException {
        String menuJson = menu.toJson();
        WxMpApiUrl.Menu url = WxMpApiUrl.Menu.MENU_CREATE;
        if (menu.getMatchRule() != null) {
            url = WxMpApiUrl.Menu.MENU_ADDCONDITIONAL;
        }
        log.debug("\u5f00\u59cb\u521b\u5efa\u83dc\u5355\uff1a{}", (Object)menuJson);
        String result = this.wxMpService.post(url, menuJson);
        log.debug("\u521b\u5efa\u83dc\u5355\uff1a{},\u7ed3\u679c\uff1a{}", (Object)menuJson, (Object)result);
        if (menu.getMatchRule() != null) {
            return GsonParser.parse((String)result).get("menuid").getAsString();
        }
        return null;
    }

    @Override
    public String menuCreate(String json) throws WxErrorException {
        JsonObject jsonObject = GsonParser.parse((String)json);
        WxMpApiUrl.Menu url = WxMpApiUrl.Menu.MENU_CREATE;
        if (jsonObject.get("matchrule") != null) {
            url = WxMpApiUrl.Menu.MENU_ADDCONDITIONAL;
        }
        String result = this.wxMpService.post(url, json);
        if (jsonObject.get("matchrule") != null) {
            return GsonParser.parse((String)result).get("menuid").getAsString();
        }
        return null;
    }

    @Override
    public void menuDelete() throws WxErrorException {
        String result = this.wxMpService.get(WxMpApiUrl.Menu.MENU_DELETE, null);
        log.debug("\u5220\u9664\u83dc\u5355\u7ed3\u679c\uff1a{}", (Object)result);
    }

    @Override
    public void menuDelete(String menuId) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("menuid", menuId);
        String result = this.wxMpService.post(WxMpApiUrl.Menu.MENU_DELCONDITIONAL, jsonObject.toString());
        log.debug("\u6839\u636eMeunId({})\u5220\u9664\u4e2a\u6027\u5316\u83dc\u5355\u7ed3\u679c\uff1a{}", (Object)menuId, (Object)result);
    }

    @Override
    public WxMpMenu menuGet() throws WxErrorException {
        try {
            String resultContent = this.wxMpService.get(WxMpApiUrl.Menu.MENU_GET, null);
            return WxMpMenu.fromJson(resultContent);
        }
        catch (WxErrorException e) {
            if (e.getError().getErrorCode() == 46003) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public WxMenu menuTryMatch(String userid) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("user_id", userid);
        try {
            String resultContent = this.wxMpService.post(WxMpApiUrl.Menu.MENU_TRYMATCH, jsonObject.toString());
            return WxMenu.fromJson((String)resultContent);
        }
        catch (WxErrorException e) {
            if (e.getError().getErrorCode() == 46003 || e.getError().getErrorCode() == 46002) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public WxMpGetSelfMenuInfoResult getSelfMenuInfo() throws WxErrorException {
        String resultContent = this.wxMpService.get(WxMpApiUrl.Menu.GET_CURRENT_SELFMENU_INFO, null);
        return WxMpGetSelfMenuInfoResult.fromJson(resultContent);
    }

    public WxMpMenuServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }
}

