/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.JsonObject;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpCommentService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.comment.WxMpCommentListVo;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;

public class WxMpCommentServiceImpl
implements WxMpCommentService {
    private final WxMpService wxMpService;

    @Override
    public void open(String msgDataId, Integer index) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("msg_data_id", msgDataId);
        if (index != null) {
            json.addProperty("index", (Number)index);
        }
        this.wxMpService.post((WxMpApiUrl)WxMpApiUrl.Comment.OPEN, json.toString());
    }

    @Override
    public void close(String msgDataId, Integer index) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("msg_data_id", msgDataId);
        if (index != null) {
            json.addProperty("index", (Number)index);
        }
        this.wxMpService.post((WxMpApiUrl)WxMpApiUrl.Comment.CLOSE, json.toString());
    }

    @Override
    public WxMpCommentListVo list(String msgDataId, Integer index, int begin, int count, int type) throws WxErrorException {
        JsonObject json = new JsonObject();
        json.addProperty("msg_data_id", msgDataId);
        json.addProperty("begin", (Number)begin);
        json.addProperty("count", (Number)count);
        json.addProperty("type", (Number)type);
        if (index != null) {
            json.addProperty("index", (Number)index);
        }
        return WxMpCommentListVo.fromJson(this.wxMpService.post((WxMpApiUrl)WxMpApiUrl.Comment.LIST, json.toString()));
    }

    @Override
    public void markElect(String msgDataId, Integer index, Long userCommentId) throws WxErrorException {
        JsonObject json = this.buildJson(msgDataId, index, userCommentId);
        this.wxMpService.post((WxMpApiUrl)WxMpApiUrl.Comment.MARK_ELECT, json.toString());
    }

    @Override
    public void unmarkElect(String msgDataId, Integer index, Long userCommentId) throws WxErrorException {
        JsonObject json = this.buildJson(msgDataId, index, userCommentId);
        this.wxMpService.post((WxMpApiUrl)WxMpApiUrl.Comment.UNMARK_ELECT, json.toString());
    }

    @Override
    public void delete(String msgDataId, Integer index, Long userCommentId) throws WxErrorException {
        JsonObject json = this.buildJson(msgDataId, index, userCommentId);
        this.wxMpService.post((WxMpApiUrl)WxMpApiUrl.Comment.DELETE, json.toString());
    }

    @Override
    public void replyAdd(String msgDataId, Integer index, Long userCommentId, String content) throws WxErrorException {
        JsonObject json = this.buildJson(msgDataId, index, userCommentId);
        json.addProperty("content", content);
        this.wxMpService.post((WxMpApiUrl)WxMpApiUrl.Comment.REPLY_ADD, json.toString());
    }

    @Override
    public void replyDelete(String msgDataId, Integer index, Long userCommentId) throws WxErrorException {
        JsonObject json = this.buildJson(msgDataId, index, userCommentId);
        this.wxMpService.post((WxMpApiUrl)WxMpApiUrl.Comment.REPLY_DELETE, json.toString());
    }

    private JsonObject buildJson(String msgDataId, Integer index, Long userCommentId) {
        JsonObject json = new JsonObject();
        json.addProperty("msg_data_id", msgDataId);
        json.addProperty("user_comment_id", (Number)userCommentId);
        if (index != null) {
            json.addProperty("index", (Number)index);
        }
        return json;
    }

    public WxMpCommentServiceImpl(WxMpService wxMpService) {
        this.wxMpService = wxMpService;
    }
}

