/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import me.chanjar.weixin.common.bean.ocr.WxOcrBankCardResult;
import me.chanjar.weixin.common.bean.ocr.WxOcrBizLicenseResult;
import me.chanjar.weixin.common.bean.ocr.WxOcrCommResult;
import me.chanjar.weixin.common.bean.ocr.WxOcrDrivingLicenseResult;
import me.chanjar.weixin.common.bean.ocr.WxOcrDrivingResult;
import me.chanjar.weixin.common.bean.ocr.WxOcrIdCardResult;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.requestexecuter.ocr.OcrDiscernRequestExecutor;
import me.chanjar.weixin.common.service.WxOcrService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;

public class WxMpOcrServiceImpl
implements WxOcrService {
    private final WxMpService mainService;

    public WxOcrIdCardResult idCard(String imgUrl) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String result = this.mainService.post(String.format(WxMpApiUrl.Ocr.IDCARD.getUrl(this.mainService.getWxMpConfigStorage()), imgUrl), null);
        return WxOcrIdCardResult.fromJson((String)result);
    }

    public WxOcrIdCardResult idCard(File imgFile) throws WxErrorException {
        String result = (String)this.mainService.execute(OcrDiscernRequestExecutor.create(this.mainService.getRequestHttp()), WxMpApiUrl.Ocr.FILEIDCARD.getUrl(this.mainService.getWxMpConfigStorage()), imgFile);
        return WxOcrIdCardResult.fromJson((String)result);
    }

    public WxOcrBankCardResult bankCard(String imgUrl) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String result = this.mainService.post(String.format(WxMpApiUrl.Ocr.BANK_CARD.getUrl(this.mainService.getWxMpConfigStorage()), imgUrl), null);
        return WxOcrBankCardResult.fromJson((String)result);
    }

    public WxOcrBankCardResult bankCard(File imgFile) throws WxErrorException {
        String result = (String)this.mainService.execute(OcrDiscernRequestExecutor.create(this.mainService.getRequestHttp()), WxMpApiUrl.Ocr.FILE_BANK_CARD.getUrl(this.mainService.getWxMpConfigStorage()), imgFile);
        return WxOcrBankCardResult.fromJson((String)result);
    }

    public WxOcrDrivingResult driving(String imgUrl) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String result = this.mainService.post(String.format(WxMpApiUrl.Ocr.DRIVING.getUrl(this.mainService.getWxMpConfigStorage()), imgUrl), null);
        return WxOcrDrivingResult.fromJson((String)result);
    }

    public WxOcrDrivingResult driving(File imgFile) throws WxErrorException {
        String result = (String)this.mainService.execute(OcrDiscernRequestExecutor.create(this.mainService.getRequestHttp()), WxMpApiUrl.Ocr.FILE_DRIVING.getUrl(this.mainService.getWxMpConfigStorage()), imgFile);
        return WxOcrDrivingResult.fromJson((String)result);
    }

    public WxOcrDrivingLicenseResult drivingLicense(String imgUrl) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String result = this.mainService.post(String.format(WxMpApiUrl.Ocr.DRIVING_LICENSE.getUrl(this.mainService.getWxMpConfigStorage()), imgUrl), null);
        return WxOcrDrivingLicenseResult.fromJson((String)result);
    }

    public WxOcrDrivingLicenseResult drivingLicense(File imgFile) throws WxErrorException {
        String result = (String)this.mainService.execute(OcrDiscernRequestExecutor.create(this.mainService.getRequestHttp()), WxMpApiUrl.Ocr.FILE_DRIVING_LICENSE.getUrl(this.mainService.getWxMpConfigStorage()), imgFile);
        return WxOcrDrivingLicenseResult.fromJson((String)result);
    }

    public WxOcrBizLicenseResult bizLicense(String imgUrl) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String result = this.mainService.post(String.format(WxMpApiUrl.Ocr.BIZ_LICENSE.getUrl(this.mainService.getWxMpConfigStorage()), imgUrl), null);
        return WxOcrBizLicenseResult.fromJson((String)result);
    }

    public WxOcrBizLicenseResult bizLicense(File imgFile) throws WxErrorException {
        String result = (String)this.mainService.execute(OcrDiscernRequestExecutor.create(this.mainService.getRequestHttp()), WxMpApiUrl.Ocr.FILE_BIZ_LICENSE.getUrl(this.mainService.getWxMpConfigStorage()), imgFile);
        return WxOcrBizLicenseResult.fromJson((String)result);
    }

    public WxOcrCommResult comm(String imgUrl) throws WxErrorException {
        try {
            imgUrl = URLEncoder.encode(imgUrl, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String result = this.mainService.post(String.format(WxMpApiUrl.Ocr.COMM.getUrl(this.mainService.getWxMpConfigStorage()), imgUrl), null);
        return WxOcrCommResult.fromJson((String)result);
    }

    public WxOcrCommResult comm(File imgFile) throws WxErrorException {
        String result = (String)this.mainService.execute(OcrDiscernRequestExecutor.create(this.mainService.getRequestHttp()), WxMpApiUrl.Ocr.FILE_COMM.getUrl(this.mainService.getWxMpConfigStorage()), imgFile);
        return WxOcrCommResult.fromJson((String)result);
    }

    public WxMpOcrServiceImpl(WxMpService mainService) {
        this.mainService = mainService;
    }
}

