/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.util.requestexecuter.ma;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.UUID;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import me.chanjar.weixin.open.bean.ma.WxMaQrcodeParam;
import me.chanjar.weixin.open.util.requestexecuter.ma.MaQrCodeRequestExecutor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaQrCodeOkhttpRequestExecutor
extends MaQrCodeRequestExecutor<OkHttpClient, OkHttpProxyInfo> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public MaQrCodeOkhttpRequestExecutor(RequestHttp requestHttp) {
        super(requestHttp);
    }

    public File execute(String uri, WxMaQrcodeParam qrcodeParam) throws WxErrorException, IOException {
        Request request;
        OkHttpClient client;
        Response response;
        String contentTypeHeader;
        if (qrcodeParam != null && StringUtils.isNotBlank((CharSequence)qrcodeParam.getPagePath())) {
            if (uri.indexOf(63) == -1) {
                uri = uri + '?';
            }
            uri = uri + (uri.endsWith("?") ? "path=" + URLEncoder.encode(qrcodeParam.getRequestPath(), "UTF-8") : "&path=" + URLEncoder.encode(qrcodeParam.getRequestPath(), "UTF-8"));
        }
        if ("text/plain".equals(contentTypeHeader = (response = (client = (OkHttpClient)this.requestHttp.getRequestHttpClient()).newCall(request = new Request.Builder().url(uri).get().build()).execute()).header("Content-Type"))) {
            String responseContent = response.body().string();
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MP));
        }
        try (InputStream inputStream = response.body().byteStream();){
            File file = FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)"jpg");
            return file;
        }
    }
}

