/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.util.requestexecuter.ma;

import java.io.File;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.open.bean.ma.WxMaQrcodeParam;
import me.chanjar.weixin.open.util.requestexecuter.ma.MaQrCodeApacheHttpRequestExecutor;
import me.chanjar.weixin.open.util.requestexecuter.ma.MaQrCodeJoddHttpRequestExecutor;
import me.chanjar.weixin.open.util.requestexecuter.ma.MaQrCodeOkhttpRequestExecutor;

public abstract class MaQrCodeRequestExecutor<H, P>
implements RequestExecutor<File, WxMaQrcodeParam> {
    protected RequestHttp<H, P> requestHttp;

    public MaQrCodeRequestExecutor(RequestHttp requestHttp) {
        this.requestHttp = requestHttp;
    }

    public static RequestExecutor<File, WxMaQrcodeParam> create(RequestHttp requestHttp) throws WxErrorException {
        switch (requestHttp.getRequestType()) {
            case APACHE_HTTP: {
                return new MaQrCodeApacheHttpRequestExecutor(requestHttp);
            }
            case JODD_HTTP: {
                return new MaQrCodeJoddHttpRequestExecutor(requestHttp);
            }
            case OK_HTTP: {
                return new MaQrCodeOkhttpRequestExecutor(requestHttp);
            }
        }
        throw new WxErrorException(WxError.builder().errorCode(-1).errorMsg("\u4e0d\u652f\u6301\u7684http\u6846\u67b6").build());
    }
}

