/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.api.impl;

import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.util.json.WxMaGsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.open.api.WxOpenComponentService;
import me.chanjar.weixin.open.api.WxOpenMaService;
import me.chanjar.weixin.open.bean.ma.WxMaOpenCommitExtInfo;
import me.chanjar.weixin.open.bean.ma.WxMaQrcodeParam;
import me.chanjar.weixin.open.bean.message.WxOpenMaSubmitAuditMessage;
import me.chanjar.weixin.open.bean.result.WxOpenMaCategoryListResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaDomainResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaPageListResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaQueryAuditResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaSubmitAuditResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaTesterListResult;
import me.chanjar.weixin.open.bean.result.WxOpenResult;
import me.chanjar.weixin.open.util.requestexecuter.ma.MaQrCodeRequestExecutor;

public class WxOpenMaServiceImpl
extends WxMaServiceImpl
implements WxOpenMaService {
    private WxOpenComponentService wxOpenComponentService;
    private WxMaConfig wxMaConfig;
    private String appId;

    public WxOpenMaServiceImpl(WxOpenComponentService wxOpenComponentService, String appId, WxMaConfig wxMaConfig) {
        this.wxOpenComponentService = wxOpenComponentService;
        this.appId = appId;
        this.wxMaConfig = wxMaConfig;
        this.initHttp();
    }

    public WxMaJscode2SessionResult jsCode2SessionInfo(String jsCode) throws WxErrorException {
        return this.wxOpenComponentService.miniappJscode2Session(this.appId, jsCode);
    }

    public WxMaConfig getWxMaConfig() {
        return this.wxMaConfig;
    }

    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        return this.wxOpenComponentService.getAuthorizerAccessToken(this.appId, forceRefresh);
    }

    @Override
    public WxOpenMaDomainResult getDomain() throws WxErrorException {
        return this.modifyDomain("get", null, null, null, null);
    }

    @Override
    public WxOpenMaDomainResult modifyDomain(String action, List<String> requestdomainList, List<String> wsrequestdomainList, List<String> uploaddomainList, List<String> downloaddomainList) throws WxErrorException {
        JsonObject requestJson = new JsonObject();
        requestJson.addProperty("action", action);
        if (!"get".equals(action)) {
            requestJson.add("requestdomain", (JsonElement)this.toJsonArray(requestdomainList));
            requestJson.add("wsrequestdomain", (JsonElement)this.toJsonArray(wsrequestdomainList));
            requestJson.add("uploaddomain", (JsonElement)this.toJsonArray(uploaddomainList));
            requestJson.add("downloaddomain", (JsonElement)this.toJsonArray(downloaddomainList));
        }
        String response = this.post("https://api.weixin.qq.com/wxa/modify_domain", GSON.toJson((JsonElement)requestJson));
        return (WxOpenMaDomainResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaDomainResult.class);
    }

    @Override
    public String getWebViewDomain() throws WxErrorException {
        return this.setWebViewDomain("get", null);
    }

    @Override
    public String setWebViewDomain(String action, List<String> domainList) throws WxErrorException {
        JsonObject requestJson = new JsonObject();
        requestJson.addProperty("action", action);
        if (!"get".equals(action)) {
            requestJson.add("webviewdomain", (JsonElement)this.toJsonArray(domainList));
        }
        String response = this.post("https://api.weixin.qq.com/wxa/setwebviewdomain", GSON.toJson((JsonElement)requestJson));
        return response;
    }

    @Override
    public String getAccountBasicInfo() throws WxErrorException {
        String response = this.get("https://api.weixin.qq.com/cgi-bin/account/getaccountbasicinfo", "");
        return response;
    }

    @Override
    public WxOpenResult bindTester(String wechatid) throws WxErrorException {
        JsonObject paramJson = new JsonObject();
        paramJson.addProperty("wechatid", wechatid);
        String response = this.post("https://api.weixin.qq.com/wxa/bind_tester", GSON.toJson((JsonElement)paramJson));
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenResult unbindTester(String wechatid) throws WxErrorException {
        JsonObject paramJson = new JsonObject();
        paramJson.addProperty("wechatid", wechatid);
        String response = this.post("https://api.weixin.qq.com/wxa/unbind_tester", GSON.toJson((JsonElement)paramJson));
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenMaTesterListResult getTesterList() throws WxErrorException {
        JsonObject paramJson = new JsonObject();
        paramJson.addProperty("action", "get_experiencer");
        String response = this.post("https://api.weixin.qq.com/wxa/memberauth", GSON.toJson((JsonElement)paramJson));
        return (WxOpenMaTesterListResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaTesterListResult.class);
    }

    @Override
    public WxOpenResult codeCommit(Long templateId, String userVersion, String userDesc, WxMaOpenCommitExtInfo extInfo) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("template_id", (Number)templateId);
        params.addProperty("user_version", userVersion);
        params.addProperty("user_desc", userDesc);
        params.addProperty("ext_json", GSON.toJson((Object)extInfo));
        String response = this.post("https://api.weixin.qq.com/wxa/commit", GSON.toJson((JsonElement)params));
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public File getTestQrcode(String pagePath, Map<String, String> params) throws WxErrorException {
        WxMaQrcodeParam qrcodeParam = WxMaQrcodeParam.create(pagePath);
        qrcodeParam.addPageParam(params);
        return (File)this.execute(MaQrCodeRequestExecutor.create(this.getRequestHttp()), "https://api.weixin.qq.com/wxa/get_qrcode", qrcodeParam);
    }

    @Override
    public WxOpenMaCategoryListResult getCategoryList() throws WxErrorException {
        String response = this.get("https://api.weixin.qq.com/wxa/get_category", null);
        return (WxOpenMaCategoryListResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaCategoryListResult.class);
    }

    @Override
    public WxOpenMaPageListResult getPageList() throws WxErrorException {
        String response = this.get("https://api.weixin.qq.com/wxa/get_page", null);
        return (WxOpenMaPageListResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaPageListResult.class);
    }

    @Override
    public WxOpenMaSubmitAuditResult submitAudit(WxOpenMaSubmitAuditMessage submitAuditMessage) throws WxErrorException {
        String response = this.post("https://api.weixin.qq.com/wxa/submit_audit", GSON.toJson((Object)submitAuditMessage));
        return (WxOpenMaSubmitAuditResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaSubmitAuditResult.class);
    }

    @Override
    public WxOpenMaQueryAuditResult getAuditStatus(Long auditid) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("auditid", (Number)auditid);
        String response = this.post("https://api.weixin.qq.com/wxa/get_auditstatus", GSON.toJson((JsonElement)params));
        return (WxOpenMaQueryAuditResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaQueryAuditResult.class);
    }

    @Override
    public WxOpenMaQueryAuditResult getLatestAuditStatus() throws WxErrorException {
        String response = this.get("https://api.weixin.qq.com/wxa/get_latest_auditstatus", null);
        return (WxOpenMaQueryAuditResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaQueryAuditResult.class);
    }

    @Override
    public WxOpenResult releaesAudited() throws WxErrorException {
        JsonObject params = new JsonObject();
        String response = this.post("https://api.weixin.qq.com/wxa/release", GSON.toJson((JsonElement)params));
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenResult revertCodeReleaes() throws WxErrorException {
        String response = this.get("https://api.weixin.qq.com/wxa/revertcoderelease", null);
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenResult undoCodeAudit() throws WxErrorException {
        String response = this.get("https://api.weixin.qq.com/wxa/undocodeaudit", null);
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public String getSupportVersion() throws WxErrorException {
        JsonObject params = new JsonObject();
        String response = this.post("https://api.weixin.qq.com/cgi-bin/wxopen/getweappsupportversion", GSON.toJson((JsonElement)params));
        return response;
    }

    @Override
    public String setSupportVersion(String version) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("version", version);
        String response = this.post("https://api.weixin.qq.com/cgi-bin/wxopen/setweappsupportversion", GSON.toJson((JsonElement)params));
        return response;
    }

    private JsonArray toJsonArray(List<String> strList) {
        JsonArray jsonArray = new JsonArray();
        if (strList != null && !strList.isEmpty()) {
            for (String str : strList) {
                jsonArray.add(str);
            }
        }
        return jsonArray;
    }
}

