/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.api.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import lombok.NonNull;
import me.chanjar.weixin.common.redis.JedisWxRedisOps;
import me.chanjar.weixin.common.redis.WxRedisOps;
import me.chanjar.weixin.open.api.impl.AbstractWxOpenInRedisConfigStorage;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;

public class WxOpenInRedisConfigStorage
extends AbstractWxOpenInRedisConfigStorage {
    private final WxRedisOps redisOps;

    public WxOpenInRedisConfigStorage(Pool<Jedis> jedisPool) {
        this(jedisPool, null);
    }

    public WxOpenInRedisConfigStorage(@NonNull Pool<Jedis> jedisPool, String keyPrefix) {
        this((WxRedisOps)new JedisWxRedisOps(jedisPool), keyPrefix);
        if (jedisPool == null) {
            throw new NullPointerException("jedisPool is marked non-null but is null");
        }
    }

    public WxOpenInRedisConfigStorage(@NonNull WxRedisOps redisOps, String keyPrefix) {
        if (redisOps == null) {
            throw new NullPointerException("redisOps is marked non-null but is null");
        }
        this.redisOps = redisOps;
        this.keyPrefix = keyPrefix;
    }

    @Override
    public String getComponentVerifyTicket() {
        return this.redisOps.getValue(this.componentVerifyTicketKey);
    }

    @Override
    public void setComponentVerifyTicket(String componentVerifyTicket) {
        this.redisOps.setValue(this.componentVerifyTicketKey, componentVerifyTicket, Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public String getComponentAccessToken() {
        return this.redisOps.getValue(this.componentAccessTokenKey);
    }

    @Override
    public boolean isComponentAccessTokenExpired() {
        Long expire = this.redisOps.getExpire(this.componentAccessTokenKey);
        return expire == null || expire < 2L;
    }

    @Override
    public void expireComponentAccessToken() {
        this.redisOps.expire(this.componentAccessTokenKey, 0, TimeUnit.SECONDS);
    }

    @Override
    public void updateComponentAccessToken(String componentAccessToken, int expiresInSeconds) {
        this.redisOps.setValue(this.componentAccessTokenKey, componentAccessToken, expiresInSeconds - 200, TimeUnit.SECONDS);
    }

    @Override
    public String getAuthorizerRefreshToken(String appId) {
        return this.redisOps.getValue(this.getKey(this.authorizerRefreshTokenKey, appId));
    }

    @Override
    public void setAuthorizerRefreshToken(String appId, String authorizerRefreshToken) {
        this.redisOps.setValue(this.getKey(this.authorizerRefreshTokenKey, appId), authorizerRefreshToken, 0, TimeUnit.SECONDS);
    }

    @Override
    public String getAuthorizerAccessToken(String appId) {
        return this.redisOps.getValue(this.getKey(this.authorizerAccessTokenKey, appId));
    }

    @Override
    public boolean isAuthorizerAccessTokenExpired(String appId) {
        Long expire = this.redisOps.getExpire(this.getKey(this.authorizerAccessTokenKey, appId));
        return expire == null || expire < 2L;
    }

    @Override
    public void expireAuthorizerAccessToken(String appId) {
        this.redisOps.expire(this.getKey(this.authorizerAccessTokenKey, appId), 0, TimeUnit.SECONDS);
    }

    @Override
    public void updateAuthorizerAccessToken(String appId, String authorizerAccessToken, int expiresInSeconds) {
        this.redisOps.setValue(this.getKey(this.authorizerAccessTokenKey, appId), authorizerAccessToken, expiresInSeconds - 200, TimeUnit.SECONDS);
    }

    @Override
    public String getJsapiTicket(String appId) {
        return this.redisOps.getValue(this.getKey(this.jsapiTicketKey, appId));
    }

    @Override
    public boolean isJsapiTicketExpired(String appId) {
        Long expire = this.redisOps.getExpire(this.getKey(this.jsapiTicketKey, appId));
        return expire == null || expire < 2L;
    }

    @Override
    public void expireJsapiTicket(String appId) {
        this.redisOps.expire(this.getKey(this.jsapiTicketKey, appId), 0, TimeUnit.SECONDS);
    }

    @Override
    public void updateJsapiTicket(String appId, String jsapiTicket, int expiresInSeconds) {
        this.redisOps.setValue(this.getKey(this.jsapiTicketKey, appId), jsapiTicket, expiresInSeconds - 200, TimeUnit.SECONDS);
    }

    @Override
    public String getCardApiTicket(String appId) {
        return this.redisOps.getValue(this.getKey(this.cardApiTicket, appId));
    }

    @Override
    public boolean isCardApiTicketExpired(String appId) {
        Long expire = this.redisOps.getExpire(this.getKey(this.cardApiTicket, appId));
        return expire == null || expire < 2L;
    }

    @Override
    public void expireCardApiTicket(String appId) {
        this.redisOps.expire(this.getKey(this.cardApiTicket, appId), 0, TimeUnit.SECONDS);
    }

    @Override
    public void updateCardApiTicket(String appId, String cardApiTicket, int expiresInSeconds) {
        this.redisOps.setValue(this.getKey(this.cardApiTicket, appId), cardApiTicket, expiresInSeconds - 200, TimeUnit.SECONDS);
    }

    @Override
    public Lock getLockByKey(String key) {
        return this.redisOps.getLock(key);
    }
}

