/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.executor;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.ProxyInfo;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.open.bean.ma.WxMaQrcodeParam;
import me.chanjar.weixin.open.executor.MaQrCodeRequestExecutor;
import org.apache.commons.lang3.StringUtils;

public class MaQrCodeJoddHttpRequestExecutor
extends MaQrCodeRequestExecutor<HttpConnectionProvider, ProxyInfo> {
    public MaQrCodeJoddHttpRequestExecutor(RequestHttp requestHttp) {
        super(requestHttp);
    }

    public File execute(String uri, WxMaQrcodeParam qrcodeParam, WxType wxType) throws WxErrorException, IOException {
        if (qrcodeParam != null && StringUtils.isNotBlank((CharSequence)qrcodeParam.getPagePath())) {
            if (uri.indexOf(63) == -1) {
                uri = uri + '?';
            }
            uri = uri + (uri.endsWith("?") ? "path=" + URLEncoder.encode(qrcodeParam.getRequestPath(), "UTF-8") : "&path=" + URLEncoder.encode(qrcodeParam.getRequestPath(), "UTF-8"));
        }
        HttpRequest request = HttpRequest.get((String)uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            ((HttpConnectionProvider)this.requestHttp.getRequestHttpClient()).useProxy((ProxyInfo)this.requestHttp.getRequestHttpProxy());
        }
        request.withConnectionProvider((HttpConnectionProvider)this.requestHttp.getRequestHttpClient());
        HttpResponse response = request.send();
        response.charset(StandardCharsets.UTF_8.name());
        String contentTypeHeader = response.header("Content-Type");
        if ("text/plain".equals(contentTypeHeader)) {
            String responseContent = response.bodyText();
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(response.bodyBytes());){
            File file = FileUtils.createTmpFile((InputStream)inputStream, (String)UUID.randomUUID().toString(), (String)"jpg");
            return file;
        }
    }
}

