/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.api.impl;

import java.io.IOException;
import me.chanjar.weixin.common.bean.WxOAuth2UserInfo;
import me.chanjar.weixin.common.bean.oauth2.WxOAuth2AccessToken;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.error.WxRuntimeException;
import me.chanjar.weixin.common.service.WxOAuth2Service;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.URIUtil;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;
import me.chanjar.weixin.open.api.impl.WxOpenServiceImpl;
import org.apache.commons.lang3.StringUtils;

public class WxOpenOAuth2ServiceImpl
extends WxOpenServiceImpl
implements WxOAuth2Service {
    private final String appId;
    private final String appSecret;

    public String buildAuthorizationUrl(String redirectUri, String scope, String state) {
        return String.format(WxMpApiUrl.OAuth2.CONNECT_OAUTH2_AUTHORIZE_URL.getUrl(null), this.appId, URIUtil.encodeURIComponent((String)redirectUri), scope, StringUtils.trimToEmpty((String)state));
    }

    private WxOAuth2AccessToken getOAuth2AccessToken(String url) throws WxErrorException {
        return WxOAuth2AccessToken.fromJson((String)this.get(url, null));
    }

    public WxOAuth2AccessToken getAccessToken(String code) throws WxErrorException {
        return this.getAccessToken(this.appId, this.appSecret, code);
    }

    public WxOAuth2AccessToken getAccessToken(String appId, String appSecret, String code) throws WxErrorException {
        return this.getOAuth2AccessToken(String.format(WxMpApiUrl.OAuth2.OAUTH2_ACCESS_TOKEN_URL.getUrl(null), appId, appSecret, code));
    }

    public WxOAuth2AccessToken refreshAccessToken(String refreshToken) throws WxErrorException {
        String url = String.format(WxMpApiUrl.OAuth2.OAUTH2_REFRESH_TOKEN_URL.getUrl(null), this.appId, refreshToken);
        return this.getOAuth2AccessToken(url);
    }

    public WxOAuth2UserInfo getUserInfo(WxOAuth2AccessToken token, String lang) throws WxErrorException {
        if (lang == null) {
            lang = "zh_CN";
        }
        String url = String.format(WxMpApiUrl.OAuth2.OAUTH2_USERINFO_URL.getUrl(null), token.getAccessToken(), token.getOpenId(), lang);
        return WxOAuth2UserInfo.fromJson((String)this.get(url, null));
    }

    public boolean validateAccessToken(WxOAuth2AccessToken token) {
        String url = String.format(WxMpApiUrl.OAuth2.OAUTH2_VALIDATE_TOKEN_URL.getUrl(null), token.getAccessToken(), token.getOpenId());
        try {
            SimpleGetRequestExecutor.create((RequestHttp)this).execute(url, null, WxType.MP);
        }
        catch (IOException e) {
            throw new WxRuntimeException((Throwable)e);
        }
        catch (WxErrorException e) {
            return false;
        }
        return true;
    }

    public WxOpenOAuth2ServiceImpl(String appId, String appSecret) {
        this.appId = appId;
        this.appSecret = appSecret;
    }
}

