/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.executor;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import jodd.http.HttpConnectionProvider;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;
import jodd.http.ProxyInfo;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.ResponseHandler;
import me.chanjar.weixin.common.util.http.apache.Utf8ResponseHandler;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;

public class GenericUploadRequestExecutor
implements RequestExecutor<String, InputStream> {
    private final Executor<?, ?> executor;

    public GenericUploadRequestExecutor(RequestHttp<?, ?> requestHttp, String httpMethod, String paramName, String fileName) {
        switch (requestHttp.getRequestType()) {
            case APACHE_HTTP: {
                this.executor = new ApacheExecutor();
                break;
            }
            case OK_HTTP: {
                this.executor = new OkExecutor();
                break;
            }
            case JODD_HTTP: {
                this.executor = new JoddExecutor();
                break;
            }
            default: {
                throw new UnsupportedOperationException("\u4f7f\u7528\u4e86\u6682\u4e0d\u652f\u6301\u7684HTTP\u5ba2\u6237\u7aef:" + requestHttp.getRequestType());
            }
        }
        this.executor.setRequestHttp(requestHttp);
        this.executor.setHttpMethod(httpMethod);
        this.executor.setParamName(paramName);
        this.executor.setFileName(fileName);
    }

    public String execute(String uri, InputStream data, WxType wxType) throws WxErrorException, IOException {
        String json = this.executor.execute(uri, data, wxType);
        WxError error = WxError.fromJson((String)json, (WxType)wxType);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return json;
    }

    public void execute(String uri, InputStream data, ResponseHandler<String> handler, WxType wxType) throws WxErrorException, IOException {
        handler.handle((Object)this.execute(uri, data, wxType));
    }

    public static class JoddExecutor
    extends Executor<HttpConnectionProvider, ProxyInfo> {
        @Override
        public String execute(String uri, InputStream data, WxType wxType) throws WxErrorException, IOException {
            HttpRequest request = HttpRequest.post((String)uri);
            if (this.getRequestHttp().getRequestHttpProxy() != null) {
                ((HttpConnectionProvider)this.getRequestHttp().getRequestHttpClient()).useProxy((ProxyInfo)this.getRequestHttp().getRequestHttpProxy());
            }
            request.withConnectionProvider((HttpConnectionProvider)this.getRequestHttp().getRequestHttpClient());
            request.form(this.getParamName(), (Object)data);
            HttpResponse response = request.send();
            response.charset(StandardCharsets.UTF_8.name());
            return response.bodyText();
        }
    }

    public static class OkExecutor
    extends Executor<OkHttpClient, HttpHost> {
        @Override
        public String execute(String uri, InputStream data, WxType wxType) throws WxErrorException, IOException {
            OkHttpClient client = (OkHttpClient)this.getRequestHttp().getRequestHttpClient();
            byte[] bytes = IOUtils.toByteArray((InputStream)data);
            MultipartBody body = new MultipartBody.Builder().setType(Objects.requireNonNull(MediaType.parse((String)"multipart/form-data"))).addFormDataPart("media", this.getFileName(), RequestBody.create((byte[])bytes, (MediaType)MediaType.parse((String)"application/octet-stream"))).build();
            Request request = new Request.Builder().url(uri).method(this.getHttpMethod(), (RequestBody)body).build();
            Response response = client.newCall(request).execute();
            return response.body().string();
        }
    }

    public static class ApacheExecutor
    extends Executor<CloseableHttpClient, HttpHost> {
        /*
         * Loose catch block
         */
        @Override
        public String execute(String uri, InputStream data, WxType wxType) throws WxErrorException, IOException {
            HttpPost bodyRequest;
            switch (this.getHttpMethod()) {
                case "POST": {
                    bodyRequest = new HttpPost(uri);
                    break;
                }
                case "PUT": {
                    bodyRequest = new HttpPut(uri);
                    break;
                }
                case "PATCH": {
                    bodyRequest = new HttpPatch(uri);
                    break;
                }
                default: {
                    throw new IllegalAccessError("\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u65b9\u5f0f:" + this.getHttpMethod());
                }
            }
            if (this.getRequestHttp().getRequestHttpProxy() != null) {
                RequestConfig config = RequestConfig.custom().setProxy((HttpHost)this.getRequestHttp().getRequestHttpProxy()).build();
                bodyRequest.setConfig(config);
            }
            HttpEntity entity = MultipartEntityBuilder.create().addBinaryBody(this.getParamName(), data, ContentType.create((String)"multipart/form-data", (Charset)StandardCharsets.UTF_8), this.getFileName()).setMode(HttpMultipartMode.RFC6532).build();
            bodyRequest.setEntity(entity);
            bodyRequest.setHeader("Content-Type", ContentType.MULTIPART_FORM_DATA.toString());
            try {
                try (CloseableHttpResponse response = ((CloseableHttpClient)this.getRequestHttp().getRequestHttpClient()).execute((HttpUriRequest)bodyRequest);){
                    String string = (String)Utf8ResponseHandler.INSTANCE.handleResponse((org.apache.http.HttpResponse)response);
                    return string;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                bodyRequest.releaseConnection();
            }
        }
    }

    public static abstract class Executor<CLIENT, PROXY> {
        private RequestHttp<CLIENT, PROXY> requestHttp;
        private String httpMethod;
        private String paramName;
        private String fileName;

        public abstract String execute(String var1, InputStream var2, WxType var3) throws WxErrorException, IOException;

        public RequestHttp<CLIENT, PROXY> getRequestHttp() {
            return this.requestHttp;
        }

        public String getHttpMethod() {
            return this.httpMethod;
        }

        public String getParamName() {
            return this.paramName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setRequestHttp(RequestHttp<CLIENT, PROXY> requestHttp) {
            this.requestHttp = requestHttp;
        }

        public void setHttpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
        }

        public void setParamName(String paramName) {
            this.paramName = paramName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Executor)) {
                return false;
            }
            Executor other = (Executor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RequestHttp<CLIENT, PROXY> this$requestHttp = this.getRequestHttp();
            RequestHttp<CLIENT, PROXY> other$requestHttp = other.getRequestHttp();
            if (this$requestHttp == null ? other$requestHttp != null : !this$requestHttp.equals(other$requestHttp)) {
                return false;
            }
            String this$httpMethod = this.getHttpMethod();
            String other$httpMethod = other.getHttpMethod();
            if (this$httpMethod == null ? other$httpMethod != null : !this$httpMethod.equals(other$httpMethod)) {
                return false;
            }
            String this$paramName = this.getParamName();
            String other$paramName = other.getParamName();
            if (this$paramName == null ? other$paramName != null : !this$paramName.equals(other$paramName)) {
                return false;
            }
            String this$fileName = this.getFileName();
            String other$fileName = other.getFileName();
            return !(this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Executor;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RequestHttp<CLIENT, PROXY> $requestHttp = this.getRequestHttp();
            result = result * 59 + ($requestHttp == null ? 43 : $requestHttp.hashCode());
            String $httpMethod = this.getHttpMethod();
            result = result * 59 + ($httpMethod == null ? 43 : $httpMethod.hashCode());
            String $paramName = this.getParamName();
            result = result * 59 + ($paramName == null ? 43 : $paramName.hashCode());
            String $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
            return result;
        }

        public String toString() {
            return "GenericUploadRequestExecutor.Executor(requestHttp=" + this.getRequestHttp() + ", httpMethod=" + this.getHttpMethod() + ", paramName=" + this.getParamName() + ", fileName=" + this.getFileName() + ")";
        }
    }
}

