/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.executor;

import java.io.File;
import java.io.IOException;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.ResponseHandler;
import me.chanjar.weixin.open.bean.ma.WxMaQrcodeParam;
import me.chanjar.weixin.open.executor.MaQrCodeApacheHttpRequestExecutor;
import me.chanjar.weixin.open.executor.MaQrCodeJoddHttpRequestExecutor;
import me.chanjar.weixin.open.executor.MaQrCodeOkhttpRequestExecutor;

public abstract class MaQrCodeRequestExecutor<H, P>
implements RequestExecutor<File, WxMaQrcodeParam> {
    protected RequestHttp<H, P> requestHttp;

    public MaQrCodeRequestExecutor(RequestHttp requestHttp) {
        this.requestHttp = requestHttp;
    }

    public void execute(String uri, WxMaQrcodeParam data, ResponseHandler<File> handler, WxType wxType) throws WxErrorException, IOException {
        handler.handle(this.execute(uri, data, wxType));
    }

    public static RequestExecutor<File, WxMaQrcodeParam> create(RequestHttp requestHttp) throws WxErrorException {
        switch (requestHttp.getRequestType()) {
            case APACHE_HTTP: {
                return new MaQrCodeApacheHttpRequestExecutor(requestHttp);
            }
            case JODD_HTTP: {
                return new MaQrCodeJoddHttpRequestExecutor(requestHttp);
            }
            case OK_HTTP: {
                return new MaQrCodeOkhttpRequestExecutor(requestHttp);
            }
        }
        throw new WxErrorException("\u4e0d\u652f\u6301\u7684http\u6846\u67b6");
    }
}

