/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.executor;

import java.io.IOException;
import jodd.http.HttpConnectionProvider;
import jodd.http.ProxyInfo;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.ResponseHandler;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import me.chanjar.weixin.open.bean.CommonUploadMultiParam;
import me.chanjar.weixin.open.executor.CommonUploadMultiRequestExecutorApacheImpl;
import me.chanjar.weixin.open.executor.CommonUploadMultiRequestExecutorJoddHttpImpl;
import me.chanjar.weixin.open.executor.CommonUploadMultiRequestExecutorOkHttpImpl;
import okhttp3.OkHttpClient;
import org.apache.http.HttpHost;
import org.apache.http.impl.client.CloseableHttpClient;

public abstract class CommonUploadMultiRequestExecutor<H, P>
implements RequestExecutor<String, CommonUploadMultiParam> {
    protected RequestHttp<H, P> requestHttp;

    public CommonUploadMultiRequestExecutor(RequestHttp<H, P> requestHttp) {
        this.requestHttp = requestHttp;
    }

    public void execute(String uri, CommonUploadMultiParam data, ResponseHandler<String> handler, WxType wxType) throws WxErrorException, IOException {
        handler.handle(this.execute(uri, data, wxType));
    }

    public static RequestExecutor<String, CommonUploadMultiParam> create(RequestHttp requestHttp) {
        switch (requestHttp.getRequestType()) {
            case APACHE_HTTP: {
                return new CommonUploadMultiRequestExecutorApacheImpl((RequestHttp<CloseableHttpClient, HttpHost>)requestHttp);
            }
            case JODD_HTTP: {
                return new CommonUploadMultiRequestExecutorJoddHttpImpl((RequestHttp<HttpConnectionProvider, ProxyInfo>)requestHttp);
            }
            case OK_HTTP: {
                return new CommonUploadMultiRequestExecutorOkHttpImpl((RequestHttp<OkHttpClient, OkHttpProxyInfo>)requestHttp);
            }
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684http\u6267\u884c\u5668\u7c7b\u578b\uff1a" + requestHttp.getRequestType());
    }
}

