/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.result;

import com.github.binarywang.wxpay.bean.result.WxPayBillInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;

public class WxPayBillResult
implements Serializable {
    private static final String TOTAL_DEAL_COUNT = "\u603b\u4ea4\u6613\u5355\u6570";
    private static final long serialVersionUID = -7687458652694204070L;
    private List<WxPayBillInfo> billInfoList;
    private String totalRecord;
    private String totalFee;
    private String totalRefundFee;
    private String totalCouponFee;
    private String totalPoundageFee;
    private String totalAmount;
    private String totalAppliedRefundFee;

    public String toString() {
        return WxGsonBuilder.create().toJson((Object)this);
    }

    public static WxPayBillResult fromRawBillResultString(String responseContent, String billType) {
        switch (billType) {
            case "ALL": {
                return WxPayBillResult.fromRawBillResultString(responseContent);
            }
            case "SUCCESS": {
                return WxPayBillResult.fromRawBillResultStringToSuccess(responseContent);
            }
            case "REFUND": {
                return WxPayBillResult.fromRawBillResultStringToRefund(responseContent);
            }
            case "RECHARGE_REFUND": {
                return WxPayBillResult.fromRawBillResultStringToRechargeRefund(responseContent);
            }
        }
        return null;
    }

    private static WxPayBillResult fromRawBillResultString(String responseContent) {
        String listStr = "";
        String objStr = "";
        if (responseContent.contains(TOTAL_DEAL_COUNT)) {
            listStr = responseContent.substring(0, responseContent.indexOf(TOTAL_DEAL_COUNT));
            objStr = responseContent.substring(responseContent.indexOf(TOTAL_DEAL_COUNT));
        }
        ArrayList<WxPayBillInfo> results = new ArrayList<WxPayBillInfo>();
        String newStr = listStr.replaceAll(",", " ");
        String[] tempStr = newStr.split("`");
        String[] t = tempStr[0].split(" ");
        int j = tempStr.length / t.length;
        int k = 1;
        for (int i = 0; i < j; ++i) {
            WxPayBillInfo result = new WxPayBillInfo();
            result.setTradeTime(tempStr[k].trim());
            result.setAppId(tempStr[k + 1].trim());
            result.setMchId(tempStr[k + 2].trim());
            result.setSubMchId(tempStr[k + 3].trim());
            result.setDeviceInfo(tempStr[k + 4].trim());
            result.setTransactionId(tempStr[k + 5].trim());
            result.setOutTradeNo(tempStr[k + 6].trim());
            result.setOpenId(tempStr[k + 7].trim());
            result.setTradeType(tempStr[k + 8].trim());
            result.setTradeState(tempStr[k + 9].trim());
            result.setBankType(tempStr[k + 10].trim());
            result.setFeeType(tempStr[k + 11].trim());
            result.setTotalFee(tempStr[k + 12].trim());
            result.setCouponFee(tempStr[k + 13].trim());
            result.setRefundId(tempStr[k + 14].trim());
            result.setOutRefundNo(tempStr[k + 15].trim());
            result.setSettlementRefundFee(tempStr[k + 16].trim());
            result.setCouponRefundFee(tempStr[k + 17].trim());
            result.setRefundChannel(tempStr[k + 18].trim());
            result.setRefundState(tempStr[k + 19].trim());
            result.setBody(tempStr[k + 20].trim());
            result.setAttach(tempStr[k + 21].trim());
            result.setPoundage(tempStr[k + 22].trim());
            result.setPoundageRate(tempStr[k + 23].trim());
            result.setTotalAmount(tempStr[k + 24].trim());
            result.setAppliedRefundAmount(tempStr[k + 25].trim());
            result.setFeeRemark(tempStr[k + 26].trim());
            results.add(result);
            k += t.length;
        }
        WxPayBillResult billResult = new WxPayBillResult();
        billResult.setBillInfoList(results);
        String[] totalTempStr = objStr.replaceAll(",", " ").split("`");
        billResult.setTotalRecord(totalTempStr[1].trim());
        billResult.setTotalFee(totalTempStr[2].trim());
        billResult.setTotalRefundFee(totalTempStr[3].trim());
        billResult.setTotalCouponFee(totalTempStr[4].trim());
        billResult.setTotalPoundageFee(totalTempStr[5].trim());
        billResult.setTotalAmount(WxPayBillResult.get(totalTempStr, 6));
        billResult.setTotalAppliedRefundFee(WxPayBillResult.get(totalTempStr, 7));
        return billResult;
    }

    private static WxPayBillResult fromRawBillResultStringToSuccess(String responseContent) {
        String listStr = "";
        String objStr = "";
        if (responseContent.contains(TOTAL_DEAL_COUNT)) {
            listStr = responseContent.substring(0, responseContent.indexOf(TOTAL_DEAL_COUNT));
            objStr = responseContent.substring(responseContent.indexOf(TOTAL_DEAL_COUNT));
        }
        ArrayList<WxPayBillInfo> results = new ArrayList<WxPayBillInfo>();
        String newStr = listStr.replaceAll(",", " ");
        String[] tempStr = newStr.split("`");
        String[] t = tempStr[0].split(" ");
        int j = tempStr.length / t.length;
        int k = 1;
        for (int i = 0; i < j; ++i) {
            WxPayBillInfo result = new WxPayBillInfo();
            result.setTradeTime(tempStr[k].trim());
            result.setAppId(tempStr[k + 1].trim());
            result.setMchId(tempStr[k + 2].trim());
            result.setSubMchId(tempStr[k + 3].trim());
            result.setDeviceInfo(tempStr[k + 4].trim());
            result.setTransactionId(tempStr[k + 5].trim());
            result.setOutTradeNo(tempStr[k + 6].trim());
            result.setOpenId(tempStr[k + 7].trim());
            result.setTradeType(tempStr[k + 8].trim());
            result.setTradeState(tempStr[k + 9].trim());
            result.setBankType(tempStr[k + 10].trim());
            result.setFeeType(tempStr[k + 11].trim());
            result.setTotalFee(tempStr[k + 12].trim());
            result.setCouponFee(tempStr[k + 13].trim());
            result.setBody(tempStr[k + 14].trim());
            result.setAttach(tempStr[k + 15].trim());
            result.setPoundage(tempStr[k + 16].trim());
            result.setPoundageRate(tempStr[k + 17].trim());
            result.setTotalAmount(tempStr[k + 18].trim());
            result.setFeeRemark(tempStr[k + 19].trim());
            results.add(result);
            k += t.length;
        }
        WxPayBillResult billResult = new WxPayBillResult();
        billResult.setBillInfoList(results);
        String[] totalTempStr = objStr.replaceAll(",", " ").split("`");
        billResult.setTotalRecord(totalTempStr[1].trim());
        billResult.setTotalFee(totalTempStr[2].trim());
        billResult.setTotalRefundFee(totalTempStr[3].trim());
        billResult.setTotalCouponFee(totalTempStr[4].trim());
        billResult.setTotalPoundageFee(totalTempStr[5].trim());
        billResult.setTotalAmount(WxPayBillResult.get(totalTempStr, 6));
        billResult.setTotalAppliedRefundFee(WxPayBillResult.get(totalTempStr, 7));
        return billResult;
    }

    private static WxPayBillResult fromRawBillResultStringToRefund(String responseContent) {
        String listStr = "";
        String objStr = "";
        if (responseContent.contains(TOTAL_DEAL_COUNT)) {
            listStr = responseContent.substring(0, responseContent.indexOf(TOTAL_DEAL_COUNT));
            objStr = responseContent.substring(responseContent.indexOf(TOTAL_DEAL_COUNT));
        }
        ArrayList<WxPayBillInfo> results = new ArrayList<WxPayBillInfo>();
        String newStr = listStr.replaceAll(",", " ");
        String[] tempStr = newStr.split("`");
        String[] t = tempStr[0].split(" ");
        int j = tempStr.length / t.length;
        int k = 1;
        for (int i = 0; i < j; ++i) {
            WxPayBillInfo result = new WxPayBillInfo();
            result.setTradeTime(tempStr[k].trim());
            result.setAppId(tempStr[k + 1].trim());
            result.setMchId(tempStr[k + 2].trim());
            result.setSubMchId(tempStr[k + 3].trim());
            result.setDeviceInfo(tempStr[k + 4].trim());
            result.setTransactionId(tempStr[k + 5].trim());
            result.setOutTradeNo(tempStr[k + 6].trim());
            result.setOpenId(tempStr[k + 7].trim());
            result.setTradeType(tempStr[k + 8].trim());
            result.setTradeState(tempStr[k + 9].trim());
            result.setBankType(tempStr[k + 10].trim());
            result.setFeeType(tempStr[k + 11].trim());
            result.setTotalFee(tempStr[k + 12].trim());
            result.setCouponFee(tempStr[k + 13].trim());
            result.setRefundTime(tempStr[k + 14].trim());
            result.setRefundSuccessTime(tempStr[k + 15].trim());
            result.setRefundId(tempStr[k + 16].trim());
            result.setOutRefundNo(tempStr[k + 17].trim());
            result.setSettlementRefundFee(tempStr[k + 18].trim());
            result.setCouponRefundFee(tempStr[k + 19].trim());
            result.setRefundChannel(tempStr[k + 20].trim());
            result.setRefundState(tempStr[k + 21].trim());
            result.setBody(tempStr[k + 22].trim());
            result.setAttach(tempStr[k + 23].trim());
            result.setPoundage(tempStr[k + 24].trim());
            result.setPoundageRate(tempStr[k + 25].trim());
            results.add(result);
            k += t.length;
        }
        WxPayBillResult billResult = new WxPayBillResult();
        billResult.setBillInfoList(results);
        String[] totalTempStr = objStr.replaceAll(",", " ").split("`");
        billResult.setTotalRecord(totalTempStr[1].trim());
        billResult.setTotalFee(totalTempStr[2].trim());
        billResult.setTotalRefundFee(totalTempStr[3].trim());
        billResult.setTotalCouponFee(totalTempStr[4].trim());
        billResult.setTotalPoundageFee(totalTempStr[5].trim());
        billResult.setTotalAmount(WxPayBillResult.get(totalTempStr, 6));
        billResult.setTotalAppliedRefundFee(WxPayBillResult.get(totalTempStr, 7));
        return billResult;
    }

    private static WxPayBillResult fromRawBillResultStringToRechargeRefund(String responseContent) {
        String listStr = "";
        String objStr = "";
        if (responseContent.contains(TOTAL_DEAL_COUNT)) {
            listStr = responseContent.substring(0, responseContent.indexOf(TOTAL_DEAL_COUNT));
            objStr = responseContent.substring(responseContent.indexOf(TOTAL_DEAL_COUNT));
        }
        ArrayList<WxPayBillInfo> results = new ArrayList<WxPayBillInfo>();
        String newStr = listStr.replaceAll(",", " ");
        String[] tempStr = newStr.split("`");
        String[] t = tempStr[0].split(" ");
        int j = tempStr.length / t.length;
        int k = 1;
        for (int i = 0; i < j; ++i) {
            WxPayBillInfo result = new WxPayBillInfo();
            result.setTradeTime(tempStr[k].trim());
            result.setAppId(tempStr[k + 1].trim());
            result.setMchId(tempStr[k + 2].trim());
            result.setSubMchId(tempStr[k + 3].trim());
            result.setDeviceInfo(tempStr[k + 4].trim());
            result.setTransactionId(tempStr[k + 5].trim());
            result.setOutTradeNo(tempStr[k + 6].trim());
            result.setOpenId(tempStr[k + 7].trim());
            result.setTradeType(tempStr[k + 8].trim());
            result.setTradeState(tempStr[k + 9].trim());
            result.setBankType(tempStr[k + 10].trim());
            result.setFeeType(tempStr[k + 11].trim());
            result.setTotalFee(tempStr[k + 12].trim());
            result.setCouponFee(tempStr[k + 13].trim());
            result.setRefundTime(tempStr[k + 14].trim());
            result.setRefundSuccessTime(tempStr[k + 15].trim());
            result.setRefundId(tempStr[k + 16].trim());
            result.setOutRefundNo(tempStr[k + 17].trim());
            result.setSettlementRefundFee(tempStr[k + 18].trim());
            result.setCouponRefundFee(tempStr[k + 19].trim());
            result.setRefundChannel(tempStr[k + 20].trim());
            result.setRefundState(tempStr[k + 21].trim());
            result.setBody(tempStr[k + 22].trim());
            result.setAttach(tempStr[k + 23].trim());
            result.setPoundage(tempStr[k + 24].trim());
            result.setPoundageRate(tempStr[k + 25].trim());
            result.setTotalAmount(WxPayBillResult.get(tempStr, k + 26, t.length));
            result.setAppliedRefundAmount(WxPayBillResult.get(tempStr, k + 27, t.length));
            results.add(result);
            k += t.length;
        }
        WxPayBillResult billResult = new WxPayBillResult();
        billResult.setBillInfoList(results);
        String[] totalTempStr = objStr.replaceAll(",", " ").split("`");
        billResult.setTotalRecord(totalTempStr[1].trim());
        billResult.setTotalFee(totalTempStr[2].trim());
        billResult.setTotalRefundFee(totalTempStr[3].trim());
        billResult.setTotalCouponFee(totalTempStr[4].trim());
        billResult.setTotalPoundageFee(totalTempStr[5].trim());
        billResult.setTotalAmount(WxPayBillResult.get(totalTempStr, 6));
        billResult.setTotalAppliedRefundFee(WxPayBillResult.get(totalTempStr, 7));
        return billResult;
    }

    private static String get(String[] array, int idx) {
        return WxPayBillResult.get(array, idx, array.length);
    }

    private static String get(String[] array, int idx, int length) {
        if (length > idx) {
            return array[idx].trim();
        }
        return null;
    }

    public List<WxPayBillInfo> getBillInfoList() {
        return this.billInfoList;
    }

    public String getTotalRecord() {
        return this.totalRecord;
    }

    public String getTotalFee() {
        return this.totalFee;
    }

    public String getTotalRefundFee() {
        return this.totalRefundFee;
    }

    public String getTotalCouponFee() {
        return this.totalCouponFee;
    }

    public String getTotalPoundageFee() {
        return this.totalPoundageFee;
    }

    public String getTotalAmount() {
        return this.totalAmount;
    }

    public String getTotalAppliedRefundFee() {
        return this.totalAppliedRefundFee;
    }

    public void setBillInfoList(List<WxPayBillInfo> billInfoList) {
        this.billInfoList = billInfoList;
    }

    public void setTotalRecord(String totalRecord) {
        this.totalRecord = totalRecord;
    }

    public void setTotalFee(String totalFee) {
        this.totalFee = totalFee;
    }

    public void setTotalRefundFee(String totalRefundFee) {
        this.totalRefundFee = totalRefundFee;
    }

    public void setTotalCouponFee(String totalCouponFee) {
        this.totalCouponFee = totalCouponFee;
    }

    public void setTotalPoundageFee(String totalPoundageFee) {
        this.totalPoundageFee = totalPoundageFee;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public void setTotalAppliedRefundFee(String totalAppliedRefundFee) {
        this.totalAppliedRefundFee = totalAppliedRefundFee;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxPayBillResult)) {
            return false;
        }
        WxPayBillResult other = (WxPayBillResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<WxPayBillInfo> this$billInfoList = this.getBillInfoList();
        List<WxPayBillInfo> other$billInfoList = other.getBillInfoList();
        if (this$billInfoList == null ? other$billInfoList != null : !((Object)this$billInfoList).equals(other$billInfoList)) {
            return false;
        }
        String this$totalRecord = this.getTotalRecord();
        String other$totalRecord = other.getTotalRecord();
        if (this$totalRecord == null ? other$totalRecord != null : !this$totalRecord.equals(other$totalRecord)) {
            return false;
        }
        String this$totalFee = this.getTotalFee();
        String other$totalFee = other.getTotalFee();
        if (this$totalFee == null ? other$totalFee != null : !this$totalFee.equals(other$totalFee)) {
            return false;
        }
        String this$totalRefundFee = this.getTotalRefundFee();
        String other$totalRefundFee = other.getTotalRefundFee();
        if (this$totalRefundFee == null ? other$totalRefundFee != null : !this$totalRefundFee.equals(other$totalRefundFee)) {
            return false;
        }
        String this$totalCouponFee = this.getTotalCouponFee();
        String other$totalCouponFee = other.getTotalCouponFee();
        if (this$totalCouponFee == null ? other$totalCouponFee != null : !this$totalCouponFee.equals(other$totalCouponFee)) {
            return false;
        }
        String this$totalPoundageFee = this.getTotalPoundageFee();
        String other$totalPoundageFee = other.getTotalPoundageFee();
        if (this$totalPoundageFee == null ? other$totalPoundageFee != null : !this$totalPoundageFee.equals(other$totalPoundageFee)) {
            return false;
        }
        String this$totalAmount = this.getTotalAmount();
        String other$totalAmount = other.getTotalAmount();
        if (this$totalAmount == null ? other$totalAmount != null : !this$totalAmount.equals(other$totalAmount)) {
            return false;
        }
        String this$totalAppliedRefundFee = this.getTotalAppliedRefundFee();
        String other$totalAppliedRefundFee = other.getTotalAppliedRefundFee();
        return !(this$totalAppliedRefundFee == null ? other$totalAppliedRefundFee != null : !this$totalAppliedRefundFee.equals(other$totalAppliedRefundFee));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxPayBillResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<WxPayBillInfo> $billInfoList = this.getBillInfoList();
        result = result * 59 + ($billInfoList == null ? 43 : ((Object)$billInfoList).hashCode());
        String $totalRecord = this.getTotalRecord();
        result = result * 59 + ($totalRecord == null ? 43 : $totalRecord.hashCode());
        String $totalFee = this.getTotalFee();
        result = result * 59 + ($totalFee == null ? 43 : $totalFee.hashCode());
        String $totalRefundFee = this.getTotalRefundFee();
        result = result * 59 + ($totalRefundFee == null ? 43 : $totalRefundFee.hashCode());
        String $totalCouponFee = this.getTotalCouponFee();
        result = result * 59 + ($totalCouponFee == null ? 43 : $totalCouponFee.hashCode());
        String $totalPoundageFee = this.getTotalPoundageFee();
        result = result * 59 + ($totalPoundageFee == null ? 43 : $totalPoundageFee.hashCode());
        String $totalAmount = this.getTotalAmount();
        result = result * 59 + ($totalAmount == null ? 43 : $totalAmount.hashCode());
        String $totalAppliedRefundFee = this.getTotalAppliedRefundFee();
        result = result * 59 + ($totalAppliedRefundFee == null ? 43 : $totalAppliedRefundFee.hashCode());
        return result;
    }
}

