/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.brandmerchanttransfer.request.BrandMerchantBatchesQueryRequest;
import com.github.binarywang.wxpay.bean.brandmerchanttransfer.request.BrandMerchantDetailsQueryRequest;
import com.github.binarywang.wxpay.bean.brandmerchanttransfer.request.BrandTransferBatchesRequest;
import com.github.binarywang.wxpay.bean.brandmerchanttransfer.request.BrandWxBatchesQueryRequest;
import com.github.binarywang.wxpay.bean.brandmerchanttransfer.request.BrandWxDetailsQueryRequest;
import com.github.binarywang.wxpay.bean.brandmerchanttransfer.result.BrandBatchesQueryResult;
import com.github.binarywang.wxpay.bean.brandmerchanttransfer.result.BrandDetailsQueryResult;
import com.github.binarywang.wxpay.bean.brandmerchanttransfer.result.BrandTransferBatchesResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.BrandMerchantTransferService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.v3.util.RsaCryptoUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrandMerchantTransferServiceImpl
implements BrandMerchantTransferService {
    private static final Logger log = LoggerFactory.getLogger(BrandMerchantTransferServiceImpl.class);
    private static final Gson GSON = new GsonBuilder().create();
    private final WxPayService wxPayService;

    @Override
    public BrandTransferBatchesResult createBrandTransfer(BrandTransferBatchesRequest request) throws WxPayException {
        String url = String.format("%s/v3/fund-app/brand-redpacket/brand-merchant-batches", this.wxPayService.getPayBaseUrl());
        RsaCryptoUtil.encryptFields(request, this.wxPayService.getConfig().getVerifier().getValidCertificate());
        String response = this.wxPayService.postV3WithWechatpaySerial(url, GSON.toJson((Object)request));
        return (BrandTransferBatchesResult)GSON.fromJson(response, BrandTransferBatchesResult.class);
    }

    @Override
    public BrandBatchesQueryResult queryBrandWxBatches(BrandWxBatchesQueryRequest request) throws WxPayException {
        String url = String.format("%s/v3/fund-app/brand-redpacket/brand-merchant-batches/%s", this.wxPayService.getPayBaseUrl(), request.getBatchNo());
        if (request.getNeedQueryDetail() != null) {
            url = String.format("%s?need_query_detail=%b", url, request.getNeedQueryDetail());
        }
        if (request.getDetailState() != null && request.getDetailState().length() != 0) {
            url = String.format("%s&detail_state=%s", url, request.getDetailState());
        }
        String response = this.wxPayService.getV3(url);
        return (BrandBatchesQueryResult)GSON.fromJson(response, BrandBatchesQueryResult.class);
    }

    @Override
    public BrandDetailsQueryResult queryBrandWxDetails(BrandWxDetailsQueryRequest request) throws WxPayException {
        String url = String.format("%s/v3/fund-app/brand-redpacket/brand-merchant-batches/%s/details/%s", this.wxPayService.getPayBaseUrl(), request.getBatchNo(), request.getDetailNo());
        String response = this.wxPayService.getV3(url);
        return (BrandDetailsQueryResult)GSON.fromJson(response, BrandDetailsQueryResult.class);
    }

    @Override
    public BrandBatchesQueryResult queryBrandMerchantBatches(BrandMerchantBatchesQueryRequest request) throws WxPayException {
        String url = String.format("%s/v3/fund-app/brand-redpacket/brand-merchant-out-batches/%s", this.wxPayService.getPayBaseUrl(), request.getOutBatchNo());
        if (request.getNeedQueryDetail() != null) {
            url = String.format("%s?need_query_detail=%b", url, request.getNeedQueryDetail());
        }
        if (request.getDetailState() != null && request.getDetailState().length() != 0) {
            url = String.format("%s&detail_state=%s", url, request.getDetailState());
        }
        String response = this.wxPayService.getV3(url);
        return (BrandBatchesQueryResult)GSON.fromJson(response, BrandBatchesQueryResult.class);
    }

    @Override
    public BrandDetailsQueryResult queryBrandMerchantDetails(BrandMerchantDetailsQueryRequest request) throws WxPayException {
        String url = String.format("%s/v3/fund-app/brand-redpacket/brand-merchant-out-batches/%s/out-details/%s", this.wxPayService.getPayBaseUrl(), request.getOutBatchNo(), request.getOutDetailNo());
        String response = this.wxPayService.getV3(url);
        return (BrandDetailsQueryResult)GSON.fromJson(response, BrandDetailsQueryResult.class);
    }

    public BrandMerchantTransferServiceImpl(WxPayService wxPayService) {
        this.wxPayService = wxPayService;
    }
}

