/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.ecommerce.SignatureHeader;
import com.github.binarywang.wxpay.bean.payscore.PayScoreNotifyData;
import com.github.binarywang.wxpay.bean.payscore.WxPartnerPayScoreRequest;
import com.github.binarywang.wxpay.bean.payscore.WxPartnerPayScoreResult;
import com.github.binarywang.wxpay.bean.payscore.WxPartnerUserAuthorizationStatusNotifyResult;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.PartnerPayScoreService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.v3.util.AesUtils;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Objects;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;

public class PartnerPayScoreServiceImpl
implements PartnerPayScoreService {
    private static final Gson GSON = new GsonBuilder().create();
    private final WxPayService payService;

    @Override
    public WxPartnerPayScoreResult permissions(WxPartnerPayScoreRequest request) throws WxPayException {
        String url = this.payService.getPayBaseUrl() + "/v3/payscore/partner/permissions";
        request.setAppid(request.getAppid());
        request.setServiceId(request.getServiceId());
        WxPayConfig config = this.payService.getConfig();
        if (StringUtils.isBlank((CharSequence)request.getAppid())) {
            request.setAppid(config.getAppId());
        }
        if (StringUtils.isBlank((CharSequence)request.getServiceId())) {
            request.setServiceId(config.getServiceId());
        }
        if (StringUtils.isBlank((CharSequence)request.getNotifyUrl())) {
            request.setNotifyUrl(config.getPayScorePermissionNotifyUrl());
        }
        if (StringUtils.isBlank((CharSequence)request.getAuthorizationCode())) {
            throw new WxPayException("authorizationCode\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        String result = this.payService.postV3(url, request.toJson());
        return WxPartnerPayScoreResult.fromJson(result);
    }

    @Override
    public WxPartnerPayScoreResult permissionsQueryByAuthorizationCode(String serviceId, String subMchid, String authorizationCode) throws WxPayException {
        URIBuilder uriBuilder;
        if (StringUtils.isBlank((CharSequence)authorizationCode)) {
            throw new WxPayException("authorizationCode\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        String url = String.format("%s/v3/payscore/partner/permissions/authorization-code/%s", this.payService.getPayBaseUrl(), authorizationCode);
        try {
            uriBuilder = new URIBuilder(url);
        }
        catch (URISyntaxException e) {
            throw new WxPayException("\u672a\u77e5\u5f02\u5e38\uff01", e);
        }
        uriBuilder.setParameter("service_id", serviceId);
        uriBuilder.setParameter("sub_mchid", subMchid);
        try {
            String result = this.payService.getV3(uriBuilder.build().toString());
            return WxPartnerPayScoreResult.fromJson(result);
        }
        catch (URISyntaxException e) {
            throw new WxPayException("\u672a\u77e5\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public WxPartnerPayScoreResult permissionsTerminateByAuthorizationCode(String serviceId, String subMchid, String authorizationCode, String reason) throws WxPayException {
        if (StringUtils.isBlank((CharSequence)authorizationCode)) {
            throw new WxPayException("authorizationCode\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        String url = String.format("%s/v3/payscore/partner/permissions/authorization-code/%s/terminate", this.payService.getPayBaseUrl(), authorizationCode);
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("service_id", serviceId);
        map.put("sub_mchid", subMchid);
        map.put("reason", reason);
        String result = this.payService.postV3(url, WxGsonBuilder.create().toJson(map));
        return WxPartnerPayScoreResult.fromJson(result);
    }

    @Override
    public WxPartnerPayScoreResult permissionsQueryByOpenId(String serviceId, String appId, String subMchid, String subAppid, String openId, String subOpenid) throws WxPayException {
        URIBuilder uriBuilder;
        if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{openId, subOpenid}) || !StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{openId, subOpenid})) {
            throw new WxPayException("open_id,sub_openid\u4e0d\u5141\u8bb8\u90fd\u586b\u5199\u6216\u90fd\u4e0d\u586b\u5199");
        }
        if (StringUtils.isBlank((CharSequence)subMchid)) {
            throw new WxPayException("sub_mchid\u4e0d\u5141\u8bb8\u90fd\u4e3a\u7a7a");
        }
        String url = String.format("%s/v3/payscore/partner/permissions/openid/%s", this.payService.getPayBaseUrl(), openId);
        try {
            uriBuilder = new URIBuilder(url);
        }
        catch (URISyntaxException e) {
            throw new WxPayException("\u672a\u77e5\u5f02\u5e38\uff01", e);
        }
        uriBuilder.setParameter("appid", appId);
        uriBuilder.setParameter("service_id", serviceId);
        uriBuilder.setParameter("sub_mchid", subMchid);
        uriBuilder.setParameter("sub_appid", subAppid);
        uriBuilder.setParameter("openid", openId);
        uriBuilder.setParameter("sub_openid", subOpenid);
        if (StringUtils.isNotEmpty((CharSequence)openId)) {
            uriBuilder.setParameter("openid", openId);
        }
        if (StringUtils.isNotEmpty((CharSequence)subOpenid)) {
            uriBuilder.setParameter("sub_openid", subOpenid);
        }
        try {
            String result = this.payService.getV3(uriBuilder.build().toString());
            return WxPartnerPayScoreResult.fromJson(result);
        }
        catch (URISyntaxException e) {
            throw new WxPayException("\u672a\u77e5\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public WxPartnerPayScoreResult permissionsTerminateByOpenId(String serviceId, String appId, String subMchid, String subAppid, String openId, String subOpenid, String reason) throws WxPayException {
        if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{openId, subOpenid}) || !StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{openId, subOpenid})) {
            throw new WxPayException("open_id,sub_openid\u4e0d\u5141\u8bb8\u90fd\u586b\u5199\u6216\u90fd\u4e0d\u586b\u5199");
        }
        String url = String.format("%s/v3/payscore/partner/permissions/openid/%s/terminate", this.payService.getPayBaseUrl(), openId);
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("appid", appId);
        map.put("sub_appid", subAppid);
        map.put("service_id", serviceId);
        if (StringUtils.isNotEmpty((CharSequence)openId)) {
            map.put("openid", openId);
        }
        if (StringUtils.isNotEmpty((CharSequence)subOpenid)) {
            map.put("sub_openid", subOpenid);
        }
        map.put("sub_mchid", subMchid);
        map.put("reason", reason);
        String result = this.payService.postV3(url, WxGsonBuilder.create().toJson(map));
        return WxPartnerPayScoreResult.fromJson(result);
    }

    @Override
    public WxPartnerPayScoreResult createServiceOrder(WxPartnerPayScoreRequest request) throws WxPayException {
        String url = this.payService.getPayBaseUrl() + "/v3/payscore/partner/serviceorder";
        WxPayConfig config = this.payService.getConfig();
        if (StringUtils.isBlank((CharSequence)request.getAppid())) {
            request.setAppid(config.getAppId());
        }
        if (StringUtils.isBlank((CharSequence)request.getServiceId())) {
            request.setServiceId(config.getServiceId());
        }
        if (StringUtils.isBlank((CharSequence)request.getNotifyUrl())) {
            request.setNotifyUrl(config.getPayScoreNotifyUrl());
        }
        String result = this.payService.postV3(url, request.toJson());
        return WxPartnerPayScoreResult.fromJson(result);
    }

    @Override
    public WxPartnerPayScoreResult queryServiceOrder(String serviceId, String subMchid, String outOrderNo, String queryId) throws WxPayException {
        URIBuilder uriBuilder;
        String url = this.payService.getPayBaseUrl() + "/v3/payscore/partner/serviceorder";
        try {
            uriBuilder = new URIBuilder(url);
        }
        catch (URISyntaxException e) {
            throw new WxPayException("\u672a\u77e5\u5f02\u5e38\uff01", e);
        }
        uriBuilder.setParameter("service_id", serviceId);
        uriBuilder.setParameter("sub_mchid", subMchid);
        if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{outOrderNo, queryId}) || !StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{outOrderNo, queryId})) {
            throw new WxPayException("out_order_no,query_id\u4e0d\u5141\u8bb8\u90fd\u586b\u5199\u6216\u90fd\u4e0d\u586b\u5199");
        }
        if (StringUtils.isNotEmpty((CharSequence)outOrderNo)) {
            uriBuilder.setParameter("out_order_no", outOrderNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)queryId)) {
            uriBuilder.setParameter("query_id", queryId);
        }
        try {
            String result = this.payService.getV3(uriBuilder.build().toString());
            return WxPartnerPayScoreResult.fromJson(result);
        }
        catch (URISyntaxException e) {
            throw new WxPayException("\u672a\u77e5\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public WxPartnerPayScoreResult cancelServiceOrder(String serviceId, String appId, String subMchid, String outOrderNo, String reason) throws WxPayException {
        String url = String.format("%s/v3/payscore/partner/serviceorder/%s/cancel", this.payService.getPayBaseUrl(), outOrderNo);
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("appid", appId);
        map.put("service_id", serviceId);
        map.put("sub_mchid", subMchid);
        map.put("reason", reason);
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{appId, serviceId, subMchid, reason})) {
            throw new WxPayException("appid, service_id, sub_mchid, reason\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String result = this.payService.postV3(url, WxGsonBuilder.create().toJson(map));
        return WxPartnerPayScoreResult.fromJson(result);
    }

    @Override
    public WxPartnerPayScoreResult modifyServiceOrder(WxPartnerPayScoreRequest request) throws WxPayException {
        String outOrderNo = request.getOutOrderNo();
        String url = String.format("%s/v3/payscore/partner/serviceorder/%s/modify", this.payService.getPayBaseUrl(), outOrderNo);
        request.setAppid(this.payService.getConfig().getAppId());
        request.setOutOrderNo(null);
        String result = this.payService.postV3(url, request.toJson());
        return WxPartnerPayScoreResult.fromJson(result);
    }

    @Override
    public void completeServiceOrder(WxPartnerPayScoreRequest request) throws WxPayException {
        String outOrderNo = request.getOutOrderNo();
        String url = String.format("%s/v3/payscore/partner/serviceorder/%s/complete", this.payService.getPayBaseUrl(), outOrderNo);
        WxPayConfig config = this.payService.getConfig();
        if (StringUtils.isBlank((CharSequence)request.getServiceId())) {
            request.setServiceId(config.getServiceId());
        }
        if (StringUtils.isBlank((CharSequence)request.getSubMchid())) {
            request.setSubMchid(config.getSubMchId());
        }
        request.setOutOrderNo(null);
        this.payService.postV3(url, request.toJson());
    }

    @Override
    public WxPartnerPayScoreResult payServiceOrder(String serviceId, String appId, String subMchid, String outOrderNo) throws WxPayException {
        String url = String.format("%s/v3/payscore/partner/serviceorder/%s/pay", this.payService.getPayBaseUrl(), outOrderNo);
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("appid", appId);
        map.put("service_id", serviceId);
        map.put("sub_mchid", subMchid);
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{appId, serviceId, subMchid})) {
            throw new WxPayException("appid, service_id, sub_mchid\u90fd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String result = this.payService.postV3(url, WxGsonBuilder.create().toJson(map));
        return WxPartnerPayScoreResult.fromJson(result);
    }

    @Override
    public WxPartnerPayScoreResult syncServiceOrder(WxPartnerPayScoreRequest request) throws WxPayException {
        String outOrderNo = request.getOutOrderNo();
        String url = String.format("%s/v3/payscore/partner/serviceorder/%s/sync", this.payService.getPayBaseUrl(), outOrderNo);
        if (StringUtils.isBlank((CharSequence)request.getAppid())) {
            request.setAppid(this.payService.getConfig().getAppId());
        }
        request.setOutOrderNo(null);
        String result = this.payService.postV3(url, request.toJson());
        return WxPartnerPayScoreResult.fromJson(result);
    }

    @Override
    public WxPartnerPayScoreResult applyServiceAccount(WxPartnerPayScoreRequest request) throws WxPayException {
        String url = String.format("%s/v3/payscore/partner/service-account-applications", this.payService.getPayBaseUrl());
        HashMap params = Maps.newHashMap();
        params.put("service_id", request.getServiceId());
        params.put("appid", request.getAppid());
        params.put("sub_mchid", request.getSubMchid());
        params.put("sub_appid", request.getSubAppid());
        params.put("out_apply_no", request.getOutApplyNo());
        params.put("result_notify_url", request.getResultNotifyUrl());
        String result = this.payService.postV3(url, WxGsonBuilder.create().toJson((Object)params));
        return WxPartnerPayScoreResult.fromJson(result);
    }

    @Override
    public WxPartnerPayScoreResult queryServiceAccountState(String outApplyNo) throws WxPayException {
        String url = String.format("%s/v3/payscore/partner/service-account-applications/%s", this.payService.getPayBaseUrl(), outApplyNo);
        String result = this.payService.getV3(url);
        return WxPartnerPayScoreResult.fromJson(result);
    }

    @Override
    public WxPartnerUserAuthorizationStatusNotifyResult parseUserAuthorizationStatusNotifyResult(String notifyData, SignatureHeader header) throws WxPayException {
        PayScoreNotifyData response = this.parseNotifyData(notifyData, header);
        PayScoreNotifyData.Resource resource = response.getResource();
        String cipherText = resource.getCipherText();
        String associatedData = resource.getAssociatedData();
        String nonce = resource.getNonce();
        String apiV3Key = this.payService.getConfig().getApiV3Key();
        try {
            String result = AesUtils.decryptToString(associatedData, nonce, cipherText, apiV3Key);
            WxPartnerUserAuthorizationStatusNotifyResult notifyResult = (WxPartnerUserAuthorizationStatusNotifyResult)GSON.fromJson(result, WxPartnerUserAuthorizationStatusNotifyResult.class);
            notifyResult.setRawData(response);
            return notifyResult;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new WxPayException("\u89e3\u6790\u62a5\u6587\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public PayScoreNotifyData parseNotifyData(String data, SignatureHeader header) throws WxPayException {
        if (Objects.nonNull(header) && !this.verifyNotifySign(header, data)) {
            throw new WxPayException("\u975e\u6cd5\u8bf7\u6c42\uff0c\u5934\u90e8\u4fe1\u606f\u9a8c\u8bc1\u5931\u8d25");
        }
        return (PayScoreNotifyData)GSON.fromJson(data, PayScoreNotifyData.class);
    }

    @Override
    public WxPartnerPayScoreResult decryptNotifyDataResource(PayScoreNotifyData data) throws WxPayException {
        PayScoreNotifyData.Resource resource = data.getResource();
        String cipherText = resource.getCipherText();
        String associatedData = resource.getAssociatedData();
        String nonce = resource.getNonce();
        String apiV3Key = this.payService.getConfig().getApiV3Key();
        try {
            return WxPartnerPayScoreResult.fromJson(AesUtils.decryptToString(associatedData, nonce, cipherText, apiV3Key));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new WxPayException("\u89e3\u6790\u62a5\u6587\u5f02\u5e38\uff01", e);
        }
    }

    private boolean verifyNotifySign(SignatureHeader header, String data) {
        String beforeSign = String.format("%s\n%s\n%s\n", header.getTimeStamp(), header.getNonce(), data);
        return this.payService.getConfig().getVerifier().verify(header.getSerialNo(), beforeSign.getBytes(StandardCharsets.UTF_8), header.getSigned());
    }

    public PartnerPayScoreServiceImpl(WxPayService payService) {
        this.payService = payService;
    }
}

