/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.v3.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import me.chanjar.weixin.common.error.WxRuntimeException;

public class PemUtils {
    public static PrivateKey loadPrivateKey(InputStream inputStream) {
        try {
            int length;
            ByteArrayOutputStream array = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                array.write(buffer, 0, length);
            }
            String privateKey = array.toString("utf-8").replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\\s+", "");
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privateKey)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new WxRuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301RSA", (Throwable)e);
        }
        catch (InvalidKeySpecException e) {
            throw new WxRuntimeException("\u65e0\u6548\u7684\u5bc6\u94a5\u683c\u5f0f");
        }
        catch (IOException e) {
            throw new WxRuntimeException("\u65e0\u6548\u7684\u5bc6\u94a5");
        }
    }

    public static X509Certificate loadCertificate(InputStream inputStream) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(inputStream);
            cert.checkValidity();
            return cert;
        }
        catch (CertificateExpiredException e) {
            throw new WxRuntimeException("\u8bc1\u4e66\u5df2\u8fc7\u671f", (Throwable)e);
        }
        catch (CertificateNotYetValidException e) {
            throw new WxRuntimeException("\u8bc1\u4e66\u5c1a\u672a\u751f\u6548", (Throwable)e);
        }
        catch (CertificateException e) {
            throw new WxRuntimeException("\u65e0\u6548\u7684\u8bc1\u4e66", (Throwable)e);
        }
    }
}

