/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.mp.config;

import com.binarywang.spring.starter.wxjava.mp.properties.RedisProperties;
import com.binarywang.spring.starter.wxjava.mp.properties.WxMpProperties;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.mp.config.impl.WxMpDefaultConfigImpl;
import me.chanjar.weixin.mp.config.impl.WxMpRedisConfigImpl;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class WxMpStorageAutoConfiguration {
    private final WxMpProperties properties;
    @Autowired(required=false)
    private JedisPool jedisPool;

    @Bean
    @ConditionalOnMissingBean(value={WxMpConfigStorage.class})
    public WxMpConfigStorage wxMpInMemoryConfigStorage() {
        WxMpProperties.ConfigStorage storage = this.properties.getConfigStorage();
        WxMpProperties.StorageType type = storage.getType();
        if (type == WxMpProperties.StorageType.redis) {
            return this.getWxMpInRedisConfigStorage();
        }
        return this.getWxMpInMemoryConfigStorage();
    }

    private WxMpDefaultConfigImpl getWxMpInMemoryConfigStorage() {
        WxMpDefaultConfigImpl config = new WxMpDefaultConfigImpl();
        this.setWxMpInfo(config);
        return config;
    }

    private WxMpRedisConfigImpl getWxMpInRedisConfigStorage() {
        JedisPool poolToUse = this.jedisPool;
        if (poolToUse == null) {
            poolToUse = this.getJedisPool();
        }
        WxMpRedisConfigImpl config = new WxMpRedisConfigImpl(poolToUse);
        this.setWxMpInfo((WxMpDefaultConfigImpl)config);
        return config;
    }

    private void setWxMpInfo(WxMpDefaultConfigImpl config) {
        config.setAppId(this.properties.getAppId());
        config.setSecret(this.properties.getSecret());
        config.setToken(this.properties.getToken());
        config.setAesKey(this.properties.getAesKey());
    }

    private JedisPool getJedisPool() {
        WxMpProperties.ConfigStorage storage = this.properties.getConfigStorage();
        RedisProperties redis = storage.getRedis();
        JedisPoolConfig config = new JedisPoolConfig();
        if (redis.getMaxActive() != null) {
            config.setMaxTotal(redis.getMaxActive().intValue());
        }
        if (redis.getMaxIdle() != null) {
            config.setMaxIdle(redis.getMaxIdle().intValue());
        }
        if (redis.getMaxWaitMillis() != null) {
            config.setMaxWaitMillis((long)redis.getMaxWaitMillis().intValue());
        }
        if (redis.getMinIdle() != null) {
            config.setMinIdle(redis.getMinIdle().intValue());
        }
        config.setTestOnBorrow(true);
        config.setTestWhileIdle(true);
        JedisPool pool = new JedisPool((GenericObjectPoolConfig)config, redis.getHost(), redis.getPort(), redis.getTimeout(), redis.getPassword(), redis.getDatabase());
        return pool;
    }

    public WxMpStorageAutoConfiguration(WxMpProperties properties) {
        this.properties = properties;
    }
}

