/*
 * Decompiled with CFR 0.152.
 */
package com.github.dantwining.whitespace;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;

public class WhitespaceUtils {
    private WhitespaceUtils() {
        throw new AssertionError((Object)"Utility class: should never be instantiated");
    }

    public static void detectWhitespace(boolean verify, File searchBaseDirectory, Log mavenLog) throws MojoExecutionException, MojoFailureException {
        if (!searchBaseDirectory.isDirectory()) {
            mavenLog.debug((CharSequence)("Skipping non-existent directory: " + searchBaseDirectory.getAbsolutePath()));
            return;
        }
        String[] extensions = new String[]{"java", "xml"};
        Collection matchingFiles = FileUtils.listFiles((File)searchBaseDirectory, (String[])extensions, (boolean)true);
        for (File matchingFile : matchingFiles) {
            List lines;
            mavenLog.debug((CharSequence)("Reading file: " + matchingFile.getAbsolutePath()));
            try {
                lines = FileUtils.readLines((File)matchingFile, (String)"UTF-8");
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to read lines from " + matchingFile.getAbsolutePath(), (Exception)e);
            }
            Boolean isFileModified = false;
            ArrayList<String> trimmedLines = new ArrayList<String>(lines.size());
            int lineNumber = 0;
            for (String line : lines) {
                String trimmedLine;
                if (mavenLog.isDebugEnabled()) {
                    ++lineNumber;
                }
                Boolean isLineModified = !(trimmedLine = StringUtils.stripEnd((String)line, null)).equals(line);
                if (mavenLog.isDebugEnabled() && isLineModified.booleanValue()) {
                    mavenLog.debug((CharSequence)("Whitespace found on line " + lineNumber));
                }
                trimmedLines.add(trimmedLine);
                isFileModified = isFileModified != false || isLineModified != false;
            }
            if (!isFileModified.booleanValue()) continue;
            if (verify) {
                throw new MojoFailureException("Trailing whitespace found in " + matchingFile.getAbsolutePath());
            }
            try {
                FileUtils.writeLines((File)matchingFile, (String)"UTF-8", trimmedLines);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to write lines to " + matchingFile.getAbsolutePath(), (Exception)e);
            }
        }
    }
}

