/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Core.IMessage;

import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.IMessage.INetMessage;
import HslCommunication.Utilities;

public class HslMessage
implements INetMessage {
    private byte[] HeadBytes = null;
    private byte[] ContentBytes = null;
    private byte[] SendBytes = null;

    @Override
    public int ProtocolHeadBytesLength() {
        return 32;
    }

    @Override
    public int GetContentLengthByHeadBytes() {
        if (this.HeadBytes == null) {
            return 0;
        }
        if (this.HeadBytes.length != 32) {
            return 0;
        }
        return Utilities.getInt(this.HeadBytes, 28);
    }

    @Override
    public boolean CheckHeadBytesLegal(byte[] token) {
        return SoftBasic.IsTwoBytesEquel(this.HeadBytes, 12, token, 0, 16);
    }

    @Override
    public int GetHeadBytesIdentity() {
        return Utilities.getInt(this.HeadBytes, 0);
    }

    @Override
    public byte[] getHeadBytes() {
        return this.HeadBytes;
    }

    @Override
    public byte[] getContentBytes() {
        return this.ContentBytes;
    }

    @Override
    public byte[] getSendBytes() {
        return this.SendBytes;
    }

    @Override
    public void setHeadBytes(byte[] headBytes) {
        this.HeadBytes = headBytes;
    }

    @Override
    public void setContentBytes(byte[] contentBytes) {
        this.ContentBytes = contentBytes;
    }

    @Override
    public void setSendBytes(byte[] sendBytes) {
        this.SendBytes = sendBytes;
    }
}

