/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Core.IMessage;

import HslCommunication.Core.IMessage.INetMessage;
import HslCommunication.Utilities;

public class MelsecA1EAsciiMessage
implements INetMessage {
    private byte[] HeadBytes = null;
    private byte[] ContentBytes = null;
    private byte[] SendBytes = null;

    @Override
    public int ProtocolHeadBytesLength() {
        return 4;
    }

    @Override
    public int GetContentLengthByHeadBytes() {
        if (this.HeadBytes[2] == 53 && this.HeadBytes[3] == 66) {
            return 4;
        }
        if (this.HeadBytes[2] == 48 && this.HeadBytes[3] == 48) {
            int length = Integer.parseInt(Utilities.getString(this.SendBytes, 20, 2, "US-ASCII"), 16);
            switch (this.HeadBytes[1]) {
                case 48: {
                    return length;
                }
                case 49: {
                    return length * 4;
                }
                case 50: 
                case 51: {
                    return 0;
                }
            }
            return 0;
        }
        return 0;
    }

    @Override
    public boolean CheckHeadBytesLegal(byte[] token) {
        if (this.HeadBytes != null) {
            return this.HeadBytes[0] - this.SendBytes[0] == 8;
        }
        return false;
    }

    @Override
    public int GetHeadBytesIdentity() {
        return 0;
    }

    @Override
    public byte[] getHeadBytes() {
        return this.HeadBytes;
    }

    @Override
    public byte[] getContentBytes() {
        return this.ContentBytes;
    }

    @Override
    public byte[] getSendBytes() {
        return this.SendBytes;
    }

    @Override
    public void setHeadBytes(byte[] headBytes) {
        this.HeadBytes = headBytes;
    }

    @Override
    public void setContentBytes(byte[] contentBytes) {
        this.ContentBytes = contentBytes;
    }

    @Override
    public void setSendBytes(byte[] sendBytes) {
        this.SendBytes = sendBytes;
    }
}

