/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Core.IMessage;

import HslCommunication.Core.IMessage.INetMessage;

public class ModbusTcpMessage
implements INetMessage {
    private byte[] HeadBytes = null;
    private byte[] ContentBytes = null;
    private byte[] SendBytes = null;

    @Override
    public int ProtocolHeadBytesLength() {
        return 8;
    }

    @Override
    public int GetContentLengthByHeadBytes() {
        if (this.HeadBytes == null) {
            return 0;
        }
        if (this.HeadBytes.length >= this.ProtocolHeadBytesLength()) {
            int length = (this.HeadBytes[4] & 0xFF) * 256 + (this.HeadBytes[5] & 0xFF);
            if (length == 0) {
                byte[] buffer = new byte[this.ProtocolHeadBytesLength() - 1];
                for (int i = 0; i < buffer.length; ++i) {
                    buffer[i] = this.HeadBytes[i + 1];
                }
                this.HeadBytes = buffer;
                return (this.HeadBytes[5] & 0xFF) * 256 + (this.HeadBytes[6] & 0xFF) - 1;
            }
            return length - 2;
        }
        return 0;
    }

    @Override
    public boolean CheckHeadBytesLegal(byte[] token) {
        if (this.HeadBytes == null) {
            return false;
        }
        return this.HeadBytes[2] == 0 && this.HeadBytes[3] == 0;
    }

    @Override
    public int GetHeadBytesIdentity() {
        return 0;
    }

    @Override
    public byte[] getHeadBytes() {
        return this.HeadBytes;
    }

    @Override
    public byte[] getContentBytes() {
        return this.ContentBytes;
    }

    @Override
    public byte[] getSendBytes() {
        return this.SendBytes;
    }

    @Override
    public void setHeadBytes(byte[] headBytes) {
        this.HeadBytes = headBytes;
    }

    @Override
    public void setContentBytes(byte[] contentBytes) {
        this.ContentBytes = contentBytes;
    }

    @Override
    public void setSendBytes(byte[] sendBytes) {
        this.SendBytes = sendBytes;
    }
}

