/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Core.Net.NetworkBase;

import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.Net.NetworkBase.NetworkBase;
import HslCommunication.Core.Thread.SimpleHybirdLock;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.StringResources;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class NetworkUdpBase
extends NetworkBase {
    private String ipAddress = "127.0.0.1";
    private int port = 10000;
    private int receiveTimeOut = 10000;
    private String connectionId = "";
    protected SimpleHybirdLock simpleHybirdLock = new SimpleHybirdLock();
    private DatagramSocket datagramSocket;
    private DatagramPacket datagramPacket;
    private int receiveCacheLength = 2048;

    public NetworkUdpBase() {
        this.connectionId = SoftBasic.GetUniqueStringByGuidAndRandom();
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getReceiveTimeOut() {
        return this.receiveTimeOut;
    }

    public void setReceiveTimeOut(int receiveTimeOut) {
        this.receiveTimeOut = receiveTimeOut;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setConnectionId(String connectionId) {
        this.connectionId = connectionId;
    }

    public int getReceiveCacheLength() {
        return this.receiveCacheLength;
    }

    public void setReceiveCacheLength(int receiveCacheLength) {
        this.receiveCacheLength = receiveCacheLength;
    }

    public OperateResultExOne<byte[]> ReadFromCoreServer(byte[] value) {
        if (this.LogNet != null) {
            this.LogNet.WriteDebug(this.toString(), StringResources.Language.Send() + " : " + SoftBasic.ByteToHexString(value));
        }
        this.simpleHybirdLock.Enter();
        try {
            this.datagramSocket = new DatagramSocket();
            InetAddress address = InetAddress.getByName(this.getIpAddress());
            this.datagramPacket = new DatagramPacket(value, value.length, address, this.getPort());
            this.datagramSocket.send(this.datagramPacket);
            if (this.getReceiveTimeOut() > 0) {
                this.datagramSocket.setSoTimeout(this.getReceiveTimeOut());
            }
            if (this.getReceiveTimeOut() < 0) {
                this.simpleHybirdLock.Leave();
                return OperateResultExOne.CreateSuccessResult(new byte[0]);
            }
            byte[] buffer = new byte[this.getReceiveCacheLength()];
            DatagramPacket recePacket = new DatagramPacket(buffer, buffer.length);
            this.datagramSocket.receive(recePacket);
            byte[] receive = SoftBasic.BytesArraySelectBegin(buffer, recePacket.getLength());
            this.simpleHybirdLock.Leave();
            if (this.LogNet != null) {
                this.LogNet.WriteDebug(this.toString(), StringResources.Language.Receive() + " : " + SoftBasic.ByteToHexString(receive));
            }
            return OperateResultExOne.CreateSuccessResult(receive);
        }
        catch (Exception ex) {
            this.simpleHybirdLock.Leave();
            return new OperateResultExOne<byte[]>(ex.getMessage());
        }
    }

    @Override
    public String toString() {
        return "NetworkUdpBase[" + this.getIpAddress() + ":" + this.getPort() + "]";
    }
}

