/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.ModBus;

import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.Address.ModbusAddress;
import HslCommunication.Core.Net.NetworkBase.NetworkDeviceBase;
import HslCommunication.Core.Transfer.DataFormat;
import HslCommunication.Core.Transfer.ReverseWordTransform;
import HslCommunication.Core.Types.OperateResult;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.ModBus.ModbusInfo;
import HslCommunication.Serial.SoftCRC16;
import HslCommunication.StringResources;

public class ModbusRtuOverTcp
extends NetworkDeviceBase {
    private byte station = 1;
    private boolean isAddressStartWithZero = true;

    public ModbusRtuOverTcp() {
        this.setByteTransform(new ReverseWordTransform());
        this.WordLength = 1;
        this.station = 1;
        this.setSleepTime(20);
    }

    public ModbusRtuOverTcp(String ipAddress, int port, byte station) {
        this.setByteTransform(new ReverseWordTransform());
        this.setIpAddress(ipAddress);
        this.setPort(port);
        this.WordLength = 1;
        this.station = station;
        this.setSleepTime(20);
    }

    public boolean getAddressStartWithZero() {
        return this.isAddressStartWithZero;
    }

    public void setAddressStartWithZero(boolean addressStartWithZero) {
        this.isAddressStartWithZero = addressStartWithZero;
    }

    public byte getStation() {
        return this.station;
    }

    public void setStation(byte station) {
        this.station = station;
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.getByteTransform().setDataFormat(dataFormat);
    }

    public DataFormat getDataFormat() {
        return this.getByteTransform().getDataFormat();
    }

    public boolean isStringReverse() {
        return this.getByteTransform().getIsStringReverse();
    }

    public void setStringReverse(boolean stringReverse) {
        this.getByteTransform().setIsStringReverse(stringReverse);
    }

    protected OperateResultExOne<byte[]> CheckModbusTcpResponse(byte[] send) {
        send = ModbusInfo.PackCommandToRtu(send);
        OperateResultExOne<byte[]> result = this.ReadFromCoreServer(send);
        if (!result.IsSuccess) {
            return result;
        }
        if (((byte[])result.Content).length < 5) {
            return new OperateResultExOne<byte[]>(StringResources.Language.ReceiveDataLengthTooShort() + "5");
        }
        if (!SoftCRC16.CheckCRC16((byte[])result.Content)) {
            return new OperateResultExOne<byte[]>(StringResources.Language.ModbusCRCCheckFailed() + SoftBasic.ByteToHexString((byte[])result.Content, ' '));
        }
        if (send[1] + 128 == ((byte[])result.Content)[1]) {
            return new OperateResultExOne<byte[]>(((byte[])result.Content)[2], ModbusInfo.GetDescriptionByErrorCode(((byte[])result.Content)[2]));
        }
        if (send[1] != ((byte[])result.Content)[1]) {
            return new OperateResultExOne<byte[]>(((byte[])result.Content)[1], "Receive Command Check Failed: ");
        }
        return ModbusInfo.ExtractActualData(ModbusInfo.ExplodeRtuCommandToCore((byte[])result.Content));
    }

    private OperateResultExOne<byte[]> ReadModBus(ModbusAddress address, short length) {
        OperateResultExOne<byte[]> command = ModbusInfo.BuildReadModbusCommand(address, length);
        if (!command.IsSuccess) {
            return command;
        }
        return this.CheckModbusTcpResponse((byte[])command.Content);
    }

    public OperateResultExOne<Boolean> ReadCoil(String address) {
        return this.ReadBool(address);
    }

    public OperateResultExOne<boolean[]> ReadCoil(String address, short length) {
        return this.ReadBool(address, length);
    }

    public OperateResultExOne<Boolean> ReadDiscrete(String address) {
        OperateResultExOne<boolean[]> read = this.ReadDiscrete(address, (short)1);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return OperateResultExOne.CreateSuccessResult(((boolean[])read.Content)[0]);
    }

    public OperateResultExOne<boolean[]> ReadDiscrete(String address, short length) {
        OperateResultExOne<byte[]> command = ModbusInfo.BuildReadModbusCommand(address, length, this.getStation(), this.getAddressStartWithZero(), (byte)2);
        if (!command.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(command);
        }
        OperateResultExOne<byte[]> read = this.CheckModbusTcpResponse((byte[])command.Content);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return OperateResultExOne.CreateSuccessResult(SoftBasic.ByteToBoolArray((byte[])read.Content, length));
    }

    @Override
    public OperateResultExOne<byte[]> Read(String address, short length) {
        OperateResultExOne<ModbusAddress> analysis = ModbusInfo.AnalysisAddress(address, this.getStation(), this.isAddressStartWithZero, (byte)3);
        if (!analysis.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(analysis);
        }
        OperateResultExOne<byte[]> read = this.ReadModBus((ModbusAddress)analysis.Content, length);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return OperateResultExOne.CreateSuccessResult(read.Content);
    }

    @Override
    public OperateResult Write(String address, byte[] value) {
        OperateResultExOne<byte[]> command = ModbusInfo.BuildWriteWordModbusCommand(address, value, this.getStation(), this.getAddressStartWithZero(), (byte)16);
        if (!command.IsSuccess) {
            return command;
        }
        return this.CheckModbusTcpResponse((byte[])command.Content);
    }

    @Override
    public OperateResult Write(String address, short value) {
        OperateResultExOne<byte[]> command = ModbusInfo.BuildWriteWordModbusCommand(address, value, this.getStation(), this.getAddressStartWithZero(), (byte)6);
        if (!command.IsSuccess) {
            return command;
        }
        return this.CheckModbusTcpResponse((byte[])command.Content);
    }

    public OperateResult WriteMask(String address, short andMask, short orMask) {
        OperateResultExOne<byte[]> command = ModbusInfo.BuildWriteMaskModbusCommand(address, andMask, orMask, this.getStation(), this.getAddressStartWithZero(), (byte)22);
        if (!command.IsSuccess) {
            return command;
        }
        return this.CheckModbusTcpResponse((byte[])command.Content);
    }

    public OperateResult WriteOneRegister(String address, short value) {
        return this.Write(address, value);
    }

    @Override
    public OperateResultExOne<boolean[]> ReadBool(String address, short length) {
        OperateResultExOne<byte[]> command = ModbusInfo.BuildReadModbusCommand(address, length, this.getStation(), this.getAddressStartWithZero(), (byte)1);
        if (!command.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(command);
        }
        OperateResultExOne<byte[]> read = this.CheckModbusTcpResponse((byte[])command.Content);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return OperateResultExOne.CreateSuccessResult(SoftBasic.ByteToBoolArray((byte[])read.Content, length));
    }

    @Override
    public OperateResult Write(String address, boolean[] values) {
        OperateResultExOne<byte[]> command = ModbusInfo.BuildWriteBoolModbusCommand(address, values, this.getStation(), this.getAddressStartWithZero(), (byte)15);
        if (!command.IsSuccess) {
            return command;
        }
        return this.CheckModbusTcpResponse((byte[])command.Content);
    }

    @Override
    public OperateResult Write(String address, boolean value) {
        OperateResultExOne<byte[]> command = ModbusInfo.BuildWriteBoolModbusCommand(address, value, this.getStation(), this.getAddressStartWithZero(), (byte)5);
        if (!command.IsSuccess) {
            return command;
        }
        return this.CheckModbusTcpResponse((byte[])command.Content);
    }

    public String ToString() {
        return "ModbusRtuOverTcp[" + this.getIpAddress() + ":" + this.getPort() + "]";
    }
}

