/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.ModBus;

import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.BasicFramework.SoftIncrementCount;
import HslCommunication.Core.Address.ModbusAddress;
import HslCommunication.Core.IMessage.INetMessage;
import HslCommunication.Core.IMessage.ModbusTcpMessage;
import HslCommunication.Core.Net.NetworkBase.NetworkDeviceBase;
import HslCommunication.Core.Transfer.DataFormat;
import HslCommunication.Core.Transfer.ReverseWordTransform;
import HslCommunication.Core.Types.OperateResult;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.ModBus.ModbusInfo;
import HslCommunication.Utilities;
import java.util.ArrayList;

public class ModbusTcpNet
extends NetworkDeviceBase {
    private byte station = 1;
    private SoftIncrementCount softIncrementCount = new SoftIncrementCount(65535L, 0L);
    private boolean isAddressStartWithZero = true;

    public ModbusTcpNet() {
        this.WordLength = 1;
        this.station = 1;
        this.setByteTransform(new ReverseWordTransform());
    }

    public ModbusTcpNet(String ipAddress, int port, byte station) {
        this.setIpAddress(ipAddress);
        this.setPort(port);
        this.WordLength = 1;
        this.station = station;
        this.setByteTransform(new ReverseWordTransform());
    }

    @Override
    protected INetMessage GetNewNetMessage() {
        return new ModbusTcpMessage();
    }

    public boolean getAddressStartWithZero() {
        return this.isAddressStartWithZero;
    }

    public void setAddressStartWithZero(boolean addressStartWithZero) {
        this.isAddressStartWithZero = addressStartWithZero;
    }

    public byte getStation() {
        return this.station;
    }

    public void setStation(byte station) {
        this.station = station;
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.getByteTransform().setDataFormat(dataFormat);
    }

    public DataFormat getDataFormat() {
        return this.getByteTransform().getDataFormat();
    }

    public boolean isStringReverse() {
        return this.getByteTransform().getIsStringReverse();
    }

    public void setStringReverse(boolean stringReverse) {
        this.getByteTransform().setIsStringReverse(stringReverse);
    }

    public OperateResultExOne<Boolean> ReadCoil(String address) {
        return this.ReadBool(address);
    }

    public OperateResultExOne<boolean[]> ReadCoil(String address, short length) {
        return this.ReadBool(address, length);
    }

    public OperateResultExOne<Boolean> ReadDiscrete(String address) {
        OperateResultExOne<boolean[]> read = this.ReadDiscrete(address, (short)1);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return OperateResultExOne.CreateSuccessResult(((boolean[])read.Content)[0]);
    }

    public OperateResultExOne<boolean[]> ReadDiscrete(String address, short length) {
        OperateResultExOne<byte[]> command = ModbusInfo.BuildReadModbusCommand(address, length, this.getStation(), this.getAddressStartWithZero(), (byte)2);
        if (!command.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(command);
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(ModbusInfo.PackCommandToTcp((byte[])command.Content, (int)this.softIncrementCount.GetCurrentValue()));
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        OperateResultExOne<byte[]> extract = ModbusInfo.ExtractActualData(ModbusInfo.ExplodeTcpCommandToCore((byte[])read.Content));
        if (!extract.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(extract);
        }
        return OperateResultExOne.CreateSuccessResult(SoftBasic.ByteToBoolArray((byte[])extract.Content, length));
    }

    @Override
    public OperateResultExOne<byte[]> Read(String address, short length) {
        OperateResultExOne<ModbusAddress> analysis = ModbusInfo.AnalysisAddress(address, this.getStation(), this.getAddressStartWithZero(), (byte)3);
        if (!analysis.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(analysis);
        }
        ArrayList<Byte> lists = new ArrayList<Byte>();
        short alreadyFinished = 0;
        while (alreadyFinished < length) {
            short lengthTmp = (short)Math.min(length - alreadyFinished, 120);
            OperateResultExOne<byte[]> read = this.ReadModBus(((ModbusAddress)analysis.Content).AddressAdd(alreadyFinished), lengthTmp);
            if (!read.IsSuccess) {
                return OperateResultExOne.CreateFailedResult(read);
            }
            Utilities.ArrayListAddArray(lists, (byte[])read.Content);
            alreadyFinished = (short)(alreadyFinished + lengthTmp);
        }
        return OperateResultExOne.CreateSuccessResult(Utilities.getBytes(lists));
    }

    private OperateResultExOne<byte[]> ReadModBus(ModbusAddress address, short length) {
        OperateResultExOne<byte[]> command = ModbusInfo.BuildReadModbusCommand(address, length);
        if (!command.IsSuccess) {
            return command;
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(ModbusInfo.PackCommandToTcp((byte[])command.Content, (short)this.softIncrementCount.GetCurrentValue()));
        if (!read.IsSuccess) {
            return read;
        }
        return ModbusInfo.ExtractActualData(ModbusInfo.ExplodeTcpCommandToCore((byte[])read.Content));
    }

    @Override
    public OperateResult Write(String address, byte[] value) {
        OperateResultExOne<byte[]> command = ModbusInfo.BuildWriteWordModbusCommand(address, value, this.getStation(), this.getAddressStartWithZero(), (byte)16);
        if (!command.IsSuccess) {
            return command;
        }
        OperateResultExOne<byte[]> write = this.ReadFromCoreServer(ModbusInfo.PackCommandToTcp((byte[])command.Content, (short)this.softIncrementCount.GetCurrentValue()));
        if (!write.IsSuccess) {
            return write;
        }
        return ModbusInfo.ExtractActualData(ModbusInfo.ExplodeTcpCommandToCore((byte[])write.Content));
    }

    @Override
    public OperateResult Write(String address, short value) {
        OperateResultExOne<byte[]> command = ModbusInfo.BuildWriteWordModbusCommand(address, value, this.getStation(), this.getAddressStartWithZero(), (byte)6);
        if (!command.IsSuccess) {
            return command;
        }
        OperateResultExOne<byte[]> write = this.ReadFromCoreServer(ModbusInfo.PackCommandToTcp((byte[])command.Content, (short)this.softIncrementCount.GetCurrentValue()));
        if (!write.IsSuccess) {
            return write;
        }
        return ModbusInfo.ExtractActualData(ModbusInfo.ExplodeTcpCommandToCore((byte[])write.Content));
    }

    public OperateResult WriteMask(String address, short andMask, short orMask) {
        OperateResultExOne<byte[]> command = ModbusInfo.BuildWriteMaskModbusCommand(address, andMask, orMask, this.getStation(), this.getAddressStartWithZero(), (byte)22);
        if (!command.IsSuccess) {
            return command;
        }
        OperateResultExOne<byte[]> write = this.ReadFromCoreServer(ModbusInfo.PackCommandToTcp((byte[])command.Content, (short)this.softIncrementCount.GetCurrentValue()));
        if (!write.IsSuccess) {
            return write;
        }
        return ModbusInfo.ExtractActualData(ModbusInfo.ExplodeTcpCommandToCore((byte[])write.Content));
    }

    public OperateResult WriteOneRegister(String address, short value) {
        return this.Write(address, value);
    }

    @Override
    public OperateResultExOne<boolean[]> ReadBool(String address, short length) {
        OperateResultExOne<byte[]> command = ModbusInfo.BuildReadModbusCommand(address, length, this.getStation(), this.getAddressStartWithZero(), (byte)1);
        if (!command.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(command);
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(ModbusInfo.PackCommandToTcp((byte[])command.Content, (short)this.softIncrementCount.GetCurrentValue()));
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        OperateResultExOne<byte[]> extract = ModbusInfo.ExtractActualData(ModbusInfo.ExplodeTcpCommandToCore((byte[])read.Content));
        if (!extract.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(extract);
        }
        return OperateResultExOne.CreateSuccessResult(SoftBasic.ByteToBoolArray((byte[])extract.Content, length));
    }

    @Override
    public OperateResult Write(String address, boolean[] values) {
        OperateResultExOne<byte[]> command = ModbusInfo.BuildWriteBoolModbusCommand(address, values, this.getStation(), this.getAddressStartWithZero(), (byte)15);
        if (!command.IsSuccess) {
            return command;
        }
        OperateResultExOne<byte[]> write = this.ReadFromCoreServer(ModbusInfo.PackCommandToTcp((byte[])command.Content, (short)this.softIncrementCount.GetCurrentValue()));
        if (!write.IsSuccess) {
            return write;
        }
        return ModbusInfo.ExtractActualData(ModbusInfo.ExplodeTcpCommandToCore((byte[])write.Content));
    }

    @Override
    public OperateResult Write(String address, boolean value) {
        OperateResultExOne<byte[]> command = ModbusInfo.BuildWriteBoolModbusCommand(address, value, this.getStation(), this.getAddressStartWithZero(), (byte)5);
        if (!command.IsSuccess) {
            return command;
        }
        OperateResultExOne<byte[]> write = this.ReadFromCoreServer(ModbusInfo.PackCommandToTcp((byte[])command.Content, (short)this.softIncrementCount.GetCurrentValue()));
        if (!write.IsSuccess) {
            return write;
        }
        return ModbusInfo.ExtractActualData(ModbusInfo.ExplodeTcpCommandToCore((byte[])write.Content));
    }

    @Override
    public String toString() {
        return "ModbusTcpNet[" + this.getIpAddress() + ":" + this.getPort() + "]";
    }
}

