/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Profinet.AllenBradley;

import HslCommunication.Core.Types.OperateResultExThree;
import HslCommunication.StringResources;
import HslCommunication.Utilities;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AllenBradleyHelper {
    public static final byte CIP_READ_DATA = 76;
    public static final int CIP_WRITE_DATA = 77;
    public static final int CIP_READ_WRITE_DATA = 78;
    public static final int CIP_READ_FRAGMENT = 82;
    public static final int CIP_WRITE_FRAGMENT = 83;
    public static final int CIP_MULTIREAD_DATA = 4096;
    public static final int CIP_Type_Bool = 193;
    public static final int CIP_Type_Byte = 194;
    public static final int CIP_Type_Word = 195;
    public static final int CIP_Type_DWord = 196;
    public static final int CIP_Type_LInt = 197;
    public static final int CIP_Type_Real = 202;
    public static final int CIP_Type_Double = 203;
    public static final int CIP_Type_Struct = 204;
    public static final int CIP_Type_String = 208;
    public static final int CIP_Type_BitArray = 211;

    private static byte[] BuildRequestPathCommand(String address) throws IOException {
        ByteArrayOutputStream ms = new ByteArrayOutputStream();
        String[] tagNames = address.split("\\.");
        for (int i = 0; i < tagNames.length; ++i) {
            String strIndex = "";
            int indexFirst = tagNames[i].indexOf(91);
            int indexSecond = tagNames[i].indexOf(93);
            if (indexFirst > 0 && indexSecond > 0 && indexSecond > indexFirst) {
                strIndex = tagNames[i].substring(indexFirst + 1, indexSecond);
                tagNames[i] = tagNames[i].substring(0, indexFirst);
            }
            ms.write(145);
            byte[] nameBytes = Utilities.getBytes(tagNames[i], "UTF-8");
            ms.write((byte)nameBytes.length);
            ms.write(nameBytes, 0, nameBytes.length);
            if (nameBytes.length % 2 == 1) {
                ms.write(0);
            }
            if (Utilities.IsStringNullOrEmpty(strIndex)) continue;
            String[] indexes = strIndex.split(",");
            for (int j = 0; j < indexes.length; ++j) {
                int index = Integer.parseInt(indexes[j]);
                if (index < 256) {
                    ms.write(40);
                    ms.write((byte)index);
                    continue;
                }
                ms.write(41);
                ms.write(0);
                ms.write(Utilities.getBytes(index)[0]);
                ms.write(Utilities.getBytes(index)[1]);
            }
        }
        byte[] ret = ms.toByteArray();
        ms.close();
        return ret;
    }

    public static byte[] PackRequsetRead(String address, int length) throws IOException {
        byte[] buffer = new byte[1024];
        int offset = 0;
        buffer[offset++] = 76;
        byte[] requestPath = AllenBradleyHelper.BuildRequestPathCommand(address);
        System.arraycopy(requestPath, 0, buffer, ++offset, requestPath.length);
        buffer[1] = (byte)(((offset += requestPath.length) - 2) / 2);
        buffer[offset++] = Utilities.getBytes(length)[0];
        buffer[offset++] = Utilities.getBytes(length)[1];
        byte[] data = new byte[offset];
        System.arraycopy(buffer, 0, data, 0, offset);
        return data;
    }

    public static byte[] PackRequestReadSegment(String address, int startIndex, int length) throws IOException {
        byte[] buffer = new byte[1024];
        int offset = 0;
        buffer[offset++] = 82;
        byte[] requestPath = AllenBradleyHelper.BuildRequestPathCommand(address);
        System.arraycopy(requestPath, 0, buffer, ++offset, requestPath.length);
        buffer[1] = (byte)(((offset += requestPath.length) - 2) / 2);
        buffer[offset++] = Utilities.getBytes(length)[0];
        buffer[offset++] = Utilities.getBytes(length)[1];
        buffer[offset++] = Utilities.getBytes(startIndex)[0];
        buffer[offset++] = Utilities.getBytes(startIndex)[1];
        buffer[offset++] = Utilities.getBytes(startIndex)[2];
        buffer[offset++] = Utilities.getBytes(startIndex)[3];
        byte[] data = new byte[offset];
        System.arraycopy(buffer, 0, data, 0, offset);
        return data;
    }

    public static byte[] PackRequestWrite(String address, int typeCode, byte[] value) throws IOException {
        return AllenBradleyHelper.PackRequestWrite(address, typeCode, value, 1);
    }

    public static byte[] PackRequestWrite(String address, int typeCode, byte[] value, int length) throws IOException {
        byte[] buffer = new byte[1024];
        int offset = 0;
        buffer[offset++] = 77;
        byte[] requestPath = AllenBradleyHelper.BuildRequestPathCommand(address);
        System.arraycopy(requestPath, 0, buffer, ++offset, requestPath.length);
        buffer[1] = (byte)(((offset += requestPath.length) - 2) / 2);
        buffer[offset++] = Utilities.getBytes(typeCode)[0];
        buffer[offset++] = Utilities.getBytes(typeCode)[1];
        buffer[offset++] = Utilities.getBytes(length)[0];
        buffer[offset++] = Utilities.getBytes(length)[1];
        System.arraycopy(value, 0, buffer, offset, value.length);
        byte[] data = new byte[offset += value.length];
        System.arraycopy(buffer, 0, data, 0, offset);
        return data;
    }

    public static byte[] PackCommandService(byte[] portSlot, List<byte[]> cips) throws IOException {
        ByteArrayOutputStream ms = new ByteArrayOutputStream();
        ms.write(82);
        ms.write(2);
        ms.write(32);
        ms.write(6);
        ms.write(36);
        ms.write(1);
        ms.write(10);
        ms.write(240);
        ms.write(0);
        ms.write(0);
        int count = 0;
        if (cips.size() == 1) {
            ms.write(cips.get(0), 0, cips.get(0).length);
            count += cips.get(0).length;
        } else {
            int i;
            ms.write(10);
            ms.write(2);
            ms.write(32);
            ms.write(2);
            ms.write(36);
            ms.write(1);
            count += 8;
            ms.write(Utilities.getBytes((short)cips.size()), 0, 2);
            short offect = (short)(2 + 2 * cips.size());
            count += 2 * cips.size();
            for (i = 0; i < cips.size(); ++i) {
                ms.write(Utilities.getBytes(offect), 0, 2);
                offect = (short)(offect + cips.get(i).length);
            }
            for (i = 0; i < cips.size(); ++i) {
                ms.write(cips.get(i), 0, cips.get(i).length);
                count += cips.get(i).length;
            }
        }
        ms.write((byte)((portSlot.length + 1) / 2));
        ms.write(0);
        ms.write(portSlot, 0, portSlot.length);
        if (portSlot.length % 2 == 1) {
            ms.write(0);
        }
        byte[] data = ms.toByteArray();
        ms.close();
        data[8] = Utilities.getBytes(count)[0];
        data[9] = Utilities.getBytes(count)[1];
        return data;
    }

    public static byte[] PackCommandSpecificData(byte[] service) throws IOException {
        ByteArrayOutputStream ms = new ByteArrayOutputStream();
        ms.write(0);
        ms.write(0);
        ms.write(0);
        ms.write(0);
        ms.write(1);
        ms.write(0);
        ms.write(2);
        ms.write(0);
        ms.write(0);
        ms.write(0);
        ms.write(0);
        ms.write(0);
        ms.write(178);
        ms.write(0);
        ms.write(0);
        ms.write(0);
        ms.write(service, 0, service.length);
        byte[] data = ms.toByteArray();
        ms.close();
        data[14] = Utilities.getBytes((short)(data.length - 16))[0];
        data[15] = Utilities.getBytes((short)(data.length - 16))[1];
        return data;
    }

    public static byte[] PackRequestHeader(int command, int session, byte[] commandSpecificData) {
        byte[] buffer = new byte[commandSpecificData.length + 24];
        System.arraycopy(commandSpecificData, 0, buffer, 24, commandSpecificData.length);
        System.arraycopy(Utilities.getBytes(command), 0, buffer, 0, 2);
        System.arraycopy(Utilities.getBytes(commandSpecificData.length), 0, buffer, 2, 2);
        System.arraycopy(Utilities.getBytes(session), 0, buffer, 4, 4);
        return buffer;
    }

    public static OperateResultExThree<byte[], Short, Boolean> ExtractActualData(byte[] response, boolean isRead) {
        int i;
        ArrayList<Byte> data = new ArrayList<Byte>();
        int offset = 38;
        boolean hasMoreData = false;
        short dataType = 0;
        short count = Utilities.getShort(response, 38);
        if (Utilities.getInt(response, 40) == 138) {
            offset = 44;
            int dataCount = Utilities.getShort(response, offset);
            for (i = 0; i < dataCount; ++i) {
                int offectStart = Utilities.getShort(response, offset + 2 + i * 2) + offset;
                int offectEnd = i == dataCount - 1 ? response.length : Utilities.getShort(response, offset + 4 + i * 2) + offset;
                short err = Utilities.getShort(response, offectStart + 2);
                switch (err) {
                    case 4: {
                        return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley04());
                    }
                    case 5: {
                        return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley05());
                    }
                    case 6: {
                        if (response[offset + 2] != -46 && response[offset + 2] != -52) break;
                        return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley06());
                    }
                    case 10: {
                        return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley0A());
                    }
                    case 19: {
                        return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley13());
                    }
                    case 28: {
                        return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley1C());
                    }
                    case 30: {
                        return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley1E());
                    }
                    case 38: {
                        return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley26());
                    }
                    case 0: {
                        break;
                    }
                    default: {
                        return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.UnknownError());
                    }
                }
                if (!isRead) continue;
                for (int j = offectStart + 6; j < offectEnd; ++j) {
                    data.add(response[j]);
                }
            }
        } else {
            byte err = response[offset + 4];
            switch (err) {
                case 4: {
                    return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley04());
                }
                case 5: {
                    return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley05());
                }
                case 6: {
                    hasMoreData = true;
                    break;
                }
                case 10: {
                    return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley0A());
                }
                case 19: {
                    return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley13());
                }
                case 28: {
                    return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley1C());
                }
                case 30: {
                    return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley1E());
                }
                case 38: {
                    return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.AllenBradley26());
                }
                case 0: {
                    break;
                }
                default: {
                    return new OperateResultExThree<byte[], Short, Boolean>(err, StringResources.Language.UnknownError());
                }
            }
            if (response[offset + 2] == -51 || response[offset + 2] == -45) {
                return OperateResultExThree.CreateSuccessResult(new byte[0], dataType, hasMoreData);
            }
            if (response[offset + 2] == -52 || response[offset + 2] == -46) {
                for (i = offset + 8; i < offset + 2 + count; ++i) {
                    data.add(response[i]);
                }
                dataType = Utilities.getShort(response, offset + 6);
            } else if (response[offset + 2] == -43) {
                for (i = offset + 6; i < offset + 2 + count; ++i) {
                    data.add(response[i]);
                }
            }
        }
        byte[] buffer = new byte[data.size()];
        for (i = 0; i < buffer.length; ++i) {
            buffer[i] = (Byte)data.get(i);
        }
        return OperateResultExThree.CreateSuccessResult(buffer, dataType, hasMoreData);
    }
}

