/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Profinet.AllenBradley;

import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.IMessage.AllenBradleyMessage;
import HslCommunication.Core.IMessage.INetMessage;
import HslCommunication.Core.Net.NetworkBase.NetworkDeviceBase;
import HslCommunication.Core.Transfer.ByteTransformHelper;
import HslCommunication.Core.Transfer.RegularByteTransform;
import HslCommunication.Core.Types.FunctionOperateExOne;
import HslCommunication.Core.Types.OperateResult;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.Core.Types.OperateResultExThree;
import HslCommunication.Profinet.AllenBradley.AllenBradleyHelper;
import HslCommunication.StringResources;
import HslCommunication.Utilities;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class AllenBradleyNet
extends NetworkDeviceBase {
    private int SessionHandle = 0;
    private byte Slot = 0;
    public int ArraySegment = 100;
    public byte[] PortSlot = null;

    public AllenBradleyNet() {
        this.WordLength = (short)2;
        this.setByteTransform(new RegularByteTransform());
    }

    public AllenBradleyNet(String ipAddress) {
        this(ipAddress, 44818);
    }

    public AllenBradleyNet(String ipAddress, int port) {
        this.WordLength = (short)2;
        this.setIpAddress(ipAddress);
        this.setPort(port);
        this.setByteTransform(new RegularByteTransform());
    }

    @Override
    protected INetMessage GetNewNetMessage() {
        return new AllenBradleyMessage();
    }

    public int getSessionHandle() {
        return this.SessionHandle;
    }

    public byte getSlot() {
        return this.Slot;
    }

    public void setSlot(byte value) {
        this.Slot = value;
    }

    public int getArraySegment() {
        return this.ArraySegment;
    }

    public void setArraySegment(int value) {
        this.ArraySegment = value;
    }

    public byte[] getPortSlot() {
        return this.PortSlot;
    }

    public void setPortSlot(byte[] value) {
        this.PortSlot = value;
    }

    @Override
    protected OperateResult InitializationOnConnect(Socket socket) {
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(socket, this.RegisterSessionHandle());
        if (!read.IsSuccess) {
            return read;
        }
        OperateResult check = this.CheckResponse((byte[])read.Content);
        if (!check.IsSuccess) {
            return check;
        }
        this.SessionHandle = this.getByteTransform().TransInt32((byte[])read.Content, 4);
        return OperateResult.CreateSuccessResult();
    }

    @Override
    protected OperateResult ExtraOnDisconnect(Socket socket) {
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(socket, this.UnRegisterSessionHandle());
        if (!read.IsSuccess) {
            return read;
        }
        return OperateResult.CreateSuccessResult();
    }

    public OperateResultExOne<byte[]> BuildReadCommand(String[] address, int[] length) {
        if (address == null || length == null) {
            return new OperateResultExOne<byte[]>("address or length is null");
        }
        if (address.length != length.length) {
            return new OperateResultExOne<byte[]>("address and length is not same array");
        }
        try {
            byte[] byArray;
            ArrayList<byte[]> cips = new ArrayList<byte[]>();
            for (int i = 0; i < address.length; ++i) {
                cips.add(AllenBradleyHelper.PackRequsetRead(address[i], length[i]));
            }
            if (this.PortSlot == null) {
                byte[] byArray2 = new byte[2];
                byArray2[0] = 1;
                byArray = byArray2;
                byArray2[1] = this.Slot;
            } else {
                byArray = this.PortSlot;
            }
            byte[] commandSpecificData = AllenBradleyHelper.PackCommandSpecificData(AllenBradleyHelper.PackCommandService(byArray, cips));
            return OperateResultExOne.CreateSuccessResult(AllenBradleyHelper.PackRequestHeader(111, this.SessionHandle, commandSpecificData));
        }
        catch (Exception ex) {
            return new OperateResultExOne<byte[]>("Address Wrong:" + ex.getMessage());
        }
    }

    public OperateResultExOne<byte[]> BuildReadCommand(String[] address) {
        if (address == null) {
            return new OperateResultExOne<byte[]>("address or length is null");
        }
        int[] length = new int[address.length];
        for (int i = 0; i < address.length; ++i) {
            length[i] = 1;
        }
        return this.BuildReadCommand(address, length);
    }

    public OperateResultExOne<byte[]> BuildWriteCommand(String address, short typeCode, byte[] data) {
        return this.BuildWriteCommand(address, typeCode, data, 1);
    }

    public OperateResultExOne<byte[]> BuildWriteCommand(String address, short typeCode, byte[] data, int length) {
        try {
            byte[] byArray;
            byte[] cip = AllenBradleyHelper.PackRequestWrite(address, typeCode, data, length);
            if (this.PortSlot == null) {
                byte[] byArray2 = new byte[2];
                byArray2[0] = 1;
                byArray = byArray2;
                byArray2[1] = this.Slot;
            } else {
                byArray = this.PortSlot;
            }
            byte[] commandSpecificData = AllenBradleyHelper.PackCommandSpecificData(AllenBradleyHelper.PackCommandService(byArray, Arrays.asList(new byte[][]{cip})));
            return OperateResultExOne.CreateSuccessResult(AllenBradleyHelper.PackRequestHeader(111, this.SessionHandle, commandSpecificData));
        }
        catch (Exception ex) {
            return new OperateResultExOne<byte[]>("Address Wrong:" + ex.getMessage());
        }
    }

    @Override
    public OperateResultExOne<byte[]> Read(String address, short length) {
        if (length > 1) {
            return this.ReadSegment(address, 0, length);
        }
        return this.Read(new String[]{address}, new int[]{length});
    }

    public OperateResultExOne<byte[]> Read(String[] address) {
        if (address == null) {
            return new OperateResultExOne<byte[]>("address can not be null");
        }
        int[] length = new int[address.length];
        for (int i = 0; i < length.length; ++i) {
            length[i] = 1;
        }
        return this.Read(address, length);
    }

    public OperateResultExOne<byte[]> Read(String[] address, int[] length) {
        OperateResultExOne<byte[]> command = this.BuildReadCommand(address, length);
        if (!command.IsSuccess) {
            return command;
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content);
        if (!read.IsSuccess) {
            return read;
        }
        OperateResult check = this.CheckResponse((byte[])read.Content);
        if (!check.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(check);
        }
        OperateResultExThree<byte[], Short, Boolean> analysis = AllenBradleyHelper.ExtractActualData((byte[])read.Content, true);
        if (!analysis.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(analysis);
        }
        return OperateResultExOne.CreateSuccessResult(analysis.Content1);
    }

    public OperateResultExOne<byte[]> ReadSegment(String address, int startIndex, int length) {
        try {
            OperateResultExThree<byte[], Short, Boolean> analysis;
            ArrayList<Byte> bytesContent = new ArrayList<Byte>();
            do {
                OperateResultExOne<byte[]> read = this.ReadByCips(Arrays.asList(new byte[][]{AllenBradleyHelper.PackRequestReadSegment(address, startIndex, length)}));
                if (!read.IsSuccess) {
                    return read;
                }
                analysis = AllenBradleyHelper.ExtractActualData((byte[])read.Content, true);
                if (!analysis.IsSuccess) {
                    return OperateResultExOne.CreateFailedResult(analysis);
                }
                startIndex += ((byte[])analysis.Content1).length;
                for (int i = 0; i < ((byte[])analysis.Content1).length; ++i) {
                    bytesContent.add(((byte[])analysis.Content1)[i]);
                }
            } while (((Boolean)analysis.Content3).booleanValue());
            byte[] buffer = new byte[bytesContent.size()];
            for (int i = 0; i < buffer.length; ++i) {
                buffer[i] = (Byte)bytesContent.get(i);
            }
            return OperateResultExOne.CreateSuccessResult(buffer);
        }
        catch (Exception ex) {
            return new OperateResultExOne<byte[]>("Address Wrong:" + ex.getMessage());
        }
    }

    private OperateResultExOne<byte[]> ReadByCips(List<byte[]> cips) {
        OperateResultExOne<byte[]> read = this.ReadCipFromServer(cips);
        if (!read.IsSuccess) {
            return read;
        }
        OperateResultExThree<byte[], Short, Boolean> analysis = AllenBradleyHelper.ExtractActualData((byte[])read.Content, true);
        if (!analysis.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(analysis);
        }
        return OperateResultExOne.CreateSuccessResult(analysis.Content1);
    }

    public OperateResultExOne<byte[]> ReadCipFromServer(List<byte[]> cips) {
        try {
            byte[] byArray;
            if (this.PortSlot == null) {
                byte[] byArray2 = new byte[2];
                byArray2[0] = 1;
                byArray = byArray2;
                byArray2[1] = this.Slot;
            } else {
                byArray = this.PortSlot;
            }
            byte[] commandSpecificData = AllenBradleyHelper.PackCommandSpecificData(AllenBradleyHelper.PackCommandService(byArray, cips));
            byte[] command = AllenBradleyHelper.PackRequestHeader(111, this.SessionHandle, commandSpecificData);
            OperateResultExOne<byte[]> read = this.ReadFromCoreServer(command);
            if (!read.IsSuccess) {
                return read;
            }
            OperateResult check = this.CheckResponse((byte[])read.Content);
            if (!check.IsSuccess) {
                return OperateResultExOne.CreateFailedResult(check);
            }
            return OperateResultExOne.CreateSuccessResult(read.Content);
        }
        catch (Exception ex) {
            return new OperateResultExOne<byte[]>(ex.getMessage());
        }
    }

    @Override
    public OperateResultExOne<Boolean> ReadBool(String address) {
        OperateResultExOne<byte[]> read = this.Read(address, (short)1);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return OperateResultExOne.CreateSuccessResult(this.getByteTransform().TransBool((byte[])read.Content, 0));
    }

    public OperateResultExOne<boolean[]> ReadBoolArray(String address) {
        OperateResultExOne<byte[]> read = this.Read(address, (short)1);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return OperateResultExOne.CreateSuccessResult(this.getByteTransform().TransBool((byte[])read.Content, 0, ((byte[])read.Content).length));
    }

    public OperateResultExOne<Byte> ReadByte(String address) {
        OperateResultExOne<byte[]> read = this.Read(address, (short)1);
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        return OperateResultExOne.CreateSuccessResult(this.getByteTransform().TransByte((byte[])read.Content, 0));
    }

    @Override
    public OperateResultExOne<short[]> ReadInt16(String address, final short length) {
        return ByteTransformHelper.GetResultFromBytes(this.Read(address, length), new FunctionOperateExOne<byte[], short[]>(){

            @Override
            public short[] Action(byte[] content) {
                return AllenBradleyNet.this.getByteTransform().TransInt16(content, 0, length);
            }
        });
    }

    @Override
    public OperateResultExOne<int[]> ReadInt32(String address, final short length) {
        return ByteTransformHelper.GetResultFromBytes(this.Read(address, length), new FunctionOperateExOne<byte[], int[]>(){

            @Override
            public int[] Action(byte[] content) {
                return AllenBradleyNet.this.getByteTransform().TransInt32(content, 0, length);
            }
        });
    }

    @Override
    public OperateResultExOne<float[]> ReadFloat(String address, final short length) {
        return ByteTransformHelper.GetResultFromBytes(this.Read(address, length), new FunctionOperateExOne<byte[], float[]>(){

            @Override
            public float[] Action(byte[] content) {
                return AllenBradleyNet.this.getByteTransform().TransSingle(content, 0, length);
            }
        });
    }

    @Override
    public OperateResultExOne<long[]> ReadInt64(String address, final short length) {
        return ByteTransformHelper.GetResultFromBytes(this.Read(address, length), new FunctionOperateExOne<byte[], long[]>(){

            @Override
            public long[] Action(byte[] content) {
                return AllenBradleyNet.this.getByteTransform().TransInt64(content, 0, length);
            }
        });
    }

    @Override
    public OperateResultExOne<double[]> ReadDouble(String address, final short length) {
        return ByteTransformHelper.GetResultFromBytes(this.Read(address, length), new FunctionOperateExOne<byte[], double[]>(){

            @Override
            public double[] Action(byte[] content) {
                return AllenBradleyNet.this.getByteTransform().TransDouble(content, 0, length);
            }
        });
    }

    public OperateResultExOne<String> ReadString(String address) {
        return this.ReadString(address, (short)1, "ascii");
    }

    @Override
    public OperateResultExOne<String> ReadString(String address, short length, String encoding) {
        try {
            OperateResultExOne<byte[]> read = this.Read(address, length);
            if (!read.IsSuccess) {
                return OperateResultExOne.CreateFailedResult(read);
            }
            if (((byte[])read.Content).length >= 6) {
                int strLength = Utilities.getInt((byte[])read.Content, 2);
                return OperateResultExOne.CreateSuccessResult(new String((byte[])read.Content, 6, strLength, encoding));
            }
            return OperateResultExOne.CreateSuccessResult(new String((byte[])read.Content, encoding));
        }
        catch (Exception ex) {
            return new OperateResultExOne<String>(ex.getMessage());
        }
    }

    public OperateResult WriteTag(String address, short typeCode, byte[] value) {
        return this.WriteTag(address, typeCode, value, 1);
    }

    public OperateResult WriteTag(String address, short typeCode, byte[] value, int length) {
        OperateResultExOne<byte[]> command = this.BuildWriteCommand(address, typeCode, value, length);
        if (!command.IsSuccess) {
            return command;
        }
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer((byte[])command.Content);
        if (!read.IsSuccess) {
            return read;
        }
        OperateResult check = this.CheckResponse((byte[])read.Content);
        if (!check.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(check);
        }
        return AllenBradleyHelper.ExtractActualData((byte[])read.Content, false);
    }

    @Override
    public OperateResult Write(String address, short[] values) {
        return this.WriteTag(address, (short)195, this.getByteTransform().TransByte(values), values.length);
    }

    @Override
    public OperateResult Write(String address, int[] values) {
        return this.WriteTag(address, (short)196, this.getByteTransform().TransByte(values), values.length);
    }

    @Override
    public OperateResult Write(String address, float[] values) {
        return this.WriteTag(address, (short)202, this.getByteTransform().TransByte(values), values.length);
    }

    @Override
    public OperateResult Write(String address, long[] values) {
        return this.WriteTag(address, (short)197, this.getByteTransform().TransByte(values), values.length);
    }

    @Override
    public OperateResult Write(String address, double[] values) {
        return this.WriteTag(address, (short)203, this.getByteTransform().TransByte(values), values.length);
    }

    @Override
    public OperateResult Write(String address, String value) {
        if (Utilities.IsStringNullOrEmpty(value)) {
            value = "";
        }
        try {
            byte[] data = value.getBytes("ascii");
            OperateResult write = this.Write(address + ".LEN", data.length);
            if (!write.IsSuccess) {
                return write;
            }
            byte[] buffer = SoftBasic.ArrayExpandToLengthEven(data);
            return this.WriteTag(address + ".DATA[0]", (short)194, buffer, data.length);
        }
        catch (Exception ex) {
            return new OperateResult(ex.getMessage());
        }
    }

    @Override
    public OperateResult Write(String address, boolean value) {
        byte[] byArray;
        if (value) {
            byte[] byArray2 = new byte[2];
            byArray2[0] = -1;
            byArray = byArray2;
            byArray2[1] = -1;
        } else {
            byte[] byArray3 = new byte[2];
            byArray3[0] = 0;
            byArray = byArray3;
            byArray3[1] = 0;
        }
        return this.WriteTag(address, (short)193, byArray);
    }

    public OperateResult Write(String address, byte value) {
        return this.WriteTag(address, (short)194, new byte[]{value, 0});
    }

    public byte[] RegisterSessionHandle() {
        byte[] commandSpecificData = new byte[]{1, 0, 0, 0};
        return AllenBradleyHelper.PackRequestHeader(101, 0, commandSpecificData);
    }

    public byte[] UnRegisterSessionHandle() {
        return AllenBradleyHelper.PackRequestHeader(102, this.SessionHandle, new byte[0]);
    }

    private OperateResult CheckResponse(byte[] response) {
        try {
            int status = this.getByteTransform().TransInt32(response, 8);
            if (status == 0) {
                return OperateResult.CreateSuccessResult();
            }
            String msg = "";
            switch (status) {
                case 1: {
                    msg = StringResources.Language.AllenBradleySessionStatus01();
                    break;
                }
                case 2: {
                    msg = StringResources.Language.AllenBradleySessionStatus02();
                    break;
                }
                case 3: {
                    msg = StringResources.Language.AllenBradleySessionStatus03();
                    break;
                }
                case 100: {
                    msg = StringResources.Language.AllenBradleySessionStatus64();
                    break;
                }
                case 101: {
                    msg = StringResources.Language.AllenBradleySessionStatus65();
                    break;
                }
                case 105: {
                    msg = StringResources.Language.AllenBradleySessionStatus69();
                    break;
                }
                default: {
                    msg = StringResources.Language.UnknownError();
                }
            }
            return new OperateResult(status, msg);
        }
        catch (Exception ex) {
            return new OperateResult(ex.getMessage());
        }
    }

    @Override
    public String toString() {
        return "AllenBradleyNet[" + this.getIpAddress() + ":" + this.getPort() + "]";
    }
}

