/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Profinet.Melsec;

import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.Address.McAddressData;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.Core.Types.OperateResultExTwo;
import HslCommunication.Profinet.Melsec.MelsecA1EDataType;
import HslCommunication.Profinet.Melsec.MelsecMcDataType;
import HslCommunication.StringResources;
import HslCommunication.Utilities;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class MelsecHelper {
    public static OperateResultExTwo<MelsecA1EDataType, Integer> McA1EAnalysisAddress(String address) {
        OperateResultExTwo<MelsecA1EDataType, Integer> result = new OperateResultExTwo<MelsecA1EDataType, Integer>();
        try {
            switch (address.charAt(0)) {
                case 'T': 
                case 't': {
                    if (address.charAt(1) == 'S' || address.charAt(1) == 's') {
                        result.Content1 = MelsecA1EDataType.TS;
                        result.Content2 = Integer.parseInt(address.substring(2), MelsecA1EDataType.TS.getFromBase());
                        break;
                    }
                    if (address.charAt(1) == 'C' || address.charAt(1) == 'c') {
                        result.Content1 = MelsecA1EDataType.TC;
                        result.Content2 = Integer.parseInt(address.substring(2), MelsecA1EDataType.TC.getFromBase());
                        break;
                    }
                    if (address.charAt(1) == 'N' || address.charAt(1) == 'n') {
                        result.Content1 = MelsecA1EDataType.TN;
                        result.Content2 = Integer.parseInt(address.substring(2), MelsecA1EDataType.TN.getFromBase());
                        break;
                    }
                    throw new Exception(StringResources.Language.NotSupportedDataType());
                }
                case 'C': 
                case 'c': {
                    if (address.charAt(1) == 'S' || address.charAt(1) == 's') {
                        result.Content1 = MelsecA1EDataType.CS;
                        result.Content2 = Integer.parseInt(address.substring(2), MelsecA1EDataType.CS.getFromBase());
                        break;
                    }
                    if (address.charAt(1) == 'C' || address.charAt(1) == 'c') {
                        result.Content1 = MelsecA1EDataType.CC;
                        result.Content2 = Integer.parseInt(address.substring(2), MelsecA1EDataType.CC.getFromBase());
                        break;
                    }
                    if (address.charAt(1) == 'N' || address.charAt(1) == 'n') {
                        result.Content1 = MelsecA1EDataType.CN;
                        result.Content2 = Integer.parseInt(address.substring(2), MelsecA1EDataType.CN.getFromBase());
                        break;
                    }
                    throw new Exception(StringResources.Language.NotSupportedDataType());
                }
                case 'X': 
                case 'x': {
                    result.Content1 = MelsecA1EDataType.X;
                    address = address.substring(1);
                    if (address.startsWith("0")) {
                        result.Content2 = Integer.parseInt(address, 8);
                        break;
                    }
                    result.Content2 = Integer.parseInt(address, MelsecA1EDataType.X.getFromBase());
                    break;
                }
                case 'Y': 
                case 'y': {
                    result.Content1 = MelsecA1EDataType.Y;
                    address = address.substring(1);
                    if (address.startsWith("0")) {
                        result.Content2 = Integer.parseInt(address, 8);
                        break;
                    }
                    result.Content2 = Integer.parseInt(address, MelsecA1EDataType.Y.getFromBase());
                    break;
                }
                case 'M': 
                case 'm': {
                    result.Content1 = MelsecA1EDataType.M;
                    result.Content2 = Integer.parseInt(address.substring(1), MelsecA1EDataType.M.getFromBase());
                    break;
                }
                case 'S': 
                case 's': {
                    result.Content1 = MelsecA1EDataType.S;
                    result.Content2 = Integer.parseInt(address.substring(1), MelsecA1EDataType.S.getFromBase());
                    break;
                }
                case 'F': 
                case 'f': {
                    result.Content1 = MelsecA1EDataType.F;
                    result.Content2 = Integer.parseInt(address.substring(1), MelsecA1EDataType.F.getFromBase());
                    break;
                }
                case 'B': 
                case 'b': {
                    result.Content1 = MelsecA1EDataType.B;
                    result.Content2 = Integer.parseInt(address.substring(1), MelsecA1EDataType.B.getFromBase());
                    break;
                }
                case 'D': 
                case 'd': {
                    result.Content1 = MelsecA1EDataType.D;
                    result.Content2 = Integer.parseInt(address.substring(1), MelsecA1EDataType.D.getFromBase());
                    break;
                }
                case 'R': 
                case 'r': {
                    result.Content1 = MelsecA1EDataType.R;
                    result.Content2 = Integer.parseInt(address.substring(1), MelsecA1EDataType.R.getFromBase());
                    break;
                }
                case 'W': 
                case 'w': {
                    result.Content1 = MelsecA1EDataType.W;
                    result.Content2 = Integer.parseInt(address.substring(1), MelsecA1EDataType.W.getFromBase());
                    break;
                }
                default: {
                    throw new Exception(StringResources.Language.NotSupportedDataType());
                }
            }
        }
        catch (Exception ex) {
            result.Message = ex.getMessage();
            return result;
        }
        result.IsSuccess = true;
        return result;
    }

    public static byte[] BuildBytesFromData(byte value) {
        return Utilities.getBytes(String.format("%02x", value), "ASCII");
    }

    public static byte[] BuildBytesFromData(short value) {
        return Utilities.getBytes(String.format("%04x", value), "ASCII");
    }

    public static byte[] BuildBytesFromData(int value) {
        return Utilities.getBytes(String.format("%04x", value), "ASCII");
    }

    public static byte[] BuildBytesFromAddress(int address, MelsecMcDataType type) {
        return Utilities.getBytes(String.format(type.getFromBase() == 10 ? "%06d" : "%06x", address), "ASCII");
    }

    public static byte[] BuildBytesFromData(byte[] value) {
        byte[] buffer = new byte[value.length * 2];
        for (int i = 0; i < value.length; ++i) {
            byte[] data = MelsecHelper.BuildBytesFromData(value[i]);
            buffer[2 * i + 0] = data[0];
            buffer[2 * i + 1] = data[1];
        }
        return buffer;
    }

    public static byte[] TransBoolArrayToByteData(byte[] value) {
        int length = value.length % 2 == 0 ? value.length / 2 : value.length / 2 + 1;
        byte[] buffer = new byte[length];
        for (int i = 0; i < length; ++i) {
            if (value[i * 2 + 0] != 0) {
                int n = i;
                buffer[n] = (byte)(buffer[n] + 16);
            }
            if (i * 2 + 1 >= value.length || value[i * 2 + 1] == 0) continue;
            int n = i;
            buffer[n] = (byte)(buffer[n] + 1);
        }
        return buffer;
    }

    public static byte[] TransBoolArrayToByteData(boolean[] value) {
        int length = (value.length + 1) / 2;
        byte[] buffer = new byte[length];
        for (int i = 0; i < length; ++i) {
            if (value[i * 2 + 0]) {
                int n = i;
                buffer[n] = (byte)(buffer[n] + 16);
            }
            if (i * 2 + 1 >= value.length || !value[i * 2 + 1]) continue;
            int n = i;
            buffer[n] = (byte)(buffer[n] + 1);
        }
        return buffer;
    }

    public static byte[] FxCalculateCRC(byte[] data) {
        int sum = 0;
        for (int i = 1; i < data.length - 2; ++i) {
            sum += data[i];
        }
        return MelsecHelper.BuildBytesFromData((byte)sum);
    }

    public static boolean CheckCRC(byte[] data) {
        byte[] crc = MelsecHelper.FxCalculateCRC(data);
        if (crc[0] != data[data.length - 2]) {
            return false;
        }
        return crc[1] == data[data.length - 1];
    }

    public static byte[] BuildReadMcCoreCommand(McAddressData addressData, boolean isBit) {
        byte[] command = new byte[]{1, 4, isBit ? (byte)1 : 0, 0, Utilities.getBytes(addressData.getAddressStart())[0], Utilities.getBytes(addressData.getAddressStart())[1], Utilities.getBytes(addressData.getAddressStart())[2], addressData.getMcDataType().getDataCode(), (byte)(addressData.getLength() % 256), (byte)(addressData.getLength() / 256)};
        return command;
    }

    public static byte[] BuildAsciiReadMcCoreCommand(McAddressData addressData, boolean isBit) {
        byte[] command = new byte[]{48, 52, 48, 49, 48, 48, 48, isBit ? (byte)49 : 48, addressData.getMcDataType().getAsciiCode().getBytes(StandardCharsets.US_ASCII)[0], addressData.getMcDataType().getAsciiCode().getBytes(StandardCharsets.US_ASCII)[1], MelsecHelper.BuildBytesFromAddress(addressData.getAddressStart(), addressData.getMcDataType())[0], MelsecHelper.BuildBytesFromAddress(addressData.getAddressStart(), addressData.getMcDataType())[1], MelsecHelper.BuildBytesFromAddress(addressData.getAddressStart(), addressData.getMcDataType())[2], MelsecHelper.BuildBytesFromAddress(addressData.getAddressStart(), addressData.getMcDataType())[3], MelsecHelper.BuildBytesFromAddress(addressData.getAddressStart(), addressData.getMcDataType())[4], MelsecHelper.BuildBytesFromAddress(addressData.getAddressStart(), addressData.getMcDataType())[5], SoftBasic.BuildAsciiBytesFrom((short)addressData.getLength())[0], SoftBasic.BuildAsciiBytesFrom((short)addressData.getLength())[1], SoftBasic.BuildAsciiBytesFrom((short)addressData.getLength())[2], SoftBasic.BuildAsciiBytesFrom((short)addressData.getLength())[3]};
        return command;
    }

    public static byte[] BuildWriteWordCoreCommand(McAddressData addressData, byte[] value) {
        if (value == null) {
            value = new byte[]{};
        }
        byte[] command = new byte[10 + value.length];
        command[0] = 1;
        command[1] = 20;
        command[2] = 0;
        command[3] = 0;
        command[4] = Utilities.getBytes(addressData.getAddressStart())[0];
        command[5] = Utilities.getBytes(addressData.getAddressStart())[1];
        command[6] = Utilities.getBytes(addressData.getAddressStart())[2];
        command[7] = addressData.getMcDataType().getDataCode();
        command[8] = (byte)(value.length / 2 % 256);
        command[9] = (byte)(value.length / 2 / 256);
        System.arraycopy(value, 0, command, 10, value.length);
        return command;
    }

    public static byte[] BuildAsciiWriteWordCoreCommand(McAddressData addressData, byte[] value) {
        value = MelsecHelper.TransByteArrayToAsciiByteArray(value);
        byte[] command = new byte[20 + value.length];
        command[0] = 49;
        command[1] = 52;
        command[2] = 48;
        command[3] = 49;
        command[4] = 48;
        command[5] = 48;
        command[6] = 48;
        command[7] = 48;
        command[8] = addressData.getMcDataType().getAsciiCode().getBytes(StandardCharsets.US_ASCII)[0];
        command[9] = addressData.getMcDataType().getAsciiCode().getBytes(StandardCharsets.US_ASCII)[1];
        command[10] = MelsecHelper.BuildBytesFromAddress(addressData.getAddressStart(), addressData.getMcDataType())[0];
        command[11] = MelsecHelper.BuildBytesFromAddress(addressData.getAddressStart(), addressData.getMcDataType())[1];
        command[12] = MelsecHelper.BuildBytesFromAddress(addressData.getAddressStart(), addressData.getMcDataType())[2];
        command[13] = MelsecHelper.BuildBytesFromAddress(addressData.getAddressStart(), addressData.getMcDataType())[3];
        command[14] = MelsecHelper.BuildBytesFromAddress(addressData.getAddressStart(), addressData.getMcDataType())[4];
        command[15] = MelsecHelper.BuildBytesFromAddress(addressData.getAddressStart(), addressData.getMcDataType())[5];
        command[16] = SoftBasic.BuildAsciiBytesFrom((short)(value.length / 4))[0];
        command[17] = SoftBasic.BuildAsciiBytesFrom((short)(value.length / 4))[1];
        command[18] = SoftBasic.BuildAsciiBytesFrom((short)(value.length / 4))[2];
        command[19] = SoftBasic.BuildAsciiBytesFrom((short)(value.length / 4))[3];
        System.arraycopy(value, 0, command, 20, value.length);
        return command;
    }

    public static byte[] BuildWriteBitCoreCommand(McAddressData addressData, boolean[] value) {
        if (value == null) {
            value = new boolean[]{};
        }
        byte[] buffer = MelsecHelper.TransBoolArrayToByteData(value);
        byte[] command = new byte[10 + buffer.length];
        command[0] = 1;
        command[1] = 20;
        command[2] = 1;
        command[3] = 0;
        command[4] = Utilities.getBytes(addressData.getAddressStart())[0];
        command[5] = Utilities.getBytes(addressData.getAddressStart())[1];
        command[6] = Utilities.getBytes(addressData.getAddressStart())[2];
        command[7] = addressData.getMcDataType().getDataCode();
        command[8] = (byte)(value.length % 256);
        command[9] = (byte)(value.length / 256);
        System.arraycopy(buffer, 0, command, 10, buffer.length);
        return command;
    }

    public static byte[] BuildAsciiWriteBitCoreCommand(McAddressData addressData, boolean[] value) {
        if (value == null) {
            value = new boolean[]{};
        }
        byte[] buffer = new byte[value.length];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = value[i] ? 49 : 48;
        }
        byte[] command = new byte[20 + buffer.length];
        command[0] = 49;
        command[1] = 52;
        command[2] = 48;
        command[3] = 49;
        command[4] = 48;
        command[5] = 48;
        command[6] = 48;
        command[7] = 49;
        command[8] = addressData.getMcDataType().getAsciiCode().getBytes(StandardCharsets.US_ASCII)[0];
        command[9] = addressData.getMcDataType().getAsciiCode().getBytes(StandardCharsets.US_ASCII)[1];
        command[10] = MelsecHelper.BuildBytesFromAddress(addressData.getAddressStart(), addressData.getMcDataType())[0];
        command[11] = MelsecHelper.BuildBytesFromAddress(addressData.getAddressStart(), addressData.getMcDataType())[1];
        command[12] = MelsecHelper.BuildBytesFromAddress(addressData.getAddressStart(), addressData.getMcDataType())[2];
        command[13] = MelsecHelper.BuildBytesFromAddress(addressData.getAddressStart(), addressData.getMcDataType())[3];
        command[14] = MelsecHelper.BuildBytesFromAddress(addressData.getAddressStart(), addressData.getMcDataType())[4];
        command[15] = MelsecHelper.BuildBytesFromAddress(addressData.getAddressStart(), addressData.getMcDataType())[5];
        command[16] = SoftBasic.BuildAsciiBytesFrom((short)value.length)[0];
        command[17] = SoftBasic.BuildAsciiBytesFrom((short)value.length)[1];
        command[18] = SoftBasic.BuildAsciiBytesFrom((short)value.length)[2];
        command[19] = SoftBasic.BuildAsciiBytesFrom((short)value.length)[3];
        System.arraycopy(buffer, 0, command, 20, buffer.length);
        return command;
    }

    public static byte[] BuildReadMcCoreExtendCommand(McAddressData addressData, short extend, boolean isBit) {
        byte[] command = new byte[]{1, 4, isBit ? (byte)-127 : -128, 0, 0, 0, Utilities.getBytes(addressData.getAddressStart())[0], Utilities.getBytes(addressData.getAddressStart())[1], Utilities.getBytes(addressData.getAddressStart())[2], addressData.getMcDataType().getDataCode(), 0, 0, Utilities.getBytes(extend)[0], Utilities.getBytes(extend)[1], -7, (byte)(addressData.getLength() % 256), (byte)(addressData.getLength() / 256)};
        return command;
    }

    public static byte[] BuildReadRandomWordCommand(McAddressData[] address) {
        byte[] command = new byte[6 + address.length * 4];
        command[0] = 3;
        command[1] = 4;
        command[2] = 0;
        command[3] = 0;
        command[4] = (byte)address.length;
        command[5] = 0;
        for (int i = 0; i < address.length; ++i) {
            command[i * 4 + 6] = Utilities.getBytes(address[i].getAddressStart())[0];
            command[i * 4 + 7] = Utilities.getBytes(address[i].getAddressStart())[1];
            command[i * 4 + 8] = Utilities.getBytes(address[i].getAddressStart())[2];
            command[i * 4 + 9] = address[i].getMcDataType().getDataCode();
        }
        return command;
    }

    public static byte[] BuildReadRandomCommand(McAddressData[] address) {
        byte[] command = new byte[6 + address.length * 6];
        command[0] = 6;
        command[1] = 4;
        command[2] = 0;
        command[3] = 0;
        command[4] = (byte)address.length;
        command[5] = 0;
        for (int i = 0; i < address.length; ++i) {
            command[i * 6 + 6] = Utilities.getBytes(address[i].getAddressStart())[0];
            command[i * 6 + 7] = Utilities.getBytes(address[i].getAddressStart())[1];
            command[i * 6 + 8] = Utilities.getBytes(address[i].getAddressStart())[2];
            command[i * 6 + 9] = address[i].getMcDataType().getDataCode();
            command[i * 6 + 10] = (byte)(address[i].getLength() % 256);
            command[i * 6 + 11] = (byte)(address[i].getLength() / 256);
        }
        return command;
    }

    public static byte[] BuildAsciiReadRandomWordCommand(McAddressData[] address) {
        byte[] command = new byte[12 + address.length * 8];
        command[0] = 48;
        command[1] = 52;
        command[2] = 48;
        command[3] = 51;
        command[4] = 48;
        command[5] = 48;
        command[6] = 48;
        command[7] = 48;
        command[8] = SoftBasic.BuildAsciiBytesFrom((byte)address.length)[0];
        command[9] = SoftBasic.BuildAsciiBytesFrom((byte)address.length)[1];
        command[10] = 48;
        command[11] = 48;
        for (int i = 0; i < address.length; ++i) {
            command[i * 8 + 12] = address[i].getMcDataType().getAsciiCode().getBytes(StandardCharsets.US_ASCII)[0];
            command[i * 8 + 13] = address[i].getMcDataType().getAsciiCode().getBytes(StandardCharsets.US_ASCII)[1];
            command[i * 8 + 14] = MelsecHelper.BuildBytesFromAddress(address[i].getAddressStart(), address[i].getMcDataType())[0];
            command[i * 8 + 15] = MelsecHelper.BuildBytesFromAddress(address[i].getAddressStart(), address[i].getMcDataType())[1];
            command[i * 8 + 16] = MelsecHelper.BuildBytesFromAddress(address[i].getAddressStart(), address[i].getMcDataType())[2];
            command[i * 8 + 17] = MelsecHelper.BuildBytesFromAddress(address[i].getAddressStart(), address[i].getMcDataType())[3];
            command[i * 8 + 18] = MelsecHelper.BuildBytesFromAddress(address[i].getAddressStart(), address[i].getMcDataType())[4];
            command[i * 8 + 19] = MelsecHelper.BuildBytesFromAddress(address[i].getAddressStart(), address[i].getMcDataType())[5];
        }
        return command;
    }

    public static byte[] BuildAsciiReadRandomCommand(McAddressData[] address) {
        byte[] command = new byte[12 + address.length * 12];
        command[0] = 48;
        command[1] = 52;
        command[2] = 48;
        command[3] = 54;
        command[4] = 48;
        command[5] = 48;
        command[6] = 48;
        command[7] = 48;
        command[8] = SoftBasic.BuildAsciiBytesFrom((byte)address.length)[0];
        command[9] = SoftBasic.BuildAsciiBytesFrom((byte)address.length)[1];
        command[10] = 48;
        command[11] = 48;
        for (int i = 0; i < address.length; ++i) {
            command[i * 12 + 12] = address[i].getMcDataType().getAsciiCode().getBytes(StandardCharsets.US_ASCII)[0];
            command[i * 12 + 13] = address[i].getMcDataType().getAsciiCode().getBytes(StandardCharsets.US_ASCII)[1];
            command[i * 12 + 14] = MelsecHelper.BuildBytesFromAddress(address[i].getAddressStart(), address[i].getMcDataType())[0];
            command[i * 12 + 15] = MelsecHelper.BuildBytesFromAddress(address[i].getAddressStart(), address[i].getMcDataType())[1];
            command[i * 12 + 16] = MelsecHelper.BuildBytesFromAddress(address[i].getAddressStart(), address[i].getMcDataType())[2];
            command[i * 12 + 17] = MelsecHelper.BuildBytesFromAddress(address[i].getAddressStart(), address[i].getMcDataType())[3];
            command[i * 12 + 18] = MelsecHelper.BuildBytesFromAddress(address[i].getAddressStart(), address[i].getMcDataType())[4];
            command[i * 12 + 19] = MelsecHelper.BuildBytesFromAddress(address[i].getAddressStart(), address[i].getMcDataType())[5];
            command[i * 12 + 20] = SoftBasic.BuildAsciiBytesFrom((short)address[i].getLength())[0];
            command[i * 12 + 21] = SoftBasic.BuildAsciiBytesFrom((short)address[i].getLength())[1];
            command[i * 12 + 22] = SoftBasic.BuildAsciiBytesFrom((short)address[i].getLength())[2];
            command[i * 12 + 23] = SoftBasic.BuildAsciiBytesFrom((short)address[i].getLength())[3];
        }
        return command;
    }

    public static byte[] BuildReadTag(String[] tags, short[] lengths) throws Exception {
        if (tags.length != lengths.length) {
            throw new Exception(StringResources.Language.TwoParametersLengthIsNotSame());
        }
        ByteArrayOutputStream command = new ByteArrayOutputStream();
        command.write(26);
        command.write(4);
        command.write(0);
        command.write(0);
        command.write(Utilities.getBytes(tags.length)[0]);
        command.write(Utilities.getBytes(tags.length)[1]);
        command.write(0);
        command.write(0);
        for (int i = 0; i < tags.length; ++i) {
            byte[] tagBuffer = tags[i].getBytes(StandardCharsets.UTF_16);
            command.write(Utilities.getBytes(tagBuffer.length / 2)[0]);
            command.write(Utilities.getBytes(tagBuffer.length / 2)[1]);
            command.write(tagBuffer, 0, tagBuffer.length);
            command.write(1);
            command.write(0);
            command.write(Utilities.getBytes(lengths[i] * 2)[0]);
            command.write(Utilities.getBytes(lengths[i] * 2)[1]);
        }
        byte[] buffer = command.toByteArray();
        command.close();
        return buffer;
    }

    public static OperateResultExOne<byte[]> ExtraTagData(byte[] content) {
        try {
            int count = Utilities.getUShort(content, 0);
            int index = 2;
            ArrayList<Byte> array = new ArrayList<Byte>(20);
            for (int i = 0; i < count; ++i) {
                int length = Utilities.getUShort(content, index + 2);
                Utilities.ArrayListAddArray(array, SoftBasic.BytesArraySelectMiddle(content, index + 4, length));
                index += 4 + length;
            }
            return OperateResultExOne.CreateSuccessResult(Utilities.getBytes(array));
        }
        catch (Exception ex) {
            return new OperateResultExOne<byte[]>(ex.getMessage() + " Source:" + SoftBasic.ByteToHexString(content, ' '));
        }
    }

    public static OperateResultExOne<byte[]> BuildReadMemoryCommand(String address, short length) {
        try {
            int add = Integer.parseInt(address);
            byte[] command = new byte[]{19, 6, Utilities.getBytes(add)[0], Utilities.getBytes(add)[1], Utilities.getBytes(add)[2], Utilities.getBytes(add)[3], (byte)(length % 256), (byte)(length / 256)};
            return OperateResultExOne.CreateSuccessResult(command);
        }
        catch (Exception ex) {
            return new OperateResultExOne<byte[]>(ex.getMessage());
        }
    }

    public static byte[] TransByteArrayToAsciiByteArray(byte[] value) {
        if (value == null) {
            return new byte[0];
        }
        byte[] buffer = new byte[value.length * 2];
        for (int i = 0; i < value.length / 2; ++i) {
            byte[] data = SoftBasic.BuildAsciiBytesFrom(Utilities.getShort(value, i * 2));
            System.arraycopy(data, 0, buffer, 4 * i, data.length);
        }
        return buffer;
    }

    public static String GetErrorDescription(int code) {
        switch (code) {
            case 2: {
                return StringResources.Language.MelsecError02();
            }
            case 81: {
                return StringResources.Language.MelsecError51();
            }
            case 82: {
                return StringResources.Language.MelsecError52();
            }
            case 84: {
                return StringResources.Language.MelsecError54();
            }
            case 85: {
                return StringResources.Language.MelsecError55();
            }
            case 86: {
                return StringResources.Language.MelsecError56();
            }
            case 88: {
                return StringResources.Language.MelsecError58();
            }
            case 89: {
                return StringResources.Language.MelsecError59();
            }
            case 49229: {
                return StringResources.Language.MelsecErrorC04D();
            }
            case 49232: {
                return StringResources.Language.MelsecErrorC050();
            }
            case 49233: 
            case 49234: 
            case 49235: 
            case 49236: {
                return StringResources.Language.MelsecErrorC051_54();
            }
            case 49237: {
                return StringResources.Language.MelsecErrorC055();
            }
            case 49238: {
                return StringResources.Language.MelsecErrorC056();
            }
            case 49239: {
                return StringResources.Language.MelsecErrorC057();
            }
            case 49240: {
                return StringResources.Language.MelsecErrorC058();
            }
            case 49241: {
                return StringResources.Language.MelsecErrorC059();
            }
            case 49242: 
            case 49243: {
                return StringResources.Language.MelsecErrorC05A_B();
            }
            case 49244: {
                return StringResources.Language.MelsecErrorC05C();
            }
            case 49245: {
                return StringResources.Language.MelsecErrorC05D();
            }
            case 49246: {
                return StringResources.Language.MelsecErrorC05E();
            }
            case 49247: {
                return StringResources.Language.MelsecErrorC05F();
            }
            case 49248: {
                return StringResources.Language.MelsecErrorC060();
            }
            case 49249: {
                return StringResources.Language.MelsecErrorC061();
            }
            case 49250: {
                return StringResources.Language.MelsecErrorC062();
            }
            case 49264: {
                return StringResources.Language.MelsecErrorC070();
            }
            case 49266: {
                return StringResources.Language.MelsecErrorC072();
            }
            case 49268: {
                return StringResources.Language.MelsecErrorC074();
            }
        }
        return StringResources.Language.MelsecPleaseReferToManualDocument();
    }
}

