/*
 * Decompiled with CFR 0.152.
 */
package HslCommunication.Profinet.Melsec;

import HslCommunication.BasicFramework.SoftBasic;
import HslCommunication.Core.Address.McAddressData;
import HslCommunication.Core.IMessage.INetMessage;
import HslCommunication.Core.IMessage.MelsecQnA3EAsciiMessage;
import HslCommunication.Core.Net.NetworkBase.NetworkDeviceBase;
import HslCommunication.Core.Transfer.RegularByteTransform;
import HslCommunication.Core.Types.OperateResult;
import HslCommunication.Core.Types.OperateResultExOne;
import HslCommunication.Profinet.Melsec.MelsecHelper;
import HslCommunication.Utilities;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class MelsecMcAsciiNet
extends NetworkDeviceBase {
    private byte NetworkNumber = 0;
    private byte NetworkStationNumber = 0;

    public MelsecMcAsciiNet() {
        this.WordLength = 1;
        this.setByteTransform(new RegularByteTransform());
    }

    public MelsecMcAsciiNet(String ipAddress, int port) {
        this.WordLength = 1;
        this.setIpAddress(ipAddress);
        this.setPort(port);
        this.setByteTransform(new RegularByteTransform());
    }

    @Override
    protected INetMessage GetNewNetMessage() {
        return new MelsecQnA3EAsciiMessage();
    }

    public byte getNetworkNumber() {
        return this.NetworkNumber;
    }

    public void setNetworkNumber(byte networkNumber) {
        this.NetworkNumber = networkNumber;
    }

    public byte getNetworkStationNumber() {
        return this.NetworkStationNumber;
    }

    public void setNetworkStationNumber(byte networkStationNumber) {
        this.NetworkStationNumber = networkStationNumber;
    }

    protected OperateResultExOne<McAddressData> McAnalysisAddress(String address, short length) {
        return McAddressData.ParseMelsecFrom(address, length);
    }

    @Override
    public OperateResultExOne<byte[]> Read(String address, short length) {
        OperateResultExOne<McAddressData> addressResult = this.McAnalysisAddress(address, length);
        if (!addressResult.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(addressResult);
        }
        ArrayList<Byte> bytesContent = new ArrayList<Byte>();
        short alreadyFinished = 0;
        while (alreadyFinished < length) {
            short readLength = (short)Math.min(length - alreadyFinished, 450);
            ((McAddressData)addressResult.Content).setLength(readLength);
            OperateResultExOne<byte[]> read = this.ReadAddressData((McAddressData)addressResult.Content);
            if (!read.IsSuccess) {
                return read;
            }
            Utilities.ArrayListAddArray(bytesContent, (byte[])read.Content);
            alreadyFinished = (short)(alreadyFinished + readLength);
            if (((McAddressData)addressResult.Content).getMcDataType().getDataType() == 0) {
                ((McAddressData)addressResult.Content).setAddressStart(((McAddressData)addressResult.Content).getAddressStart() + readLength);
                continue;
            }
            ((McAddressData)addressResult.Content).setAddressStart(((McAddressData)addressResult.Content).getAddressStart() + readLength * 16);
        }
        return OperateResultExOne.CreateSuccessResult(Utilities.getBytes(bytesContent));
    }

    private OperateResultExOne<byte[]> ReadAddressData(McAddressData addressData) {
        byte[] coreResult = MelsecHelper.BuildAsciiReadMcCoreCommand(addressData, false);
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcAsciiNet.PackMcCommand(coreResult, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        OperateResult check = MelsecMcAsciiNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(check);
        }
        return MelsecMcAsciiNet.ExtractActualData((byte[])read.Content, false);
    }

    @Override
    public OperateResultExOne<boolean[]> ReadBool(String address, short length) {
        OperateResultExOne<McAddressData> addressResult = this.McAnalysisAddress(address, (short)length);
        if (!addressResult.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(addressResult);
        }
        byte[] coreResult = MelsecHelper.BuildAsciiReadMcCoreCommand((McAddressData)addressResult.Content, true);
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcAsciiNet.PackMcCommand(coreResult, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(read);
        }
        OperateResult check = MelsecMcAsciiNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(check);
        }
        OperateResultExOne<byte[]> extract = MelsecMcAsciiNet.ExtractActualData((byte[])read.Content, true);
        if (!extract.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(extract);
        }
        boolean[] buffer = new boolean[length];
        for (int i = 0; i < length; ++i) {
            buffer[i] = ((byte[])extract.Content)[i] == 1;
        }
        return OperateResultExOne.CreateSuccessResult(buffer);
    }

    @Override
    public OperateResult Write(String address, byte[] value) {
        OperateResultExOne<McAddressData> addressResult = this.McAnalysisAddress(address, (short)0);
        if (!addressResult.IsSuccess) {
            return OperateResultExOne.CreateFailedResult(addressResult);
        }
        byte[] coreResult = MelsecHelper.BuildAsciiWriteWordCoreCommand((McAddressData)addressResult.Content, value);
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcAsciiNet.PackMcCommand(coreResult, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return read;
        }
        OperateResult check = MelsecMcAsciiNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return check;
        }
        return OperateResult.CreateSuccessResult();
    }

    @Override
    public OperateResult Write(String address, boolean[] values) {
        OperateResultExOne<McAddressData> addressResult = this.McAnalysisAddress(address, (short)0);
        if (!addressResult.IsSuccess) {
            return addressResult;
        }
        byte[] coreResult = MelsecHelper.BuildAsciiWriteBitCoreCommand((McAddressData)addressResult.Content, values);
        OperateResultExOne<byte[]> read = this.ReadFromCoreServer(MelsecMcAsciiNet.PackMcCommand(coreResult, this.NetworkNumber, this.NetworkStationNumber));
        if (!read.IsSuccess) {
            return read;
        }
        OperateResult check = MelsecMcAsciiNet.CheckResponseContent((byte[])read.Content);
        if (!check.IsSuccess) {
            return check;
        }
        return OperateResult.CreateSuccessResult();
    }

    @Override
    public String toString() {
        return "MelsecMcNet";
    }

    public static byte[] PackMcCommand(byte[] mcCore, byte networkNumber, byte networkStationNumber) {
        byte[] plcCommand = new byte[22 + mcCore.length];
        plcCommand[0] = 53;
        plcCommand[1] = 48;
        plcCommand[2] = 48;
        plcCommand[3] = 48;
        plcCommand[4] = MelsecHelper.BuildBytesFromData(networkNumber)[0];
        plcCommand[5] = MelsecHelper.BuildBytesFromData(networkNumber)[1];
        plcCommand[6] = 70;
        plcCommand[7] = 70;
        plcCommand[8] = 48;
        plcCommand[9] = 51;
        plcCommand[10] = 70;
        plcCommand[11] = 70;
        plcCommand[12] = MelsecHelper.BuildBytesFromData(networkStationNumber)[0];
        plcCommand[13] = MelsecHelper.BuildBytesFromData(networkStationNumber)[1];
        plcCommand[14] = MelsecHelper.BuildBytesFromData((short)(plcCommand.length - 18))[0];
        plcCommand[15] = MelsecHelper.BuildBytesFromData((short)(plcCommand.length - 18))[1];
        plcCommand[16] = MelsecHelper.BuildBytesFromData((short)(plcCommand.length - 18))[2];
        plcCommand[17] = MelsecHelper.BuildBytesFromData((short)(plcCommand.length - 18))[3];
        plcCommand[18] = 48;
        plcCommand[19] = 48;
        plcCommand[20] = 49;
        plcCommand[21] = 48;
        System.arraycopy(mcCore, 0, plcCommand, 22, mcCore.length);
        return plcCommand;
    }

    public static OperateResultExOne<byte[]> ExtractActualData(byte[] response, boolean isBit) {
        if (isBit) {
            byte[] Content = new byte[response.length - 22];
            for (int i = 22; i < response.length; ++i) {
                Content[i - 22] = response[i] == 48 ? (byte)0 : 1;
            }
            return OperateResultExOne.CreateSuccessResult(Content);
        }
        byte[] Content = new byte[(response.length - 22) / 2];
        for (int i = 0; i < Content.length / 2; ++i) {
            int tmp = Integer.parseInt(Utilities.getString(response, i * 4 + 22, 4, "ASCII"), 16);
            byte[] buffer = Utilities.getBytes(tmp);
            Content[i * 2 + 0] = buffer[0];
            Content[i * 2 + 1] = buffer[1];
        }
        return OperateResultExOne.CreateSuccessResult(Content);
    }

    public static OperateResult CheckResponseContent(byte[] content) {
        int errorCode = Integer.parseInt(new String(SoftBasic.BytesArraySelectMiddle(content, 18, 4), StandardCharsets.US_ASCII), 16);
        if (errorCode != 0) {
            return new OperateResult(errorCode, MelsecHelper.GetErrorDescription(errorCode));
        }
        return OperateResult.CreateSuccessResult();
    }
}

